// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Details about a reserved capacity offering for a training plan offering.
 *
 * For more information about how to reserve GPU capacity for your SageMaker HyperPod clusters using Amazon SageMaker Training Plan, see ` <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrainingPlan.html">CreateTrainingPlan</a> `.
 */
public class ReservedCapacityOffering private constructor(builder: Builder) {
    /**
     * The availability zone for the reserved capacity offering.
     */
    public val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The number of whole hours in the total duration for this reserved capacity offering.
     */
    public val durationHours: kotlin.Long? = builder.durationHours
    /**
     * The additional minutes beyond whole hours in the total duration for this reserved capacity offering.
     */
    public val durationMinutes: kotlin.Long? = builder.durationMinutes
    /**
     * The end time of the reserved capacity offering.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The number of instances in the reserved capacity offering.
     */
    public val instanceCount: kotlin.Int? = builder.instanceCount
    /**
     * The instance type for the reserved capacity offering.
     */
    public val instanceType: aws.sdk.kotlin.services.sagemaker.model.ReservedCapacityInstanceType? = builder.instanceType
    /**
     * The start time of the reserved capacity offering.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ReservedCapacityOffering = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReservedCapacityOffering(")
        append("availabilityZone=$availabilityZone,")
        append("durationHours=$durationHours,")
        append("durationMinutes=$durationMinutes,")
        append("endTime=$endTime,")
        append("instanceCount=$instanceCount,")
        append("instanceType=$instanceType,")
        append("startTime=$startTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (durationHours?.hashCode() ?: 0)
        result = 31 * result + (durationMinutes?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (instanceCount ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReservedCapacityOffering

        if (availabilityZone != other.availabilityZone) return false
        if (durationHours != other.durationHours) return false
        if (durationMinutes != other.durationMinutes) return false
        if (endTime != other.endTime) return false
        if (instanceCount != other.instanceCount) return false
        if (instanceType != other.instanceType) return false
        if (startTime != other.startTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ReservedCapacityOffering = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The availability zone for the reserved capacity offering.
         */
        public var availabilityZone: kotlin.String? = null
        /**
         * The number of whole hours in the total duration for this reserved capacity offering.
         */
        public var durationHours: kotlin.Long? = null
        /**
         * The additional minutes beyond whole hours in the total duration for this reserved capacity offering.
         */
        public var durationMinutes: kotlin.Long? = null
        /**
         * The end time of the reserved capacity offering.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of instances in the reserved capacity offering.
         */
        public var instanceCount: kotlin.Int? = null
        /**
         * The instance type for the reserved capacity offering.
         */
        public var instanceType: aws.sdk.kotlin.services.sagemaker.model.ReservedCapacityInstanceType? = null
        /**
         * The start time of the reserved capacity offering.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ReservedCapacityOffering) : this() {
            this.availabilityZone = x.availabilityZone
            this.durationHours = x.durationHours
            this.durationMinutes = x.durationMinutes
            this.endTime = x.endTime
            this.instanceCount = x.instanceCount
            this.instanceType = x.instanceType
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ReservedCapacityOffering = ReservedCapacityOffering(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
