// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Identifies a model that you want to host and the resources chosen to deploy for hosting it. If you are deploying multiple models, tell SageMaker how to distribute traffic among the models by specifying variant weights. For more information on production variants, check [ Production variants](https://docs.aws.amazon.com/sagemaker/latest/dg/model-ab-testing.html).
 */
public class ProductionVariant private constructor(builder: Builder) {
    /**
     * This parameter is no longer supported. Elastic Inference (EI) is no longer available.
     *
     * This parameter was used to specify the size of the EI instance to use for the production variant.
     */
    public val acceleratorType: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantAcceleratorType? = builder.acceleratorType
    /**
     * The timeout value, in seconds, for your inference container to pass health check by SageMaker Hosting. For more information about health check, see [How Your Container Should Respond to Health Check (Ping) Requests](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-inference-code.html#your-algorithms-inference-algo-ping-requests).
     */
    public val containerStartupHealthCheckTimeoutInSeconds: kotlin.Int? = builder.containerStartupHealthCheckTimeoutInSeconds
    /**
     * Specifies configuration for a core dump from the model container when the process crashes.
     */
    public val coreDumpConfig: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantCoreDumpConfig? = builder.coreDumpConfig
    /**
     * You can use this parameter to turn on native Amazon Web Services Systems Manager (SSM) access for a production variant behind an endpoint. By default, SSM access is disabled for all production variants behind an endpoint. You can turn on or turn off SSM access for a production variant behind an existing endpoint by creating a new endpoint configuration and calling `UpdateEndpoint`.
     */
    public val enableSsmAccess: kotlin.Boolean? = builder.enableSsmAccess
    /**
     * Specifies an option from a collection of preconfigured Amazon Machine Image (AMI) images. Each image is configured by Amazon Web Services with a set of software and driver versions. Amazon Web Services optimizes these configurations for different machine learning workloads.
     *
     * By selecting an AMI version, you can ensure that your inference environment is compatible with specific software requirements, such as CUDA driver versions, Linux kernel versions, or Amazon Web Services Neuron driver versions.
     *
     * The AMI version names, and their configurations, are the following:
     *
     * ## al2-ami-sagemaker-inference-gpu-2
     * + Accelerator: GPU
     * + NVIDIA driver version: 535.54.03
     * + CUDA driver version: 12.2
     * + Supported instance types: ml.g4dn.*, ml.g5.*, ml.g6.*, ml.p3.*, ml.p4d.*, ml.p4de.*, ml.p5.*
     */
    public val inferenceAmiVersion: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantInferenceAmiVersion? = builder.inferenceAmiVersion
    /**
     * Number of instances to launch initially.
     */
    public val initialInstanceCount: kotlin.Int? = builder.initialInstanceCount
    /**
     * Determines initial traffic distribution among all of the models that you specify in the endpoint configuration. The traffic to a production variant is determined by the ratio of the `VariantWeight` to the sum of all `VariantWeight` values across all ProductionVariants. If unspecified, it defaults to 1.0.
     */
    public val initialVariantWeight: kotlin.Float? = builder.initialVariantWeight
    /**
     * The ML compute instance type.
     */
    public val instanceType: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantInstanceType? = builder.instanceType
    /**
     * Settings that control the range in the number of instances that the endpoint provisions as it scales up or down to accommodate traffic.
     */
    public val managedInstanceScaling: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantManagedInstanceScaling? = builder.managedInstanceScaling
    /**
     * The timeout value, in seconds, to download and extract the model that you want to host from Amazon S3 to the individual inference instance associated with this production variant.
     */
    public val modelDataDownloadTimeoutInSeconds: kotlin.Int? = builder.modelDataDownloadTimeoutInSeconds
    /**
     * The name of the model that you want to host. This is the name that you specified when creating the model.
     */
    public val modelName: kotlin.String? = builder.modelName
    /**
     * Settings that control how the endpoint routes incoming traffic to the instances that the endpoint hosts.
     */
    public val routingConfig: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantRoutingConfig? = builder.routingConfig
    /**
     * The serverless configuration for an endpoint. Specifies a serverless endpoint configuration instead of an instance-based endpoint configuration.
     */
    public val serverlessConfig: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantServerlessConfig? = builder.serverlessConfig
    /**
     * The name of the production variant.
     */
    public val variantName: kotlin.String? = builder.variantName
    /**
     * The size, in GB, of the ML storage volume attached to individual inference instance associated with the production variant. Currently only Amazon EBS gp2 storage volumes are supported.
     */
    public val volumeSizeInGb: kotlin.Int? = builder.volumeSizeInGb

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ProductionVariant = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProductionVariant(")
        append("acceleratorType=$acceleratorType,")
        append("containerStartupHealthCheckTimeoutInSeconds=$containerStartupHealthCheckTimeoutInSeconds,")
        append("coreDumpConfig=$coreDumpConfig,")
        append("enableSsmAccess=$enableSsmAccess,")
        append("inferenceAmiVersion=$inferenceAmiVersion,")
        append("initialInstanceCount=$initialInstanceCount,")
        append("initialVariantWeight=$initialVariantWeight,")
        append("instanceType=$instanceType,")
        append("managedInstanceScaling=$managedInstanceScaling,")
        append("modelDataDownloadTimeoutInSeconds=$modelDataDownloadTimeoutInSeconds,")
        append("modelName=$modelName,")
        append("routingConfig=$routingConfig,")
        append("serverlessConfig=$serverlessConfig,")
        append("variantName=$variantName,")
        append("volumeSizeInGb=$volumeSizeInGb")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceleratorType?.hashCode() ?: 0
        result = 31 * result + (containerStartupHealthCheckTimeoutInSeconds ?: 0)
        result = 31 * result + (coreDumpConfig?.hashCode() ?: 0)
        result = 31 * result + (enableSsmAccess?.hashCode() ?: 0)
        result = 31 * result + (inferenceAmiVersion?.hashCode() ?: 0)
        result = 31 * result + (initialInstanceCount ?: 0)
        result = 31 * result + (initialVariantWeight?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (managedInstanceScaling?.hashCode() ?: 0)
        result = 31 * result + (modelDataDownloadTimeoutInSeconds ?: 0)
        result = 31 * result + (modelName?.hashCode() ?: 0)
        result = 31 * result + (routingConfig?.hashCode() ?: 0)
        result = 31 * result + (serverlessConfig?.hashCode() ?: 0)
        result = 31 * result + (variantName?.hashCode() ?: 0)
        result = 31 * result + (volumeSizeInGb ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProductionVariant

        if (acceleratorType != other.acceleratorType) return false
        if (containerStartupHealthCheckTimeoutInSeconds != other.containerStartupHealthCheckTimeoutInSeconds) return false
        if (coreDumpConfig != other.coreDumpConfig) return false
        if (enableSsmAccess != other.enableSsmAccess) return false
        if (inferenceAmiVersion != other.inferenceAmiVersion) return false
        if (initialInstanceCount != other.initialInstanceCount) return false
        if (!(initialVariantWeight?.equals(other.initialVariantWeight) ?: (other.initialVariantWeight == null))) return false
        if (instanceType != other.instanceType) return false
        if (managedInstanceScaling != other.managedInstanceScaling) return false
        if (modelDataDownloadTimeoutInSeconds != other.modelDataDownloadTimeoutInSeconds) return false
        if (modelName != other.modelName) return false
        if (routingConfig != other.routingConfig) return false
        if (serverlessConfig != other.serverlessConfig) return false
        if (variantName != other.variantName) return false
        if (volumeSizeInGb != other.volumeSizeInGb) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ProductionVariant = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * This parameter is no longer supported. Elastic Inference (EI) is no longer available.
         *
         * This parameter was used to specify the size of the EI instance to use for the production variant.
         */
        public var acceleratorType: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantAcceleratorType? = null
        /**
         * The timeout value, in seconds, for your inference container to pass health check by SageMaker Hosting. For more information about health check, see [How Your Container Should Respond to Health Check (Ping) Requests](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-inference-code.html#your-algorithms-inference-algo-ping-requests).
         */
        public var containerStartupHealthCheckTimeoutInSeconds: kotlin.Int? = null
        /**
         * Specifies configuration for a core dump from the model container when the process crashes.
         */
        public var coreDumpConfig: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantCoreDumpConfig? = null
        /**
         * You can use this parameter to turn on native Amazon Web Services Systems Manager (SSM) access for a production variant behind an endpoint. By default, SSM access is disabled for all production variants behind an endpoint. You can turn on or turn off SSM access for a production variant behind an existing endpoint by creating a new endpoint configuration and calling `UpdateEndpoint`.
         */
        public var enableSsmAccess: kotlin.Boolean? = null
        /**
         * Specifies an option from a collection of preconfigured Amazon Machine Image (AMI) images. Each image is configured by Amazon Web Services with a set of software and driver versions. Amazon Web Services optimizes these configurations for different machine learning workloads.
         *
         * By selecting an AMI version, you can ensure that your inference environment is compatible with specific software requirements, such as CUDA driver versions, Linux kernel versions, or Amazon Web Services Neuron driver versions.
         *
         * The AMI version names, and their configurations, are the following:
         *
         * ## al2-ami-sagemaker-inference-gpu-2
         * + Accelerator: GPU
         * + NVIDIA driver version: 535.54.03
         * + CUDA driver version: 12.2
         * + Supported instance types: ml.g4dn.*, ml.g5.*, ml.g6.*, ml.p3.*, ml.p4d.*, ml.p4de.*, ml.p5.*
         */
        public var inferenceAmiVersion: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantInferenceAmiVersion? = null
        /**
         * Number of instances to launch initially.
         */
        public var initialInstanceCount: kotlin.Int? = null
        /**
         * Determines initial traffic distribution among all of the models that you specify in the endpoint configuration. The traffic to a production variant is determined by the ratio of the `VariantWeight` to the sum of all `VariantWeight` values across all ProductionVariants. If unspecified, it defaults to 1.0.
         */
        public var initialVariantWeight: kotlin.Float? = null
        /**
         * The ML compute instance type.
         */
        public var instanceType: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantInstanceType? = null
        /**
         * Settings that control the range in the number of instances that the endpoint provisions as it scales up or down to accommodate traffic.
         */
        public var managedInstanceScaling: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantManagedInstanceScaling? = null
        /**
         * The timeout value, in seconds, to download and extract the model that you want to host from Amazon S3 to the individual inference instance associated with this production variant.
         */
        public var modelDataDownloadTimeoutInSeconds: kotlin.Int? = null
        /**
         * The name of the model that you want to host. This is the name that you specified when creating the model.
         */
        public var modelName: kotlin.String? = null
        /**
         * Settings that control how the endpoint routes incoming traffic to the instances that the endpoint hosts.
         */
        public var routingConfig: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantRoutingConfig? = null
        /**
         * The serverless configuration for an endpoint. Specifies a serverless endpoint configuration instead of an instance-based endpoint configuration.
         */
        public var serverlessConfig: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantServerlessConfig? = null
        /**
         * The name of the production variant.
         */
        public var variantName: kotlin.String? = null
        /**
         * The size, in GB, of the ML storage volume attached to individual inference instance associated with the production variant. Currently only Amazon EBS gp2 storage volumes are supported.
         */
        public var volumeSizeInGb: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ProductionVariant) : this() {
            this.acceleratorType = x.acceleratorType
            this.containerStartupHealthCheckTimeoutInSeconds = x.containerStartupHealthCheckTimeoutInSeconds
            this.coreDumpConfig = x.coreDumpConfig
            this.enableSsmAccess = x.enableSsmAccess
            this.inferenceAmiVersion = x.inferenceAmiVersion
            this.initialInstanceCount = x.initialInstanceCount
            this.initialVariantWeight = x.initialVariantWeight
            this.instanceType = x.instanceType
            this.managedInstanceScaling = x.managedInstanceScaling
            this.modelDataDownloadTimeoutInSeconds = x.modelDataDownloadTimeoutInSeconds
            this.modelName = x.modelName
            this.routingConfig = x.routingConfig
            this.serverlessConfig = x.serverlessConfig
            this.variantName = x.variantName
            this.volumeSizeInGb = x.volumeSizeInGb
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ProductionVariant = ProductionVariant(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ProductionVariantCoreDumpConfig] inside the given [block]
         */
        public fun coreDumpConfig(block: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantCoreDumpConfig.Builder.() -> kotlin.Unit) {
            this.coreDumpConfig = aws.sdk.kotlin.services.sagemaker.model.ProductionVariantCoreDumpConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ProductionVariantManagedInstanceScaling] inside the given [block]
         */
        public fun managedInstanceScaling(block: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantManagedInstanceScaling.Builder.() -> kotlin.Unit) {
            this.managedInstanceScaling = aws.sdk.kotlin.services.sagemaker.model.ProductionVariantManagedInstanceScaling.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ProductionVariantRoutingConfig] inside the given [block]
         */
        public fun routingConfig(block: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantRoutingConfig.Builder.() -> kotlin.Unit) {
            this.routingConfig = aws.sdk.kotlin.services.sagemaker.model.ProductionVariantRoutingConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ProductionVariantServerlessConfig] inside the given [block]
         */
        public fun serverlessConfig(block: aws.sdk.kotlin.services.sagemaker.model.ProductionVariantServerlessConfig.Builder.() -> kotlin.Unit) {
            this.serverlessConfig = aws.sdk.kotlin.services.sagemaker.model.ProductionVariantServerlessConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
