// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A VPC in Amazon VPC that's accessible to an optimized that you create with an optimization job. You can control access to and from your resources by configuring a VPC. For more information, see [Give SageMaker Access to Resources in your Amazon VPC](https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html).
 */
public class OptimizationVpcConfig private constructor(builder: Builder) {
    /**
     * The VPC security group IDs, in the form `sg-xxxxxxxx`. Specify the security groups for the VPC that is specified in the `Subnets` field.
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The ID of the subnets in the VPC to which you want to connect your optimized model.
     */
    public val subnets: List<String>? = builder.subnets

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.OptimizationVpcConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OptimizationVpcConfig(")
        append("securityGroupIds=$securityGroupIds,")
        append("subnets=$subnets")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = securityGroupIds?.hashCode() ?: 0
        result = 31 * result + (subnets?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OptimizationVpcConfig

        if (securityGroupIds != other.securityGroupIds) return false
        if (subnets != other.subnets) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.OptimizationVpcConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The VPC security group IDs, in the form `sg-xxxxxxxx`. Specify the security groups for the VPC that is specified in the `Subnets` field.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * The ID of the subnets in the VPC to which you want to connect your optimized model.
         */
        public var subnets: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.OptimizationVpcConfig) : this() {
            this.securityGroupIds = x.securityGroupIds
            this.subnets = x.subnets
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.OptimizationVpcConfig = OptimizationVpcConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
