// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The KernelGateway app settings.
 */
public class KernelGatewayAppSettings private constructor(builder: Builder) {
    /**
     * A list of custom SageMaker AI images that are configured to run as a KernelGateway app.
     */
    public val customImages: List<CustomImage>? = builder.customImages
    /**
     * The default instance type and the Amazon Resource Name (ARN) of the default SageMaker AI image used by the KernelGateway app.
     *
     * The Amazon SageMaker AI Studio UI does not use the default instance type value set here. The default instance type set here is used when Apps are created using the CLI or CloudFormation and the instance type parameter value is not passed.
     */
    public val defaultResourceSpec: aws.sdk.kotlin.services.sagemaker.model.ResourceSpec? = builder.defaultResourceSpec
    /**
     * The Amazon Resource Name (ARN) of the Lifecycle Configurations attached to the the user profile or domain.
     *
     * To remove a Lifecycle Config, you must set `LifecycleConfigArns` to an empty list.
     */
    public val lifecycleConfigArns: List<String>? = builder.lifecycleConfigArns

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.KernelGatewayAppSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KernelGatewayAppSettings(")
        append("customImages=$customImages,")
        append("defaultResourceSpec=$defaultResourceSpec,")
        append("lifecycleConfigArns=$lifecycleConfigArns")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = customImages?.hashCode() ?: 0
        result = 31 * result + (defaultResourceSpec?.hashCode() ?: 0)
        result = 31 * result + (lifecycleConfigArns?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KernelGatewayAppSettings

        if (customImages != other.customImages) return false
        if (defaultResourceSpec != other.defaultResourceSpec) return false
        if (lifecycleConfigArns != other.lifecycleConfigArns) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.KernelGatewayAppSettings = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of custom SageMaker AI images that are configured to run as a KernelGateway app.
         */
        public var customImages: List<CustomImage>? = null
        /**
         * The default instance type and the Amazon Resource Name (ARN) of the default SageMaker AI image used by the KernelGateway app.
         *
         * The Amazon SageMaker AI Studio UI does not use the default instance type value set here. The default instance type set here is used when Apps are created using the CLI or CloudFormation and the instance type parameter value is not passed.
         */
        public var defaultResourceSpec: aws.sdk.kotlin.services.sagemaker.model.ResourceSpec? = null
        /**
         * The Amazon Resource Name (ARN) of the Lifecycle Configurations attached to the the user profile or domain.
         *
         * To remove a Lifecycle Config, you must set `LifecycleConfigArns` to an empty list.
         */
        public var lifecycleConfigArns: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.KernelGatewayAppSettings) : this() {
            this.customImages = x.customImages
            this.defaultResourceSpec = x.defaultResourceSpec
            this.lifecycleConfigArns = x.lifecycleConfigArns
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.KernelGatewayAppSettings = KernelGatewayAppSettings(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ResourceSpec] inside the given [block]
         */
        public fun defaultResourceSpec(block: aws.sdk.kotlin.services.sagemaker.model.ResourceSpec.Builder.() -> kotlin.Unit) {
            this.defaultResourceSpec = aws.sdk.kotlin.services.sagemaker.model.ResourceSpec.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
