// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The JupyterServer app settings.
 */
public class JupyterServerAppSettings private constructor(builder: Builder) {
    /**
     * A list of Git repositories that SageMaker AI automatically displays to users for cloning in the JupyterServer application.
     */
    public val codeRepositories: List<CodeRepository>? = builder.codeRepositories
    /**
     * The default instance type and the Amazon Resource Name (ARN) of the default SageMaker AI image used by the JupyterServer app. If you use the `LifecycleConfigArns` parameter, then this parameter is also required.
     */
    public val defaultResourceSpec: aws.sdk.kotlin.services.sagemaker.model.ResourceSpec? = builder.defaultResourceSpec
    /**
     * The Amazon Resource Name (ARN) of the Lifecycle Configurations attached to the JupyterServerApp. If you use this parameter, the `DefaultResourceSpec` parameter is also required.
     *
     * To remove a Lifecycle Config, you must set `LifecycleConfigArns` to an empty list.
     */
    public val lifecycleConfigArns: List<String>? = builder.lifecycleConfigArns

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.JupyterServerAppSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JupyterServerAppSettings(")
        append("codeRepositories=$codeRepositories,")
        append("defaultResourceSpec=$defaultResourceSpec,")
        append("lifecycleConfigArns=$lifecycleConfigArns")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = codeRepositories?.hashCode() ?: 0
        result = 31 * result + (defaultResourceSpec?.hashCode() ?: 0)
        result = 31 * result + (lifecycleConfigArns?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JupyterServerAppSettings

        if (codeRepositories != other.codeRepositories) return false
        if (defaultResourceSpec != other.defaultResourceSpec) return false
        if (lifecycleConfigArns != other.lifecycleConfigArns) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.JupyterServerAppSettings = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of Git repositories that SageMaker AI automatically displays to users for cloning in the JupyterServer application.
         */
        public var codeRepositories: List<CodeRepository>? = null
        /**
         * The default instance type and the Amazon Resource Name (ARN) of the default SageMaker AI image used by the JupyterServer app. If you use the `LifecycleConfigArns` parameter, then this parameter is also required.
         */
        public var defaultResourceSpec: aws.sdk.kotlin.services.sagemaker.model.ResourceSpec? = null
        /**
         * The Amazon Resource Name (ARN) of the Lifecycle Configurations attached to the JupyterServerApp. If you use this parameter, the `DefaultResourceSpec` parameter is also required.
         *
         * To remove a Lifecycle Config, you must set `LifecycleConfigArns` to an empty list.
         */
        public var lifecycleConfigArns: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.JupyterServerAppSettings) : this() {
            this.codeRepositories = x.codeRepositories
            this.defaultResourceSpec = x.defaultResourceSpec
            this.lifecycleConfigArns = x.lifecycleConfigArns
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.JupyterServerAppSettings = JupyterServerAppSettings(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ResourceSpec] inside the given [block]
         */
        public fun defaultResourceSpec(block: aws.sdk.kotlin.services.sagemaker.model.ResourceSpec.Builder.() -> kotlin.Unit) {
            this.defaultResourceSpec = aws.sdk.kotlin.services.sagemaker.model.ResourceSpec.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
