// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A collection of settings that apply to the `SageMaker Domain`. These settings are specified through the `CreateDomain` API call.
 */
public class DomainSettings private constructor(builder: Builder) {
    /**
     * A collection of settings that configure the Amazon Q experience within the domain. The `AuthMode` that you use to create the domain must be `SSO`.
     */
    public val amazonQSettings: aws.sdk.kotlin.services.sagemaker.model.AmazonQSettings? = builder.amazonQSettings
    /**
     * A collection of settings that configure the domain's Docker interaction.
     */
    public val dockerSettings: aws.sdk.kotlin.services.sagemaker.model.DockerSettings? = builder.dockerSettings
    /**
     * The configuration for attaching a SageMaker AI user profile name to the execution role as a [sts:SourceIdentity key](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html).
     */
    public val executionRoleIdentityConfig: aws.sdk.kotlin.services.sagemaker.model.ExecutionRoleIdentityConfig? = builder.executionRoleIdentityConfig
    /**
     * A collection of settings that configure the `RStudioServerPro` Domain-level app.
     */
    public val rStudioServerProDomainSettings: aws.sdk.kotlin.services.sagemaker.model.RStudioServerProDomainSettings? = builder.rStudioServerProDomainSettings
    /**
     * The security groups for the Amazon Virtual Private Cloud that the `Domain` uses for communication between Domain-level apps and user apps.
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.DomainSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DomainSettings(")
        append("amazonQSettings=$amazonQSettings,")
        append("dockerSettings=$dockerSettings,")
        append("executionRoleIdentityConfig=$executionRoleIdentityConfig,")
        append("rStudioServerProDomainSettings=$rStudioServerProDomainSettings,")
        append("securityGroupIds=$securityGroupIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = amazonQSettings?.hashCode() ?: 0
        result = 31 * result + (dockerSettings?.hashCode() ?: 0)
        result = 31 * result + (executionRoleIdentityConfig?.hashCode() ?: 0)
        result = 31 * result + (rStudioServerProDomainSettings?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DomainSettings

        if (amazonQSettings != other.amazonQSettings) return false
        if (dockerSettings != other.dockerSettings) return false
        if (executionRoleIdentityConfig != other.executionRoleIdentityConfig) return false
        if (rStudioServerProDomainSettings != other.rStudioServerProDomainSettings) return false
        if (securityGroupIds != other.securityGroupIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.DomainSettings = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A collection of settings that configure the Amazon Q experience within the domain. The `AuthMode` that you use to create the domain must be `SSO`.
         */
        public var amazonQSettings: aws.sdk.kotlin.services.sagemaker.model.AmazonQSettings? = null
        /**
         * A collection of settings that configure the domain's Docker interaction.
         */
        public var dockerSettings: aws.sdk.kotlin.services.sagemaker.model.DockerSettings? = null
        /**
         * The configuration for attaching a SageMaker AI user profile name to the execution role as a [sts:SourceIdentity key](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html).
         */
        public var executionRoleIdentityConfig: aws.sdk.kotlin.services.sagemaker.model.ExecutionRoleIdentityConfig? = null
        /**
         * A collection of settings that configure the `RStudioServerPro` Domain-level app.
         */
        public var rStudioServerProDomainSettings: aws.sdk.kotlin.services.sagemaker.model.RStudioServerProDomainSettings? = null
        /**
         * The security groups for the Amazon Virtual Private Cloud that the `Domain` uses for communication between Domain-level apps and user apps.
         */
        public var securityGroupIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.DomainSettings) : this() {
            this.amazonQSettings = x.amazonQSettings
            this.dockerSettings = x.dockerSettings
            this.executionRoleIdentityConfig = x.executionRoleIdentityConfig
            this.rStudioServerProDomainSettings = x.rStudioServerProDomainSettings
            this.securityGroupIds = x.securityGroupIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.DomainSettings = DomainSettings(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.AmazonQSettings] inside the given [block]
         */
        public fun amazonQSettings(block: aws.sdk.kotlin.services.sagemaker.model.AmazonQSettings.Builder.() -> kotlin.Unit) {
            this.amazonQSettings = aws.sdk.kotlin.services.sagemaker.model.AmazonQSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.DockerSettings] inside the given [block]
         */
        public fun dockerSettings(block: aws.sdk.kotlin.services.sagemaker.model.DockerSettings.Builder.() -> kotlin.Unit) {
            this.dockerSettings = aws.sdk.kotlin.services.sagemaker.model.DockerSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.RStudioServerProDomainSettings] inside the given [block]
         */
        public fun rStudioServerProDomainSettings(block: aws.sdk.kotlin.services.sagemaker.model.RStudioServerProDomainSettings.Builder.() -> kotlin.Unit) {
            this.rStudioServerProDomainSettings = aws.sdk.kotlin.services.sagemaker.model.RStudioServerProDomainSettings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
