// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeNotebookInstanceResponse private constructor(builder: Builder) {
    /**
     * This parameter is no longer supported. Elastic Inference (EI) is no longer available.
     *
     * This parameter was used to specify a list of the EI instance types associated with this notebook instance.
     */
    public val acceleratorTypes: List<NotebookInstanceAcceleratorType>? = builder.acceleratorTypes
    /**
     * An array of up to three Git repositories associated with the notebook instance. These can be either the names of Git repositories stored as resources in your account, or the URL of Git repositories in [Amazon Web Services CodeCommit](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html) or in any other Git repository. These repositories are cloned at the same level as the default repository of your notebook instance. For more information, see [Associating Git Repositories with SageMaker AI Notebook Instances](https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html).
     */
    public val additionalCodeRepositories: List<String>? = builder.additionalCodeRepositories
    /**
     * A timestamp. Use this parameter to return the time when the notebook instance was created
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The Git repository associated with the notebook instance as its default code repository. This can be either the name of a Git repository stored as a resource in your account, or the URL of a Git repository in [Amazon Web Services CodeCommit](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html) or in any other Git repository. When you open a notebook instance, it opens in the directory that contains this repository. For more information, see [Associating Git Repositories with SageMaker AI Notebook Instances](https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html).
     */
    public val defaultCodeRepository: kotlin.String? = builder.defaultCodeRepository
    /**
     * Describes whether SageMaker AI provides internet access to the notebook instance. If this value is set to *Disabled*, the notebook instance does not have internet access, and cannot connect to SageMaker AI training and endpoint services.
     *
     * For more information, see [Notebook Instances Are Internet-Enabled by Default](https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access).
     */
    public val directInternetAccess: aws.sdk.kotlin.services.sagemaker.model.DirectInternetAccess? = builder.directInternetAccess
    /**
     * If status is `Failed`, the reason it failed.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * Information on the IMDS configuration of the notebook instance
     */
    public val instanceMetadataServiceConfiguration: aws.sdk.kotlin.services.sagemaker.model.InstanceMetadataServiceConfiguration? = builder.instanceMetadataServiceConfiguration
    /**
     * The type of ML compute instance running on the notebook instance.
     */
    public val instanceType: aws.sdk.kotlin.services.sagemaker.model.InstanceType? = builder.instanceType
    /**
     * The Amazon Web Services KMS key ID SageMaker AI uses to encrypt data when storing it on the ML storage volume attached to the instance.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * A timestamp. Use this parameter to retrieve the time when the notebook instance was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The network interface IDs that SageMaker AI created at the time of creating the instance.
     */
    public val networkInterfaceId: kotlin.String? = builder.networkInterfaceId
    /**
     * The Amazon Resource Name (ARN) of the notebook instance.
     */
    public val notebookInstanceArn: kotlin.String? = builder.notebookInstanceArn
    /**
     * Returns the name of a notebook instance lifecycle configuration.
     *
     * For information about notebook instance lifestyle configurations, see [Step 2.1: (Optional) Customize a Notebook Instance](https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html)
     */
    public val notebookInstanceLifecycleConfigName: kotlin.String? = builder.notebookInstanceLifecycleConfigName
    /**
     * The name of the SageMaker AI notebook instance.
     */
    public val notebookInstanceName: kotlin.String? = builder.notebookInstanceName
    /**
     * The status of the notebook instance.
     */
    public val notebookInstanceStatus: aws.sdk.kotlin.services.sagemaker.model.NotebookInstanceStatus? = builder.notebookInstanceStatus
    /**
     * The platform identifier of the notebook instance runtime environment.
     */
    public val platformIdentifier: kotlin.String? = builder.platformIdentifier
    /**
     * The Amazon Resource Name (ARN) of the IAM role associated with the instance.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * Whether root access is enabled or disabled for users of the notebook instance.
     *
     * Lifecycle configurations need root access to be able to set up a notebook instance. Because of this, lifecycle configurations associated with a notebook instance always run with root access even if you disable root access for users.
     */
    public val rootAccess: aws.sdk.kotlin.services.sagemaker.model.RootAccess? = builder.rootAccess
    /**
     * The IDs of the VPC security groups.
     */
    public val securityGroups: List<String>? = builder.securityGroups
    /**
     * The ID of the VPC subnet.
     */
    public val subnetId: kotlin.String? = builder.subnetId
    /**
     * The URL that you use to connect to the Jupyter notebook that is running in your notebook instance.
     */
    public val url: kotlin.String? = builder.url
    /**
     * The size, in GB, of the ML storage volume attached to the notebook instance.
     */
    public val volumeSizeInGb: kotlin.Int? = builder.volumeSizeInGb

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.DescribeNotebookInstanceResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeNotebookInstanceResponse(")
        append("acceleratorTypes=$acceleratorTypes,")
        append("additionalCodeRepositories=$additionalCodeRepositories,")
        append("creationTime=$creationTime,")
        append("defaultCodeRepository=$defaultCodeRepository,")
        append("directInternetAccess=$directInternetAccess,")
        append("failureReason=$failureReason,")
        append("instanceMetadataServiceConfiguration=$instanceMetadataServiceConfiguration,")
        append("instanceType=$instanceType,")
        append("kmsKeyId=$kmsKeyId,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("networkInterfaceId=$networkInterfaceId,")
        append("notebookInstanceArn=$notebookInstanceArn,")
        append("notebookInstanceLifecycleConfigName=$notebookInstanceLifecycleConfigName,")
        append("notebookInstanceName=$notebookInstanceName,")
        append("notebookInstanceStatus=$notebookInstanceStatus,")
        append("platformIdentifier=$platformIdentifier,")
        append("roleArn=$roleArn,")
        append("rootAccess=$rootAccess,")
        append("securityGroups=$securityGroups,")
        append("subnetId=$subnetId,")
        append("url=$url,")
        append("volumeSizeInGb=$volumeSizeInGb")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceleratorTypes?.hashCode() ?: 0
        result = 31 * result + (additionalCodeRepositories?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (defaultCodeRepository?.hashCode() ?: 0)
        result = 31 * result + (directInternetAccess?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (instanceMetadataServiceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (notebookInstanceArn?.hashCode() ?: 0)
        result = 31 * result + (notebookInstanceLifecycleConfigName?.hashCode() ?: 0)
        result = 31 * result + (notebookInstanceName?.hashCode() ?: 0)
        result = 31 * result + (notebookInstanceStatus?.hashCode() ?: 0)
        result = 31 * result + (platformIdentifier?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (rootAccess?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (url?.hashCode() ?: 0)
        result = 31 * result + (volumeSizeInGb ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeNotebookInstanceResponse

        if (acceleratorTypes != other.acceleratorTypes) return false
        if (additionalCodeRepositories != other.additionalCodeRepositories) return false
        if (creationTime != other.creationTime) return false
        if (defaultCodeRepository != other.defaultCodeRepository) return false
        if (directInternetAccess != other.directInternetAccess) return false
        if (failureReason != other.failureReason) return false
        if (instanceMetadataServiceConfiguration != other.instanceMetadataServiceConfiguration) return false
        if (instanceType != other.instanceType) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (networkInterfaceId != other.networkInterfaceId) return false
        if (notebookInstanceArn != other.notebookInstanceArn) return false
        if (notebookInstanceLifecycleConfigName != other.notebookInstanceLifecycleConfigName) return false
        if (notebookInstanceName != other.notebookInstanceName) return false
        if (notebookInstanceStatus != other.notebookInstanceStatus) return false
        if (platformIdentifier != other.platformIdentifier) return false
        if (roleArn != other.roleArn) return false
        if (rootAccess != other.rootAccess) return false
        if (securityGroups != other.securityGroups) return false
        if (subnetId != other.subnetId) return false
        if (url != other.url) return false
        if (volumeSizeInGb != other.volumeSizeInGb) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.DescribeNotebookInstanceResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * This parameter is no longer supported. Elastic Inference (EI) is no longer available.
         *
         * This parameter was used to specify a list of the EI instance types associated with this notebook instance.
         */
        public var acceleratorTypes: List<NotebookInstanceAcceleratorType>? = null
        /**
         * An array of up to three Git repositories associated with the notebook instance. These can be either the names of Git repositories stored as resources in your account, or the URL of Git repositories in [Amazon Web Services CodeCommit](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html) or in any other Git repository. These repositories are cloned at the same level as the default repository of your notebook instance. For more information, see [Associating Git Repositories with SageMaker AI Notebook Instances](https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html).
         */
        public var additionalCodeRepositories: List<String>? = null
        /**
         * A timestamp. Use this parameter to return the time when the notebook instance was created
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Git repository associated with the notebook instance as its default code repository. This can be either the name of a Git repository stored as a resource in your account, or the URL of a Git repository in [Amazon Web Services CodeCommit](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html) or in any other Git repository. When you open a notebook instance, it opens in the directory that contains this repository. For more information, see [Associating Git Repositories with SageMaker AI Notebook Instances](https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html).
         */
        public var defaultCodeRepository: kotlin.String? = null
        /**
         * Describes whether SageMaker AI provides internet access to the notebook instance. If this value is set to *Disabled*, the notebook instance does not have internet access, and cannot connect to SageMaker AI training and endpoint services.
         *
         * For more information, see [Notebook Instances Are Internet-Enabled by Default](https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access).
         */
        public var directInternetAccess: aws.sdk.kotlin.services.sagemaker.model.DirectInternetAccess? = null
        /**
         * If status is `Failed`, the reason it failed.
         */
        public var failureReason: kotlin.String? = null
        /**
         * Information on the IMDS configuration of the notebook instance
         */
        public var instanceMetadataServiceConfiguration: aws.sdk.kotlin.services.sagemaker.model.InstanceMetadataServiceConfiguration? = null
        /**
         * The type of ML compute instance running on the notebook instance.
         */
        public var instanceType: aws.sdk.kotlin.services.sagemaker.model.InstanceType? = null
        /**
         * The Amazon Web Services KMS key ID SageMaker AI uses to encrypt data when storing it on the ML storage volume attached to the instance.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * A timestamp. Use this parameter to retrieve the time when the notebook instance was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The network interface IDs that SageMaker AI created at the time of creating the instance.
         */
        public var networkInterfaceId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the notebook instance.
         */
        public var notebookInstanceArn: kotlin.String? = null
        /**
         * Returns the name of a notebook instance lifecycle configuration.
         *
         * For information about notebook instance lifestyle configurations, see [Step 2.1: (Optional) Customize a Notebook Instance](https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html)
         */
        public var notebookInstanceLifecycleConfigName: kotlin.String? = null
        /**
         * The name of the SageMaker AI notebook instance.
         */
        public var notebookInstanceName: kotlin.String? = null
        /**
         * The status of the notebook instance.
         */
        public var notebookInstanceStatus: aws.sdk.kotlin.services.sagemaker.model.NotebookInstanceStatus? = null
        /**
         * The platform identifier of the notebook instance runtime environment.
         */
        public var platformIdentifier: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role associated with the instance.
         */
        public var roleArn: kotlin.String? = null
        /**
         * Whether root access is enabled or disabled for users of the notebook instance.
         *
         * Lifecycle configurations need root access to be able to set up a notebook instance. Because of this, lifecycle configurations associated with a notebook instance always run with root access even if you disable root access for users.
         */
        public var rootAccess: aws.sdk.kotlin.services.sagemaker.model.RootAccess? = null
        /**
         * The IDs of the VPC security groups.
         */
        public var securityGroups: List<String>? = null
        /**
         * The ID of the VPC subnet.
         */
        public var subnetId: kotlin.String? = null
        /**
         * The URL that you use to connect to the Jupyter notebook that is running in your notebook instance.
         */
        public var url: kotlin.String? = null
        /**
         * The size, in GB, of the ML storage volume attached to the notebook instance.
         */
        public var volumeSizeInGb: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.DescribeNotebookInstanceResponse) : this() {
            this.acceleratorTypes = x.acceleratorTypes
            this.additionalCodeRepositories = x.additionalCodeRepositories
            this.creationTime = x.creationTime
            this.defaultCodeRepository = x.defaultCodeRepository
            this.directInternetAccess = x.directInternetAccess
            this.failureReason = x.failureReason
            this.instanceMetadataServiceConfiguration = x.instanceMetadataServiceConfiguration
            this.instanceType = x.instanceType
            this.kmsKeyId = x.kmsKeyId
            this.lastModifiedTime = x.lastModifiedTime
            this.networkInterfaceId = x.networkInterfaceId
            this.notebookInstanceArn = x.notebookInstanceArn
            this.notebookInstanceLifecycleConfigName = x.notebookInstanceLifecycleConfigName
            this.notebookInstanceName = x.notebookInstanceName
            this.notebookInstanceStatus = x.notebookInstanceStatus
            this.platformIdentifier = x.platformIdentifier
            this.roleArn = x.roleArn
            this.rootAccess = x.rootAccess
            this.securityGroups = x.securityGroups
            this.subnetId = x.subnetId
            this.url = x.url
            this.volumeSizeInGb = x.volumeSizeInGb
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.DescribeNotebookInstanceResponse = DescribeNotebookInstanceResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.InstanceMetadataServiceConfiguration] inside the given [block]
         */
        public fun instanceMetadataServiceConfiguration(block: aws.sdk.kotlin.services.sagemaker.model.InstanceMetadataServiceConfiguration.Builder.() -> kotlin.Unit) {
            this.instanceMetadataServiceConfiguration = aws.sdk.kotlin.services.sagemaker.model.InstanceMetadataServiceConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
