// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A set of recommended deployment configurations for the model. To get more advanced recommendations, see [CreateInferenceRecommendationsJob](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateInferenceRecommendationsJob.html) to create an inference recommendation job.
 */
public class DeploymentRecommendation private constructor(builder: Builder) {
    /**
     * A list of [RealTimeInferenceRecommendation](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_RealTimeInferenceRecommendation.html) items.
     */
    public val realTimeInferenceRecommendations: List<RealTimeInferenceRecommendation>? = builder.realTimeInferenceRecommendations
    /**
     * Status of the deployment recommendation. The status `NOT_APPLICABLE` means that SageMaker is unable to provide a default recommendation for the model using the information provided. If the deployment status is `IN_PROGRESS`, retry your API call after a few seconds to get a `COMPLETED` deployment recommendation.
     */
    public val recommendationStatus: aws.sdk.kotlin.services.sagemaker.model.RecommendationStatus? = builder.recommendationStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.DeploymentRecommendation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeploymentRecommendation(")
        append("realTimeInferenceRecommendations=$realTimeInferenceRecommendations,")
        append("recommendationStatus=$recommendationStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = realTimeInferenceRecommendations?.hashCode() ?: 0
        result = 31 * result + (recommendationStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeploymentRecommendation

        if (realTimeInferenceRecommendations != other.realTimeInferenceRecommendations) return false
        if (recommendationStatus != other.recommendationStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.DeploymentRecommendation = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of [RealTimeInferenceRecommendation](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_RealTimeInferenceRecommendation.html) items.
         */
        public var realTimeInferenceRecommendations: List<RealTimeInferenceRecommendation>? = null
        /**
         * Status of the deployment recommendation. The status `NOT_APPLICABLE` means that SageMaker is unable to provide a default recommendation for the model using the information provided. If the deployment status is `IN_PROGRESS`, retry your API call after a few seconds to get a `COMPLETED` deployment recommendation.
         */
        public var recommendationStatus: aws.sdk.kotlin.services.sagemaker.model.RecommendationStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.DeploymentRecommendation) : this() {
            this.realTimeInferenceRecommendations = x.realTimeInferenceRecommendations
            this.recommendationStatus = x.recommendationStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.DeploymentRecommendation = DeploymentRecommendation(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
