// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateModelRequest private constructor(builder: Builder) {
    /**
     * Specifies the containers in the inference pipeline.
     */
    public val containers: List<ContainerDefinition>? = builder.containers
    /**
     * Isolates the model container. No inbound or outbound network calls can be made to or from the model container.
     */
    public val enableNetworkIsolation: kotlin.Boolean? = builder.enableNetworkIsolation
    /**
     * The Amazon Resource Name (ARN) of the IAM role that SageMaker can assume to access model artifacts and docker image for deployment on ML compute instances or for batch transform jobs. Deploying on ML compute instances is part of model hosting. For more information, see [SageMaker Roles](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html).
     *
     * To be able to pass this role to SageMaker, the caller of this API must have the `iam:PassRole` permission.
     */
    public val executionRoleArn: kotlin.String? = builder.executionRoleArn
    /**
     * Specifies details of how containers in a multi-container endpoint are called.
     */
    public val inferenceExecutionConfig: aws.sdk.kotlin.services.sagemaker.model.InferenceExecutionConfig? = builder.inferenceExecutionConfig
    /**
     * The name of the new model.
     */
    public val modelName: kotlin.String? = builder.modelName
    /**
     * The location of the primary docker image containing inference code, associated artifacts, and custom environment map that the inference code uses when the model is deployed for predictions.
     */
    public val primaryContainer: aws.sdk.kotlin.services.sagemaker.model.ContainerDefinition? = builder.primaryContainer
    /**
     * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see [Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * A [VpcConfig](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VpcConfig.html) object that specifies the VPC that you want your model to connect to. Control access to and from your model container by configuring the VPC. `VpcConfig` is used in hosting services and in batch transform. For more information, see [Protect Endpoints by Using an Amazon Virtual Private Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html) and [Protect Data in Batch Transform Jobs by Using an Amazon Virtual Private Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/batch-vpc.html).
     */
    public val vpcConfig: aws.sdk.kotlin.services.sagemaker.model.VpcConfig? = builder.vpcConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.CreateModelRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateModelRequest(")
        append("containers=$containers,")
        append("enableNetworkIsolation=$enableNetworkIsolation,")
        append("executionRoleArn=$executionRoleArn,")
        append("inferenceExecutionConfig=$inferenceExecutionConfig,")
        append("modelName=$modelName,")
        append("primaryContainer=$primaryContainer,")
        append("tags=$tags,")
        append("vpcConfig=$vpcConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = containers?.hashCode() ?: 0
        result = 31 * result + (enableNetworkIsolation?.hashCode() ?: 0)
        result = 31 * result + (executionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (inferenceExecutionConfig?.hashCode() ?: 0)
        result = 31 * result + (modelName?.hashCode() ?: 0)
        result = 31 * result + (primaryContainer?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateModelRequest

        if (containers != other.containers) return false
        if (enableNetworkIsolation != other.enableNetworkIsolation) return false
        if (executionRoleArn != other.executionRoleArn) return false
        if (inferenceExecutionConfig != other.inferenceExecutionConfig) return false
        if (modelName != other.modelName) return false
        if (primaryContainer != other.primaryContainer) return false
        if (tags != other.tags) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.CreateModelRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the containers in the inference pipeline.
         */
        public var containers: List<ContainerDefinition>? = null
        /**
         * Isolates the model container. No inbound or outbound network calls can be made to or from the model container.
         */
        public var enableNetworkIsolation: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role that SageMaker can assume to access model artifacts and docker image for deployment on ML compute instances or for batch transform jobs. Deploying on ML compute instances is part of model hosting. For more information, see [SageMaker Roles](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html).
         *
         * To be able to pass this role to SageMaker, the caller of this API must have the `iam:PassRole` permission.
         */
        public var executionRoleArn: kotlin.String? = null
        /**
         * Specifies details of how containers in a multi-container endpoint are called.
         */
        public var inferenceExecutionConfig: aws.sdk.kotlin.services.sagemaker.model.InferenceExecutionConfig? = null
        /**
         * The name of the new model.
         */
        public var modelName: kotlin.String? = null
        /**
         * The location of the primary docker image containing inference code, associated artifacts, and custom environment map that the inference code uses when the model is deployed for predictions.
         */
        public var primaryContainer: aws.sdk.kotlin.services.sagemaker.model.ContainerDefinition? = null
        /**
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see [Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
         */
        public var tags: List<Tag>? = null
        /**
         * A [VpcConfig](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VpcConfig.html) object that specifies the VPC that you want your model to connect to. Control access to and from your model container by configuring the VPC. `VpcConfig` is used in hosting services and in batch transform. For more information, see [Protect Endpoints by Using an Amazon Virtual Private Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html) and [Protect Data in Batch Transform Jobs by Using an Amazon Virtual Private Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/batch-vpc.html).
         */
        public var vpcConfig: aws.sdk.kotlin.services.sagemaker.model.VpcConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.CreateModelRequest) : this() {
            this.containers = x.containers
            this.enableNetworkIsolation = x.enableNetworkIsolation
            this.executionRoleArn = x.executionRoleArn
            this.inferenceExecutionConfig = x.inferenceExecutionConfig
            this.modelName = x.modelName
            this.primaryContainer = x.primaryContainer
            this.tags = x.tags
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.CreateModelRequest = CreateModelRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.InferenceExecutionConfig] inside the given [block]
         */
        public fun inferenceExecutionConfig(block: aws.sdk.kotlin.services.sagemaker.model.InferenceExecutionConfig.Builder.() -> kotlin.Unit) {
            this.inferenceExecutionConfig = aws.sdk.kotlin.services.sagemaker.model.InferenceExecutionConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ContainerDefinition] inside the given [block]
         */
        public fun primaryContainer(block: aws.sdk.kotlin.services.sagemaker.model.ContainerDefinition.Builder.() -> kotlin.Unit) {
            this.primaryContainer = aws.sdk.kotlin.services.sagemaker.model.ContainerDefinition.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.VpcConfig] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.sagemaker.model.VpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.sagemaker.model.VpcConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
