// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration for SHAP analysis using SageMaker Clarify Explainer.
 */
public class ClarifyShapConfig private constructor(builder: Builder) {
    /**
     * The number of samples to be used for analysis by the Kernal SHAP algorithm.
     *
     * The number of samples determines the size of the synthetic dataset, which has an impact on latency of explainability requests. For more information, see the **Synthetic data** of [Configure and create an endpoint](https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-create-endpoint.html).
     */
    public val numberOfSamples: kotlin.Int? = builder.numberOfSamples
    /**
     * The starting value used to initialize the random number generator in the explainer. Provide a value for this parameter to obtain a deterministic SHAP result.
     */
    public val seed: kotlin.Int? = builder.seed
    /**
     * The configuration for the SHAP baseline of the Kernal SHAP algorithm.
     */
    public val shapBaselineConfig: aws.sdk.kotlin.services.sagemaker.model.ClarifyShapBaselineConfig? = builder.shapBaselineConfig
    /**
     * A parameter that indicates if text features are treated as text and explanations are provided for individual units of text. Required for natural language processing (NLP) explainability only.
     */
    public val textConfig: aws.sdk.kotlin.services.sagemaker.model.ClarifyTextConfig? = builder.textConfig
    /**
     * A Boolean toggle to indicate if you want to use the logit function (true) or log-odds units (false) for model predictions. Defaults to false.
     */
    public val useLogit: kotlin.Boolean? = builder.useLogit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ClarifyShapConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClarifyShapConfig(")
        append("numberOfSamples=$numberOfSamples,")
        append("seed=$seed,")
        append("shapBaselineConfig=$shapBaselineConfig,")
        append("textConfig=$textConfig,")
        append("useLogit=$useLogit")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = numberOfSamples ?: 0
        result = 31 * result + (seed ?: 0)
        result = 31 * result + (shapBaselineConfig?.hashCode() ?: 0)
        result = 31 * result + (textConfig?.hashCode() ?: 0)
        result = 31 * result + (useLogit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClarifyShapConfig

        if (numberOfSamples != other.numberOfSamples) return false
        if (seed != other.seed) return false
        if (shapBaselineConfig != other.shapBaselineConfig) return false
        if (textConfig != other.textConfig) return false
        if (useLogit != other.useLogit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ClarifyShapConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of samples to be used for analysis by the Kernal SHAP algorithm.
         *
         * The number of samples determines the size of the synthetic dataset, which has an impact on latency of explainability requests. For more information, see the **Synthetic data** of [Configure and create an endpoint](https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-create-endpoint.html).
         */
        public var numberOfSamples: kotlin.Int? = null
        /**
         * The starting value used to initialize the random number generator in the explainer. Provide a value for this parameter to obtain a deterministic SHAP result.
         */
        public var seed: kotlin.Int? = null
        /**
         * The configuration for the SHAP baseline of the Kernal SHAP algorithm.
         */
        public var shapBaselineConfig: aws.sdk.kotlin.services.sagemaker.model.ClarifyShapBaselineConfig? = null
        /**
         * A parameter that indicates if text features are treated as text and explanations are provided for individual units of text. Required for natural language processing (NLP) explainability only.
         */
        public var textConfig: aws.sdk.kotlin.services.sagemaker.model.ClarifyTextConfig? = null
        /**
         * A Boolean toggle to indicate if you want to use the logit function (true) or log-odds units (false) for model predictions. Defaults to false.
         */
        public var useLogit: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ClarifyShapConfig) : this() {
            this.numberOfSamples = x.numberOfSamples
            this.seed = x.seed
            this.shapBaselineConfig = x.shapBaselineConfig
            this.textConfig = x.textConfig
            this.useLogit = x.useLogit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ClarifyShapConfig = ClarifyShapConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ClarifyShapBaselineConfig] inside the given [block]
         */
        public fun shapBaselineConfig(block: aws.sdk.kotlin.services.sagemaker.model.ClarifyShapBaselineConfig.Builder.() -> kotlin.Unit) {
            this.shapBaselineConfig = aws.sdk.kotlin.services.sagemaker.model.ClarifyShapBaselineConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ClarifyTextConfig] inside the given [block]
         */
        public fun textConfig(block: aws.sdk.kotlin.services.sagemaker.model.ClarifyTextConfig.Builder.() -> kotlin.Unit) {
            this.textConfig = aws.sdk.kotlin.services.sagemaker.model.ClarifyTextConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
