// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the training algorithm to use in a [CreateTrainingJob](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrainingJob.html) request.
 *
 * SageMaker uses its own SageMaker account credentials to pull and access built-in algorithms so built-in algorithms are universally accessible across all Amazon Web Services accounts. As a result, built-in algorithms have standard, unrestricted access. You cannot restrict built-in algorithms using IAM roles. Use custom algorithms if you require specific access controls.
 *
 * For more information about algorithms provided by SageMaker, see [Algorithms](https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html). For information about using your own algorithms, see [Using Your Own Algorithms with Amazon SageMaker](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html).
 */
public class AlgorithmSpecification private constructor(builder: Builder) {
    /**
     * The name of the algorithm resource to use for the training job. This must be an algorithm resource that you created or subscribe to on Amazon Web Services Marketplace.
     *
     * You must specify either the algorithm name to the `AlgorithmName` parameter or the image URI of the algorithm container to the `TrainingImage` parameter.
     *
     * Note that the `AlgorithmName` parameter is mutually exclusive with the `TrainingImage` parameter. If you specify a value for the `AlgorithmName` parameter, you can't specify a value for `TrainingImage`, and vice versa.
     *
     * If you specify values for both parameters, the training job might break; if you don't specify any value for both parameters, the training job might raise a `null` error.
     */
    public val algorithmName: kotlin.String? = builder.algorithmName
    /**
     * The arguments for a container used to run a training job. See [How Amazon SageMaker Runs Your Training Image](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-training-algo-dockerfile.html) for additional information.
     */
    public val containerArguments: List<String>? = builder.containerArguments
    /**
     * The [entrypoint script for a Docker container](https://docs.docker.com/engine/reference/builder/) used to run a training job. This script takes precedence over the default train processing instructions. See [How Amazon SageMaker Runs Your Training Image](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-training-algo-dockerfile.html) for more information.
     */
    public val containerEntrypoint: List<String>? = builder.containerEntrypoint
    /**
     * To generate and save time-series metrics during training, set to `true`. The default is `false` and time-series metrics aren't generated except in the following cases:
     * + You use one of the SageMaker built-in algorithms
     * + You use one of the following [Prebuilt SageMaker Docker Images](https://docs.aws.amazon.com/sagemaker/latest/dg/pre-built-containers-frameworks-deep-learning.html):
     *    + Tensorflow (version >= 1.15)
     *    + MXNet (version >= 1.6)
     *    + PyTorch (version >= 1.3)
     * + You specify at least one [MetricDefinition](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_MetricDefinition.html)
     */
    public val enableSageMakerMetricsTimeSeries: kotlin.Boolean? = builder.enableSageMakerMetricsTimeSeries
    /**
     * A list of metric definition objects. Each object specifies the metric name and regular expressions used to parse algorithm logs. SageMaker publishes each metric to Amazon CloudWatch.
     */
    public val metricDefinitions: List<MetricDefinition>? = builder.metricDefinitions
    /**
     * The registry path of the Docker image that contains the training algorithm. For information about docker registry paths for SageMaker built-in algorithms, see [Docker Registry Paths and Example Code](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html) in the *Amazon SageMaker developer guide*. SageMaker supports both `registry/repository[:tag]` and `registry/repository[@digest]` image path formats. For more information about using your custom training container, see [Using Your Own Algorithms with Amazon SageMaker](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html).
     *
     * You must specify either the algorithm name to the `AlgorithmName` parameter or the image URI of the algorithm container to the `TrainingImage` parameter.
     *
     * For more information, see the note in the `AlgorithmName` parameter description.
     */
    public val trainingImage: kotlin.String? = builder.trainingImage
    /**
     * The configuration to use an image from a private Docker registry for a training job.
     */
    public val trainingImageConfig: aws.sdk.kotlin.services.sagemaker.model.TrainingImageConfig? = builder.trainingImageConfig
    /**
     * The training input mode that the algorithm supports. For more information about input modes, see [Algorithms](https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html).
     *
     * **Pipe mode**
     *
     * If an algorithm supports `Pipe` mode, Amazon SageMaker streams data directly from Amazon S3 to the container.
     *
     * **File mode**
     *
     * If an algorithm supports `File` mode, SageMaker downloads the training data from S3 to the provisioned ML storage volume, and mounts the directory to the Docker volume for the training container.
     *
     * You must provision the ML storage volume with sufficient capacity to accommodate the data downloaded from S3. In addition to the training data, the ML storage volume also stores the output model. The algorithm container uses the ML storage volume to also store intermediate information, if any.
     *
     * For distributed algorithms, training data is distributed uniformly. Your training duration is predictable if the input data objects sizes are approximately the same. SageMaker does not split the files any further for model training. If the object sizes are skewed, training won't be optimal as the data distribution is also skewed when one host in a training cluster is overloaded, thus becoming a bottleneck in training.
     *
     * **FastFile mode**
     *
     * If an algorithm supports `FastFile` mode, SageMaker streams data directly from S3 to the container with no code changes, and provides file system access to the data. Users can author their training script to interact with these files as if they were stored on disk.
     *
     * `FastFile` mode works best when the data is read sequentially. Augmented manifest files aren't supported. The startup time is lower when there are fewer files in the S3 bucket provided.
     */
    public val trainingInputMode: aws.sdk.kotlin.services.sagemaker.model.TrainingInputMode? = builder.trainingInputMode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.AlgorithmSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AlgorithmSpecification(")
        append("algorithmName=$algorithmName,")
        append("containerArguments=$containerArguments,")
        append("containerEntrypoint=$containerEntrypoint,")
        append("enableSageMakerMetricsTimeSeries=$enableSageMakerMetricsTimeSeries,")
        append("metricDefinitions=$metricDefinitions,")
        append("trainingImage=$trainingImage,")
        append("trainingImageConfig=$trainingImageConfig,")
        append("trainingInputMode=$trainingInputMode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = algorithmName?.hashCode() ?: 0
        result = 31 * result + (containerArguments?.hashCode() ?: 0)
        result = 31 * result + (containerEntrypoint?.hashCode() ?: 0)
        result = 31 * result + (enableSageMakerMetricsTimeSeries?.hashCode() ?: 0)
        result = 31 * result + (metricDefinitions?.hashCode() ?: 0)
        result = 31 * result + (trainingImage?.hashCode() ?: 0)
        result = 31 * result + (trainingImageConfig?.hashCode() ?: 0)
        result = 31 * result + (trainingInputMode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AlgorithmSpecification

        if (algorithmName != other.algorithmName) return false
        if (containerArguments != other.containerArguments) return false
        if (containerEntrypoint != other.containerEntrypoint) return false
        if (enableSageMakerMetricsTimeSeries != other.enableSageMakerMetricsTimeSeries) return false
        if (metricDefinitions != other.metricDefinitions) return false
        if (trainingImage != other.trainingImage) return false
        if (trainingImageConfig != other.trainingImageConfig) return false
        if (trainingInputMode != other.trainingInputMode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.AlgorithmSpecification = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the algorithm resource to use for the training job. This must be an algorithm resource that you created or subscribe to on Amazon Web Services Marketplace.
         *
         * You must specify either the algorithm name to the `AlgorithmName` parameter or the image URI of the algorithm container to the `TrainingImage` parameter.
         *
         * Note that the `AlgorithmName` parameter is mutually exclusive with the `TrainingImage` parameter. If you specify a value for the `AlgorithmName` parameter, you can't specify a value for `TrainingImage`, and vice versa.
         *
         * If you specify values for both parameters, the training job might break; if you don't specify any value for both parameters, the training job might raise a `null` error.
         */
        public var algorithmName: kotlin.String? = null
        /**
         * The arguments for a container used to run a training job. See [How Amazon SageMaker Runs Your Training Image](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-training-algo-dockerfile.html) for additional information.
         */
        public var containerArguments: List<String>? = null
        /**
         * The [entrypoint script for a Docker container](https://docs.docker.com/engine/reference/builder/) used to run a training job. This script takes precedence over the default train processing instructions. See [How Amazon SageMaker Runs Your Training Image](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-training-algo-dockerfile.html) for more information.
         */
        public var containerEntrypoint: List<String>? = null
        /**
         * To generate and save time-series metrics during training, set to `true`. The default is `false` and time-series metrics aren't generated except in the following cases:
         * + You use one of the SageMaker built-in algorithms
         * + You use one of the following [Prebuilt SageMaker Docker Images](https://docs.aws.amazon.com/sagemaker/latest/dg/pre-built-containers-frameworks-deep-learning.html):
         *    + Tensorflow (version >= 1.15)
         *    + MXNet (version >= 1.6)
         *    + PyTorch (version >= 1.3)
         * + You specify at least one [MetricDefinition](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_MetricDefinition.html)
         */
        public var enableSageMakerMetricsTimeSeries: kotlin.Boolean? = null
        /**
         * A list of metric definition objects. Each object specifies the metric name and regular expressions used to parse algorithm logs. SageMaker publishes each metric to Amazon CloudWatch.
         */
        public var metricDefinitions: List<MetricDefinition>? = null
        /**
         * The registry path of the Docker image that contains the training algorithm. For information about docker registry paths for SageMaker built-in algorithms, see [Docker Registry Paths and Example Code](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html) in the *Amazon SageMaker developer guide*. SageMaker supports both `registry/repository[:tag]` and `registry/repository[@digest]` image path formats. For more information about using your custom training container, see [Using Your Own Algorithms with Amazon SageMaker](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html).
         *
         * You must specify either the algorithm name to the `AlgorithmName` parameter or the image URI of the algorithm container to the `TrainingImage` parameter.
         *
         * For more information, see the note in the `AlgorithmName` parameter description.
         */
        public var trainingImage: kotlin.String? = null
        /**
         * The configuration to use an image from a private Docker registry for a training job.
         */
        public var trainingImageConfig: aws.sdk.kotlin.services.sagemaker.model.TrainingImageConfig? = null
        /**
         * The training input mode that the algorithm supports. For more information about input modes, see [Algorithms](https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html).
         *
         * **Pipe mode**
         *
         * If an algorithm supports `Pipe` mode, Amazon SageMaker streams data directly from Amazon S3 to the container.
         *
         * **File mode**
         *
         * If an algorithm supports `File` mode, SageMaker downloads the training data from S3 to the provisioned ML storage volume, and mounts the directory to the Docker volume for the training container.
         *
         * You must provision the ML storage volume with sufficient capacity to accommodate the data downloaded from S3. In addition to the training data, the ML storage volume also stores the output model. The algorithm container uses the ML storage volume to also store intermediate information, if any.
         *
         * For distributed algorithms, training data is distributed uniformly. Your training duration is predictable if the input data objects sizes are approximately the same. SageMaker does not split the files any further for model training. If the object sizes are skewed, training won't be optimal as the data distribution is also skewed when one host in a training cluster is overloaded, thus becoming a bottleneck in training.
         *
         * **FastFile mode**
         *
         * If an algorithm supports `FastFile` mode, SageMaker streams data directly from S3 to the container with no code changes, and provides file system access to the data. Users can author their training script to interact with these files as if they were stored on disk.
         *
         * `FastFile` mode works best when the data is read sequentially. Augmented manifest files aren't supported. The startup time is lower when there are fewer files in the S3 bucket provided.
         */
        public var trainingInputMode: aws.sdk.kotlin.services.sagemaker.model.TrainingInputMode? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.AlgorithmSpecification) : this() {
            this.algorithmName = x.algorithmName
            this.containerArguments = x.containerArguments
            this.containerEntrypoint = x.containerEntrypoint
            this.enableSageMakerMetricsTimeSeries = x.enableSageMakerMetricsTimeSeries
            this.metricDefinitions = x.metricDefinitions
            this.trainingImage = x.trainingImage
            this.trainingImageConfig = x.trainingImageConfig
            this.trainingInputMode = x.trainingInputMode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.AlgorithmSpecification = AlgorithmSpecification(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.TrainingImageConfig] inside the given [block]
         */
        public fun trainingImageConfig(block: aws.sdk.kotlin.services.sagemaker.model.TrainingImageConfig.Builder.() -> kotlin.Unit) {
            this.trainingImageConfig = aws.sdk.kotlin.services.sagemaker.model.TrainingImageConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
