// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.AppNetworkAccessType
import aws.sdk.kotlin.services.sagemaker.model.AppSecurityGroupManagement
import aws.sdk.kotlin.services.sagemaker.model.DefaultSpaceSettings
import aws.sdk.kotlin.services.sagemaker.model.DomainSettingsForUpdate
import aws.sdk.kotlin.services.sagemaker.model.TagPropagation
import aws.sdk.kotlin.services.sagemaker.model.UpdateDomainRequest
import aws.sdk.kotlin.services.sagemaker.model.UserSettings
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateDomainOperationSerializer: HttpSerializer.NonStreaming<UpdateDomainRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateDomainRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeUpdateDomainOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeUpdateDomainOperationBody(context: ExecutionContext, input: UpdateDomainRequest): ByteArray {
    val serializer = JsonSerializer()
    val APPNETWORKACCESSTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("AppNetworkAccessType"))
    val APPSECURITYGROUPMANAGEMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("AppSecurityGroupManagement"))
    val DEFAULTSPACESETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DefaultSpaceSettings"))
    val DEFAULTUSERSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DefaultUserSettings"))
    val DOMAINID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DomainId"))
    val DOMAINSETTINGSFORUPDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DomainSettingsForUpdate"))
    val SUBNETIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SubnetIds"))
    val TAGPROPAGATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("TagPropagation"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPNETWORKACCESSTYPE_DESCRIPTOR)
        field(APPSECURITYGROUPMANAGEMENT_DESCRIPTOR)
        field(DEFAULTSPACESETTINGS_DESCRIPTOR)
        field(DEFAULTUSERSETTINGS_DESCRIPTOR)
        field(DOMAINID_DESCRIPTOR)
        field(DOMAINSETTINGSFORUPDATE_DESCRIPTOR)
        field(SUBNETIDS_DESCRIPTOR)
        field(TAGPROPAGATION_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.appNetworkAccessType?.let { field(APPNETWORKACCESSTYPE_DESCRIPTOR, it.value) }
        input.appSecurityGroupManagement?.let { field(APPSECURITYGROUPMANAGEMENT_DESCRIPTOR, it.value) }
        input.defaultSpaceSettings?.let { field(DEFAULTSPACESETTINGS_DESCRIPTOR, it, ::serializeDefaultSpaceSettingsDocument) }
        input.defaultUserSettings?.let { field(DEFAULTUSERSETTINGS_DESCRIPTOR, it, ::serializeUserSettingsDocument) }
        input.domainId?.let { field(DOMAINID_DESCRIPTOR, it) }
        input.domainSettingsForUpdate?.let { field(DOMAINSETTINGSFORUPDATE_DESCRIPTOR, it, ::serializeDomainSettingsForUpdateDocument) }
        if (input.subnetIds != null) {
            listField(SUBNETIDS_DESCRIPTOR) {
                for (el0 in input.subnetIds) {
                    serializeString(el0)
                }
            }
        }
        input.tagPropagation?.let { field(TAGPROPAGATION_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
