// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.Autotune
import aws.sdk.kotlin.services.sagemaker.model.DescribeHyperParameterTuningJobResponse
import aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobDefinition
import aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobSummary
import aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobCompletionDetails
import aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConfig
import aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConsumedResources
import aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobStatus
import aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobWarmStartConfig
import aws.sdk.kotlin.services.sagemaker.model.ObjectiveStatusCounters
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.sdk.kotlin.services.sagemaker.model.TrainingJobStatusCounters
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class DescribeHyperParameterTuningJobOperationDeserializer: HttpDeserializer.NonStreaming<DescribeHyperParameterTuningJobResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeHyperParameterTuningJobResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeHyperParameterTuningJobError(context, call, payload)
        }
        val builder = DescribeHyperParameterTuningJobResponse.Builder()

        if (payload != null) {
            deserializeDescribeHyperParameterTuningJobOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeHyperParameterTuningJobError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedCall, payload)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeHyperParameterTuningJobOperationBody(builder: DescribeHyperParameterTuningJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUTOTUNE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Autotune"))
    val BESTTRAININGJOB_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("BestTrainingJob"))
    val CONSUMEDRESOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ConsumedResources"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FailureReason"))
    val HYPERPARAMETERTUNINGENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("HyperParameterTuningEndTime"))
    val HYPERPARAMETERTUNINGJOBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HyperParameterTuningJobArn"))
    val HYPERPARAMETERTUNINGJOBCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("HyperParameterTuningJobConfig"))
    val HYPERPARAMETERTUNINGJOBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HyperParameterTuningJobName"))
    val HYPERPARAMETERTUNINGJOBSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("HyperParameterTuningJobStatus"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val OBJECTIVESTATUSCOUNTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ObjectiveStatusCounters"))
    val OVERALLBESTTRAININGJOB_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OverallBestTrainingJob"))
    val TRAININGJOBDEFINITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TrainingJobDefinition"))
    val TRAININGJOBDEFINITIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("TrainingJobDefinitions"))
    val TRAININGJOBSTATUSCOUNTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TrainingJobStatusCounters"))
    val TUNINGJOBCOMPLETIONDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TuningJobCompletionDetails"))
    val WARMSTARTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("WarmStartConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTOTUNE_DESCRIPTOR)
        field(BESTTRAININGJOB_DESCRIPTOR)
        field(CONSUMEDRESOURCES_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(HYPERPARAMETERTUNINGENDTIME_DESCRIPTOR)
        field(HYPERPARAMETERTUNINGJOBARN_DESCRIPTOR)
        field(HYPERPARAMETERTUNINGJOBCONFIG_DESCRIPTOR)
        field(HYPERPARAMETERTUNINGJOBNAME_DESCRIPTOR)
        field(HYPERPARAMETERTUNINGJOBSTATUS_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(OBJECTIVESTATUSCOUNTERS_DESCRIPTOR)
        field(OVERALLBESTTRAININGJOB_DESCRIPTOR)
        field(TRAININGJOBDEFINITION_DESCRIPTOR)
        field(TRAININGJOBDEFINITIONS_DESCRIPTOR)
        field(TRAININGJOBSTATUSCOUNTERS_DESCRIPTOR)
        field(TUNINGJOBCOMPLETIONDETAILS_DESCRIPTOR)
        field(WARMSTARTCONFIG_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUTOTUNE_DESCRIPTOR.index -> builder.autotune = deserializeAutotuneDocument(deserializer)
                BESTTRAININGJOB_DESCRIPTOR.index -> builder.bestTrainingJob = deserializeHyperParameterTrainingJobSummaryDocument(deserializer)
                CONSUMEDRESOURCES_DESCRIPTOR.index -> builder.consumedResources = deserializeHyperParameterTuningJobConsumedResourcesDocument(deserializer)
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                HYPERPARAMETERTUNINGENDTIME_DESCRIPTOR.index -> builder.hyperParameterTuningEndTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                HYPERPARAMETERTUNINGJOBARN_DESCRIPTOR.index -> builder.hyperParameterTuningJobArn = deserializeString()
                HYPERPARAMETERTUNINGJOBCONFIG_DESCRIPTOR.index -> builder.hyperParameterTuningJobConfig = deserializeHyperParameterTuningJobConfigDocument(deserializer)
                HYPERPARAMETERTUNINGJOBNAME_DESCRIPTOR.index -> builder.hyperParameterTuningJobName = deserializeString()
                HYPERPARAMETERTUNINGJOBSTATUS_DESCRIPTOR.index -> builder.hyperParameterTuningJobStatus = deserializeString().let { HyperParameterTuningJobStatus.fromValue(it) }
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                OBJECTIVESTATUSCOUNTERS_DESCRIPTOR.index -> builder.objectiveStatusCounters = deserializeObjectiveStatusCountersDocument(deserializer)
                OVERALLBESTTRAININGJOB_DESCRIPTOR.index -> builder.overallBestTrainingJob = deserializeHyperParameterTrainingJobSummaryDocument(deserializer)
                TRAININGJOBDEFINITION_DESCRIPTOR.index -> builder.trainingJobDefinition = deserializeHyperParameterTrainingJobDefinitionDocument(deserializer)
                TRAININGJOBDEFINITIONS_DESCRIPTOR.index -> builder.trainingJobDefinitions =
                    deserializer.deserializeList(TRAININGJOBDEFINITIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<HyperParameterTrainingJobDefinition>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeHyperParameterTrainingJobDefinitionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TRAININGJOBSTATUSCOUNTERS_DESCRIPTOR.index -> builder.trainingJobStatusCounters = deserializeTrainingJobStatusCountersDocument(deserializer)
                TUNINGJOBCOMPLETIONDETAILS_DESCRIPTOR.index -> builder.tuningJobCompletionDetails = deserializeHyperParameterTuningJobCompletionDetailsDocument(deserializer)
                WARMSTARTCONFIG_DESCRIPTOR.index -> builder.warmStartConfig = deserializeHyperParameterTuningJobWarmStartConfigDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
