// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.DescribeExperimentResponse
import aws.sdk.kotlin.services.sagemaker.model.ExperimentSource
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.sdk.kotlin.services.sagemaker.model.UserContext
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeExperimentOperationDeserializer: HttpDeserializer.NonStreaming<DescribeExperimentResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeExperimentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeExperimentError(context, call, payload)
        }
        val builder = DescribeExperimentResponse.Builder()

        if (payload != null) {
            deserializeDescribeExperimentOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeExperimentError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedCall, payload)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeExperimentOperationBody(builder: DescribeExperimentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CreatedBy"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val DISPLAYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DisplayName"))
    val EXPERIMENTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ExperimentArn"))
    val EXPERIMENTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ExperimentName"))
    val LASTMODIFIEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LastModifiedBy"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val SOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Source"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATEDBY_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DISPLAYNAME_DESCRIPTOR)
        field(EXPERIMENTARN_DESCRIPTOR)
        field(EXPERIMENTNAME_DESCRIPTOR)
        field(LASTMODIFIEDBY_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(SOURCE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEDBY_DESCRIPTOR.index -> builder.createdBy = deserializeUserContextDocument(deserializer)
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                DISPLAYNAME_DESCRIPTOR.index -> builder.displayName = deserializeString()
                EXPERIMENTARN_DESCRIPTOR.index -> builder.experimentArn = deserializeString()
                EXPERIMENTNAME_DESCRIPTOR.index -> builder.experimentName = deserializeString()
                LASTMODIFIEDBY_DESCRIPTOR.index -> builder.lastModifiedBy = deserializeUserContextDocument(deserializer)
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                SOURCE_DESCRIPTOR.index -> builder.source = deserializeExperimentSourceDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
