// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The workspace settings for the SageMaker Canvas application.
 */
public class WorkspaceSettings private constructor(builder: Builder) {
    /**
     * The Amazon S3 bucket used to store artifacts generated by Canvas. Updating the Amazon S3 location impacts existing configuration settings, and Canvas users no longer have access to their artifacts. Canvas users must log out and log back in to apply the new location.
     */
    public val s3ArtifactPath: kotlin.String? = builder.s3ArtifactPath
    /**
     * The Amazon Web Services Key Management Service (KMS) encryption key ID that is used to encrypt artifacts generated by Canvas in the Amazon S3 bucket.
     */
    public val s3KmsKeyId: kotlin.String? = builder.s3KmsKeyId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.WorkspaceSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WorkspaceSettings(")
        append("s3ArtifactPath=$s3ArtifactPath,")
        append("s3KmsKeyId=$s3KmsKeyId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = s3ArtifactPath?.hashCode() ?: 0
        result = 31 * result + (s3KmsKeyId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WorkspaceSettings

        if (s3ArtifactPath != other.s3ArtifactPath) return false
        if (s3KmsKeyId != other.s3KmsKeyId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.WorkspaceSettings = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon S3 bucket used to store artifacts generated by Canvas. Updating the Amazon S3 location impacts existing configuration settings, and Canvas users no longer have access to their artifacts. Canvas users must log out and log back in to apply the new location.
         */
        public var s3ArtifactPath: kotlin.String? = null
        /**
         * The Amazon Web Services Key Management Service (KMS) encryption key ID that is used to encrypt artifacts generated by Canvas in the Amazon S3 bucket.
         */
        public var s3KmsKeyId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.WorkspaceSettings) : this() {
            this.s3ArtifactPath = x.s3ArtifactPath
            this.s3KmsKeyId = x.s3KmsKeyId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.WorkspaceSettings = WorkspaceSettings(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
