// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The new throughput configuration for the feature group. You can switch between on-demand and provisioned modes or update the read / write capacity of provisioned feature groups. You can switch a feature group to on-demand only once in a 24 hour period.
 */
public class ThroughputConfigUpdate private constructor(builder: Builder) {
    /**
     * For provisioned feature groups with online store enabled, this indicates the read throughput you are billed for and can consume without throttling.
     */
    public val provisionedReadCapacityUnits: kotlin.Int? = builder.provisionedReadCapacityUnits
    /**
     * For provisioned feature groups, this indicates the write throughput you are billed for and can consume without throttling.
     */
    public val provisionedWriteCapacityUnits: kotlin.Int? = builder.provisionedWriteCapacityUnits
    /**
     * Target throughput mode of the feature group. Throughput update is an asynchronous operation, and the outcome should be monitored by polling `LastUpdateStatus` field in `DescribeFeatureGroup` response. You cannot update a feature group's throughput while another update is in progress.
     */
    public val throughputMode: aws.sdk.kotlin.services.sagemaker.model.ThroughputMode? = builder.throughputMode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ThroughputConfigUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ThroughputConfigUpdate(")
        append("provisionedReadCapacityUnits=$provisionedReadCapacityUnits,")
        append("provisionedWriteCapacityUnits=$provisionedWriteCapacityUnits,")
        append("throughputMode=$throughputMode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = provisionedReadCapacityUnits ?: 0
        result = 31 * result + (provisionedWriteCapacityUnits ?: 0)
        result = 31 * result + (throughputMode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ThroughputConfigUpdate

        if (provisionedReadCapacityUnits != other.provisionedReadCapacityUnits) return false
        if (provisionedWriteCapacityUnits != other.provisionedWriteCapacityUnits) return false
        if (throughputMode != other.throughputMode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ThroughputConfigUpdate = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * For provisioned feature groups with online store enabled, this indicates the read throughput you are billed for and can consume without throttling.
         */
        public var provisionedReadCapacityUnits: kotlin.Int? = null
        /**
         * For provisioned feature groups, this indicates the write throughput you are billed for and can consume without throttling.
         */
        public var provisionedWriteCapacityUnits: kotlin.Int? = null
        /**
         * Target throughput mode of the feature group. Throughput update is an asynchronous operation, and the outcome should be monitored by polling `LastUpdateStatus` field in `DescribeFeatureGroup` response. You cannot update a feature group's throughput while another update is in progress.
         */
        public var throughputMode: aws.sdk.kotlin.services.sagemaker.model.ThroughputMode? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ThroughputConfigUpdate) : this() {
            this.provisionedReadCapacityUnits = x.provisionedReadCapacityUnits
            this.provisionedWriteCapacityUnits = x.provisionedWriteCapacityUnits
            this.throughputMode = x.throughputMode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ThroughputConfigUpdate = ThroughputConfigUpdate(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
