// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies options for sharing Amazon SageMaker Studio notebooks. These settings are specified as part of `DefaultUserSettings` when the `CreateDomain` API is called, and as part of `UserSettings` when the `CreateUserProfile` API is called. When `SharingSettings` is not specified, notebook sharing isn't allowed.
 */
public class SharingSettings private constructor(builder: Builder) {
    /**
     * Whether to include the notebook cell output when sharing the notebook. The default is `Disabled`.
     */
    public val notebookOutputOption: aws.sdk.kotlin.services.sagemaker.model.NotebookOutputOption? = builder.notebookOutputOption
    /**
     * When `NotebookOutputOption` is `Allowed`, the Amazon Web Services Key Management Service (KMS) encryption key ID used to encrypt the notebook cell output in the Amazon S3 bucket.
     */
    public val s3KmsKeyId: kotlin.String? = builder.s3KmsKeyId
    /**
     * When `NotebookOutputOption` is `Allowed`, the Amazon S3 bucket used to store the shared notebook snapshots.
     */
    public val s3OutputPath: kotlin.String? = builder.s3OutputPath

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.SharingSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SharingSettings(")
        append("notebookOutputOption=$notebookOutputOption,")
        append("s3KmsKeyId=$s3KmsKeyId,")
        append("s3OutputPath=$s3OutputPath")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = notebookOutputOption?.hashCode() ?: 0
        result = 31 * result + (s3KmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (s3OutputPath?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SharingSettings

        if (notebookOutputOption != other.notebookOutputOption) return false
        if (s3KmsKeyId != other.s3KmsKeyId) return false
        if (s3OutputPath != other.s3OutputPath) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.SharingSettings = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Whether to include the notebook cell output when sharing the notebook. The default is `Disabled`.
         */
        public var notebookOutputOption: aws.sdk.kotlin.services.sagemaker.model.NotebookOutputOption? = null
        /**
         * When `NotebookOutputOption` is `Allowed`, the Amazon Web Services Key Management Service (KMS) encryption key ID used to encrypt the notebook cell output in the Amazon S3 bucket.
         */
        public var s3KmsKeyId: kotlin.String? = null
        /**
         * When `NotebookOutputOption` is `Allowed`, the Amazon S3 bucket used to store the shared notebook snapshots.
         */
        public var s3OutputPath: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.SharingSettings) : this() {
            this.notebookOutputOption = x.notebookOutputOption
            this.s3KmsKeyId = x.s3KmsKeyId
            this.s3OutputPath = x.s3OutputPath
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.SharingSettings = SharingSettings(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
