// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about hub content.
 */
public class HubContentInfo private constructor(builder: Builder) {
    /**
     * The date and time that the hub content was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The version of the hub content document schema.
     */
    public val documentSchemaVersion: kotlin.String? = builder.documentSchemaVersion
    /**
     * The Amazon Resource Name (ARN) of the hub content.
     */
    public val hubContentArn: kotlin.String? = builder.hubContentArn
    /**
     * A description of the hub content.
     */
    public val hubContentDescription: kotlin.String? = builder.hubContentDescription
    /**
     * The display name of the hub content.
     */
    public val hubContentDisplayName: kotlin.String? = builder.hubContentDisplayName
    /**
     * The name of the hub content.
     */
    public val hubContentName: kotlin.String? = builder.hubContentName
    /**
     * The searchable keywords for the hub content.
     */
    public val hubContentSearchKeywords: List<String>? = builder.hubContentSearchKeywords
    /**
     * The status of the hub content.
     */
    public val hubContentStatus: aws.sdk.kotlin.services.sagemaker.model.HubContentStatus? = builder.hubContentStatus
    /**
     * The type of hub content.
     */
    public val hubContentType: aws.sdk.kotlin.services.sagemaker.model.HubContentType? = builder.hubContentType
    /**
     * The version of the hub content.
     */
    public val hubContentVersion: kotlin.String? = builder.hubContentVersion
    /**
     * The date and time when the hub content was originally created, before any updates or revisions.
     */
    public val originalCreationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.originalCreationTime
    /**
     * The ARN of the public hub content.
     */
    public val sageMakerPublicHubContentArn: kotlin.String? = builder.sageMakerPublicHubContentArn
    /**
     * The support status of the hub content.
     */
    public val supportStatus: aws.sdk.kotlin.services.sagemaker.model.HubContentSupportStatus? = builder.supportStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.HubContentInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HubContentInfo(")
        append("creationTime=$creationTime,")
        append("documentSchemaVersion=$documentSchemaVersion,")
        append("hubContentArn=$hubContentArn,")
        append("hubContentDescription=$hubContentDescription,")
        append("hubContentDisplayName=$hubContentDisplayName,")
        append("hubContentName=$hubContentName,")
        append("hubContentSearchKeywords=$hubContentSearchKeywords,")
        append("hubContentStatus=$hubContentStatus,")
        append("hubContentType=$hubContentType,")
        append("hubContentVersion=$hubContentVersion,")
        append("originalCreationTime=$originalCreationTime,")
        append("sageMakerPublicHubContentArn=$sageMakerPublicHubContentArn,")
        append("supportStatus=$supportStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (documentSchemaVersion?.hashCode() ?: 0)
        result = 31 * result + (hubContentArn?.hashCode() ?: 0)
        result = 31 * result + (hubContentDescription?.hashCode() ?: 0)
        result = 31 * result + (hubContentDisplayName?.hashCode() ?: 0)
        result = 31 * result + (hubContentName?.hashCode() ?: 0)
        result = 31 * result + (hubContentSearchKeywords?.hashCode() ?: 0)
        result = 31 * result + (hubContentStatus?.hashCode() ?: 0)
        result = 31 * result + (hubContentType?.hashCode() ?: 0)
        result = 31 * result + (hubContentVersion?.hashCode() ?: 0)
        result = 31 * result + (originalCreationTime?.hashCode() ?: 0)
        result = 31 * result + (sageMakerPublicHubContentArn?.hashCode() ?: 0)
        result = 31 * result + (supportStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HubContentInfo

        if (creationTime != other.creationTime) return false
        if (documentSchemaVersion != other.documentSchemaVersion) return false
        if (hubContentArn != other.hubContentArn) return false
        if (hubContentDescription != other.hubContentDescription) return false
        if (hubContentDisplayName != other.hubContentDisplayName) return false
        if (hubContentName != other.hubContentName) return false
        if (hubContentSearchKeywords != other.hubContentSearchKeywords) return false
        if (hubContentStatus != other.hubContentStatus) return false
        if (hubContentType != other.hubContentType) return false
        if (hubContentVersion != other.hubContentVersion) return false
        if (originalCreationTime != other.originalCreationTime) return false
        if (sageMakerPublicHubContentArn != other.sageMakerPublicHubContentArn) return false
        if (supportStatus != other.supportStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.HubContentInfo = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date and time that the hub content was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The version of the hub content document schema.
         */
        public var documentSchemaVersion: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the hub content.
         */
        public var hubContentArn: kotlin.String? = null
        /**
         * A description of the hub content.
         */
        public var hubContentDescription: kotlin.String? = null
        /**
         * The display name of the hub content.
         */
        public var hubContentDisplayName: kotlin.String? = null
        /**
         * The name of the hub content.
         */
        public var hubContentName: kotlin.String? = null
        /**
         * The searchable keywords for the hub content.
         */
        public var hubContentSearchKeywords: List<String>? = null
        /**
         * The status of the hub content.
         */
        public var hubContentStatus: aws.sdk.kotlin.services.sagemaker.model.HubContentStatus? = null
        /**
         * The type of hub content.
         */
        public var hubContentType: aws.sdk.kotlin.services.sagemaker.model.HubContentType? = null
        /**
         * The version of the hub content.
         */
        public var hubContentVersion: kotlin.String? = null
        /**
         * The date and time when the hub content was originally created, before any updates or revisions.
         */
        public var originalCreationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the public hub content.
         */
        public var sageMakerPublicHubContentArn: kotlin.String? = null
        /**
         * The support status of the hub content.
         */
        public var supportStatus: aws.sdk.kotlin.services.sagemaker.model.HubContentSupportStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.HubContentInfo) : this() {
            this.creationTime = x.creationTime
            this.documentSchemaVersion = x.documentSchemaVersion
            this.hubContentArn = x.hubContentArn
            this.hubContentDescription = x.hubContentDescription
            this.hubContentDisplayName = x.hubContentDisplayName
            this.hubContentName = x.hubContentName
            this.hubContentSearchKeywords = x.hubContentSearchKeywords
            this.hubContentStatus = x.hubContentStatus
            this.hubContentType = x.hubContentType
            this.hubContentVersion = x.hubContentVersion
            this.originalCreationTime = x.originalCreationTime
            this.sageMakerPublicHubContentArn = x.sageMakerPublicHubContentArn
            this.supportStatus = x.supportStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.HubContentInfo = HubContentInfo(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
