// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeTrainingJobResponse private constructor(builder: Builder) {
    /**
     * Information about the algorithm used for training, and algorithm metadata.
     */
    public val algorithmSpecification: aws.sdk.kotlin.services.sagemaker.model.AlgorithmSpecification? = builder.algorithmSpecification
    /**
     * The Amazon Resource Name (ARN) of an AutoML job.
     */
    public val autoMlJobArn: kotlin.String? = builder.autoMlJobArn
    /**
     * The billable time in seconds. Billable time refers to the absolute wall-clock time.
     *
     * Multiply `BillableTimeInSeconds` by the number of instances (`InstanceCount`) in your training cluster to get the total compute time SageMaker bills you if you run distributed training. The formula is as follows: `BillableTimeInSeconds * InstanceCount` .
     *
     * You can calculate the savings from using managed spot training using the formula `(1 - BillableTimeInSeconds / TrainingTimeInSeconds) * 100`. For example, if `BillableTimeInSeconds` is 100 and `TrainingTimeInSeconds` is 500, the savings is 80%.
     */
    public val billableTimeInSeconds: kotlin.Int? = builder.billableTimeInSeconds
    /**
     * Contains information about the output location for managed spot training checkpoint data.
     */
    public val checkpointConfig: aws.sdk.kotlin.services.sagemaker.model.CheckpointConfig? = builder.checkpointConfig
    /**
     * A timestamp that indicates when the training job was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * Configuration information for the Amazon SageMaker Debugger hook parameters, metric and tensor collections, and storage paths. To learn more about how to configure the `DebugHookConfig` parameter, see [Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job](https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html).
     */
    public val debugHookConfig: aws.sdk.kotlin.services.sagemaker.model.DebugHookConfig? = builder.debugHookConfig
    /**
     * Configuration information for Amazon SageMaker Debugger rules for debugging output tensors.
     */
    public val debugRuleConfigurations: List<DebugRuleConfiguration>? = builder.debugRuleConfigurations
    /**
     * Evaluation status of Amazon SageMaker Debugger rules for debugging on a training job.
     */
    public val debugRuleEvaluationStatuses: List<DebugRuleEvaluationStatus>? = builder.debugRuleEvaluationStatuses
    /**
     * To encrypt all communications between ML compute instances in distributed training, choose `True`. Encryption provides greater security for distributed training, but training might take longer. How long it takes depends on the amount of communication between compute instances, especially if you use a deep learning algorithms in distributed training.
     */
    public val enableInterContainerTrafficEncryption: kotlin.Boolean? = builder.enableInterContainerTrafficEncryption
    /**
     * A Boolean indicating whether managed spot training is enabled (`True`) or not (`False`).
     */
    public val enableManagedSpotTraining: kotlin.Boolean? = builder.enableManagedSpotTraining
    /**
     * If you want to allow inbound or outbound network calls, except for calls between peers within a training cluster for distributed training, choose `True`. If you enable network isolation for training jobs that are configured to use a VPC, SageMaker downloads and uploads customer data and model artifacts through the specified VPC, but the training container does not have network access.
     */
    public val enableNetworkIsolation: kotlin.Boolean? = builder.enableNetworkIsolation
    /**
     * The environment variables to set in the Docker container.
     */
    public val environment: Map<String, String>? = builder.environment
    /**
     * Associates a SageMaker job as a trial component with an experiment and trial. Specified when you call the following APIs:
     * + [CreateProcessingJob](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateProcessingJob.html)
     * + [CreateTrainingJob](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrainingJob.html)
     * + [CreateTransformJob](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTransformJob.html)
     */
    public val experimentConfig: aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig? = builder.experimentConfig
    /**
     * If the training job failed, the reason it failed.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * A collection of `MetricData` objects that specify the names, values, and dates and times that the training algorithm emitted to Amazon CloudWatch.
     */
    public val finalMetricDataList: List<MetricData>? = builder.finalMetricDataList
    /**
     * Algorithm-specific parameters.
     */
    public val hyperParameters: Map<String, String>? = builder.hyperParameters
    /**
     * Contains information about the infrastructure health check configuration for the training job.
     */
    public val infraCheckConfig: aws.sdk.kotlin.services.sagemaker.model.InfraCheckConfig? = builder.infraCheckConfig
    /**
     * An array of `Channel` objects that describes each data input channel.
     */
    public val inputDataConfig: List<Channel>? = builder.inputDataConfig
    /**
     * The Amazon Resource Name (ARN) of the SageMaker Ground Truth labeling job that created the transform or training job.
     */
    public val labelingJobArn: kotlin.String? = builder.labelingJobArn
    /**
     * A timestamp that indicates when the status of the training job was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * Information about the Amazon S3 location that is configured for storing model artifacts.
     */
    public val modelArtifacts: aws.sdk.kotlin.services.sagemaker.model.ModelArtifacts? = builder.modelArtifacts
    /**
     * The S3 path where model artifacts that you configured when creating the job are stored. SageMaker creates subfolders for model artifacts.
     */
    public val outputDataConfig: aws.sdk.kotlin.services.sagemaker.model.OutputDataConfig? = builder.outputDataConfig
    /**
     * Configuration information for Amazon SageMaker Debugger system monitoring, framework profiling, and storage paths.
     */
    public val profilerConfig: aws.sdk.kotlin.services.sagemaker.model.ProfilerConfig? = builder.profilerConfig
    /**
     * Configuration information for Amazon SageMaker Debugger rules for profiling system and framework metrics.
     */
    public val profilerRuleConfigurations: List<ProfilerRuleConfiguration>? = builder.profilerRuleConfigurations
    /**
     * Evaluation status of Amazon SageMaker Debugger rules for profiling on a training job.
     */
    public val profilerRuleEvaluationStatuses: List<ProfilerRuleEvaluationStatus>? = builder.profilerRuleEvaluationStatuses
    /**
     * Profiling status of a training job.
     */
    public val profilingStatus: aws.sdk.kotlin.services.sagemaker.model.ProfilingStatus? = builder.profilingStatus
    /**
     * Configuration for remote debugging. To learn more about the remote debugging functionality of SageMaker, see [Access a training container through Amazon Web Services Systems Manager (SSM) for remote debugging](https://docs.aws.amazon.com/sagemaker/latest/dg/train-remote-debugging.html).
     */
    public val remoteDebugConfig: aws.sdk.kotlin.services.sagemaker.model.RemoteDebugConfig? = builder.remoteDebugConfig
    /**
     * Resources, including ML compute instances and ML storage volumes, that are configured for model training.
     */
    public val resourceConfig: aws.sdk.kotlin.services.sagemaker.model.ResourceConfig? = builder.resourceConfig
    /**
     * The number of times to retry the job when the job fails due to an `InternalServerError`.
     */
    public val retryStrategy: aws.sdk.kotlin.services.sagemaker.model.RetryStrategy? = builder.retryStrategy
    /**
     * The Amazon Web Services Identity and Access Management (IAM) role configured for the training job.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * Provides detailed information about the state of the training job. For detailed information on the secondary status of the training job, see `StatusMessage` under [SecondaryStatusTransition](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_SecondaryStatusTransition.html).
     *
     * SageMaker provides primary statuses and secondary statuses that apply to each of them:
     *
     * ## InProgress
     * + `Starting` - Starting the training job.
     * + `Downloading` - An optional stage for algorithms that support `File` training input mode. It indicates that data is being downloaded to the ML storage volumes.
     * + `Training` - Training is in progress.
     * + `Interrupted` - The job stopped because the managed spot training instances were interrupted.
     * + `Uploading` - Training is complete and the model artifacts are being uploaded to the S3 location.
     *
     * ## Completed
     * + `Completed` - The training job has completed.
     *
     * ## Failed
     * + `Failed` - The training job has failed. The reason for the failure is returned in the `FailureReason` field of `DescribeTrainingJobResponse`.
     *
     * ## Stopped
     * + `MaxRuntimeExceeded` - The job stopped because it exceeded the maximum allowed runtime.
     * + `MaxWaitTimeExceeded` - The job stopped because it exceeded the maximum allowed wait time.
     * + `Stopped` - The training job has stopped.
     *
     * ## Stopping
     * + `Stopping` - Stopping the training job.
     *
     * Valid values for `SecondaryStatus` are subject to change.
     *
     * We no longer support the following secondary statuses:
     * + `LaunchingMLInstances`
     * + `PreparingTraining`
     * + `DownloadingTrainingImage`
     */
    public val secondaryStatus: aws.sdk.kotlin.services.sagemaker.model.SecondaryStatus? = builder.secondaryStatus
    /**
     * A history of all of the secondary statuses that the training job has transitioned through.
     */
    public val secondaryStatusTransitions: List<SecondaryStatusTransition>? = builder.secondaryStatusTransitions
    /**
     * Specifies a limit to how long a model training job can run. It also specifies how long a managed Spot training job has to complete. When the job reaches the time limit, SageMaker ends the training job. Use this API to cap model training costs.
     *
     * To stop a job, SageMaker sends the algorithm the `SIGTERM` signal, which delays job termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the results of training are not lost.
     */
    public val stoppingCondition: aws.sdk.kotlin.services.sagemaker.model.StoppingCondition? = builder.stoppingCondition
    /**
     * Configuration of storage locations for the Amazon SageMaker Debugger TensorBoard output data.
     */
    public val tensorBoardOutputConfig: aws.sdk.kotlin.services.sagemaker.model.TensorBoardOutputConfig? = builder.tensorBoardOutputConfig
    /**
     * Indicates the time when the training job ends on training instances. You are billed for the time interval between the value of `TrainingStartTime` and this time. For successful jobs and stopped jobs, this is the time after model artifacts are uploaded. For failed jobs, this is the time when SageMaker detects a job failure.
     */
    public val trainingEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.trainingEndTime
    /**
     * The Amazon Resource Name (ARN) of the training job.
     */
    public val trainingJobArn: kotlin.String? = builder.trainingJobArn
    /**
     * Name of the model training job.
     */
    public val trainingJobName: kotlin.String? = builder.trainingJobName
    /**
     * The status of the training job.
     *
     * SageMaker provides the following training job statuses:
     * + `InProgress` - The training is in progress.
     * + `Completed` - The training job has completed.
     * + `Failed` - The training job has failed. To see the reason for the failure, see the `FailureReason` field in the response to a `DescribeTrainingJobResponse` call.
     * + `Stopping` - The training job is stopping.
     * + `Stopped` - The training job has stopped.
     *
     * For more detailed information, see `SecondaryStatus`.
     */
    public val trainingJobStatus: aws.sdk.kotlin.services.sagemaker.model.TrainingJobStatus? = builder.trainingJobStatus
    /**
     * Indicates the time when the training job starts on training instances. You are billed for the time interval between this time and the value of `TrainingEndTime`. The start time in CloudWatch Logs might be later than this time. The difference is due to the time it takes to download the training data and to the size of the training container.
     */
    public val trainingStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.trainingStartTime
    /**
     * The training time in seconds.
     */
    public val trainingTimeInSeconds: kotlin.Int? = builder.trainingTimeInSeconds
    /**
     * The Amazon Resource Name (ARN) of the associated hyperparameter tuning job if the training job was launched by a hyperparameter tuning job.
     */
    public val tuningJobArn: kotlin.String? = builder.tuningJobArn
    /**
     * A [VpcConfig](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VpcConfig.html) object that specifies the VPC that this training job has access to. For more information, see [Protect Training Jobs by Using an Amazon Virtual Private Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html).
     */
    public val vpcConfig: aws.sdk.kotlin.services.sagemaker.model.VpcConfig? = builder.vpcConfig
    /**
     * The status of the warm pool associated with the training job.
     */
    public val warmPoolStatus: aws.sdk.kotlin.services.sagemaker.model.WarmPoolStatus? = builder.warmPoolStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.DescribeTrainingJobResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeTrainingJobResponse(")
        append("algorithmSpecification=$algorithmSpecification,")
        append("autoMlJobArn=$autoMlJobArn,")
        append("billableTimeInSeconds=$billableTimeInSeconds,")
        append("checkpointConfig=$checkpointConfig,")
        append("creationTime=$creationTime,")
        append("debugHookConfig=$debugHookConfig,")
        append("debugRuleConfigurations=$debugRuleConfigurations,")
        append("debugRuleEvaluationStatuses=$debugRuleEvaluationStatuses,")
        append("enableInterContainerTrafficEncryption=$enableInterContainerTrafficEncryption,")
        append("enableManagedSpotTraining=$enableManagedSpotTraining,")
        append("enableNetworkIsolation=$enableNetworkIsolation,")
        append("environment=$environment,")
        append("experimentConfig=$experimentConfig,")
        append("failureReason=$failureReason,")
        append("finalMetricDataList=$finalMetricDataList,")
        append("hyperParameters=$hyperParameters,")
        append("infraCheckConfig=$infraCheckConfig,")
        append("inputDataConfig=$inputDataConfig,")
        append("labelingJobArn=$labelingJobArn,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("modelArtifacts=$modelArtifacts,")
        append("outputDataConfig=$outputDataConfig,")
        append("profilerConfig=$profilerConfig,")
        append("profilerRuleConfigurations=$profilerRuleConfigurations,")
        append("profilerRuleEvaluationStatuses=$profilerRuleEvaluationStatuses,")
        append("profilingStatus=$profilingStatus,")
        append("remoteDebugConfig=$remoteDebugConfig,")
        append("resourceConfig=$resourceConfig,")
        append("retryStrategy=$retryStrategy,")
        append("roleArn=$roleArn,")
        append("secondaryStatus=$secondaryStatus,")
        append("secondaryStatusTransitions=$secondaryStatusTransitions,")
        append("stoppingCondition=$stoppingCondition,")
        append("tensorBoardOutputConfig=$tensorBoardOutputConfig,")
        append("trainingEndTime=$trainingEndTime,")
        append("trainingJobArn=$trainingJobArn,")
        append("trainingJobName=$trainingJobName,")
        append("trainingJobStatus=$trainingJobStatus,")
        append("trainingStartTime=$trainingStartTime,")
        append("trainingTimeInSeconds=$trainingTimeInSeconds,")
        append("tuningJobArn=$tuningJobArn,")
        append("vpcConfig=$vpcConfig,")
        append("warmPoolStatus=$warmPoolStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = algorithmSpecification?.hashCode() ?: 0
        result = 31 * result + (autoMlJobArn?.hashCode() ?: 0)
        result = 31 * result + (billableTimeInSeconds ?: 0)
        result = 31 * result + (checkpointConfig?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (debugHookConfig?.hashCode() ?: 0)
        result = 31 * result + (debugRuleConfigurations?.hashCode() ?: 0)
        result = 31 * result + (debugRuleEvaluationStatuses?.hashCode() ?: 0)
        result = 31 * result + (enableInterContainerTrafficEncryption?.hashCode() ?: 0)
        result = 31 * result + (enableManagedSpotTraining?.hashCode() ?: 0)
        result = 31 * result + (enableNetworkIsolation?.hashCode() ?: 0)
        result = 31 * result + (environment?.hashCode() ?: 0)
        result = 31 * result + (experimentConfig?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (finalMetricDataList?.hashCode() ?: 0)
        result = 31 * result + (hyperParameters?.hashCode() ?: 0)
        result = 31 * result + (infraCheckConfig?.hashCode() ?: 0)
        result = 31 * result + (inputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (labelingJobArn?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (modelArtifacts?.hashCode() ?: 0)
        result = 31 * result + (outputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (profilerConfig?.hashCode() ?: 0)
        result = 31 * result + (profilerRuleConfigurations?.hashCode() ?: 0)
        result = 31 * result + (profilerRuleEvaluationStatuses?.hashCode() ?: 0)
        result = 31 * result + (profilingStatus?.hashCode() ?: 0)
        result = 31 * result + (remoteDebugConfig?.hashCode() ?: 0)
        result = 31 * result + (resourceConfig?.hashCode() ?: 0)
        result = 31 * result + (retryStrategy?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (secondaryStatus?.hashCode() ?: 0)
        result = 31 * result + (secondaryStatusTransitions?.hashCode() ?: 0)
        result = 31 * result + (stoppingCondition?.hashCode() ?: 0)
        result = 31 * result + (tensorBoardOutputConfig?.hashCode() ?: 0)
        result = 31 * result + (trainingEndTime?.hashCode() ?: 0)
        result = 31 * result + (trainingJobArn?.hashCode() ?: 0)
        result = 31 * result + (trainingJobName?.hashCode() ?: 0)
        result = 31 * result + (trainingJobStatus?.hashCode() ?: 0)
        result = 31 * result + (trainingStartTime?.hashCode() ?: 0)
        result = 31 * result + (trainingTimeInSeconds ?: 0)
        result = 31 * result + (tuningJobArn?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        result = 31 * result + (warmPoolStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeTrainingJobResponse

        if (algorithmSpecification != other.algorithmSpecification) return false
        if (autoMlJobArn != other.autoMlJobArn) return false
        if (billableTimeInSeconds != other.billableTimeInSeconds) return false
        if (checkpointConfig != other.checkpointConfig) return false
        if (creationTime != other.creationTime) return false
        if (debugHookConfig != other.debugHookConfig) return false
        if (debugRuleConfigurations != other.debugRuleConfigurations) return false
        if (debugRuleEvaluationStatuses != other.debugRuleEvaluationStatuses) return false
        if (enableInterContainerTrafficEncryption != other.enableInterContainerTrafficEncryption) return false
        if (enableManagedSpotTraining != other.enableManagedSpotTraining) return false
        if (enableNetworkIsolation != other.enableNetworkIsolation) return false
        if (environment != other.environment) return false
        if (experimentConfig != other.experimentConfig) return false
        if (failureReason != other.failureReason) return false
        if (finalMetricDataList != other.finalMetricDataList) return false
        if (hyperParameters != other.hyperParameters) return false
        if (infraCheckConfig != other.infraCheckConfig) return false
        if (inputDataConfig != other.inputDataConfig) return false
        if (labelingJobArn != other.labelingJobArn) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (modelArtifacts != other.modelArtifacts) return false
        if (outputDataConfig != other.outputDataConfig) return false
        if (profilerConfig != other.profilerConfig) return false
        if (profilerRuleConfigurations != other.profilerRuleConfigurations) return false
        if (profilerRuleEvaluationStatuses != other.profilerRuleEvaluationStatuses) return false
        if (profilingStatus != other.profilingStatus) return false
        if (remoteDebugConfig != other.remoteDebugConfig) return false
        if (resourceConfig != other.resourceConfig) return false
        if (retryStrategy != other.retryStrategy) return false
        if (roleArn != other.roleArn) return false
        if (secondaryStatus != other.secondaryStatus) return false
        if (secondaryStatusTransitions != other.secondaryStatusTransitions) return false
        if (stoppingCondition != other.stoppingCondition) return false
        if (tensorBoardOutputConfig != other.tensorBoardOutputConfig) return false
        if (trainingEndTime != other.trainingEndTime) return false
        if (trainingJobArn != other.trainingJobArn) return false
        if (trainingJobName != other.trainingJobName) return false
        if (trainingJobStatus != other.trainingJobStatus) return false
        if (trainingStartTime != other.trainingStartTime) return false
        if (trainingTimeInSeconds != other.trainingTimeInSeconds) return false
        if (tuningJobArn != other.tuningJobArn) return false
        if (vpcConfig != other.vpcConfig) return false
        if (warmPoolStatus != other.warmPoolStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.DescribeTrainingJobResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Information about the algorithm used for training, and algorithm metadata.
         */
        public var algorithmSpecification: aws.sdk.kotlin.services.sagemaker.model.AlgorithmSpecification? = null
        /**
         * The Amazon Resource Name (ARN) of an AutoML job.
         */
        public var autoMlJobArn: kotlin.String? = null
        /**
         * The billable time in seconds. Billable time refers to the absolute wall-clock time.
         *
         * Multiply `BillableTimeInSeconds` by the number of instances (`InstanceCount`) in your training cluster to get the total compute time SageMaker bills you if you run distributed training. The formula is as follows: `BillableTimeInSeconds * InstanceCount` .
         *
         * You can calculate the savings from using managed spot training using the formula `(1 - BillableTimeInSeconds / TrainingTimeInSeconds) * 100`. For example, if `BillableTimeInSeconds` is 100 and `TrainingTimeInSeconds` is 500, the savings is 80%.
         */
        public var billableTimeInSeconds: kotlin.Int? = null
        /**
         * Contains information about the output location for managed spot training checkpoint data.
         */
        public var checkpointConfig: aws.sdk.kotlin.services.sagemaker.model.CheckpointConfig? = null
        /**
         * A timestamp that indicates when the training job was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Configuration information for the Amazon SageMaker Debugger hook parameters, metric and tensor collections, and storage paths. To learn more about how to configure the `DebugHookConfig` parameter, see [Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job](https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html).
         */
        public var debugHookConfig: aws.sdk.kotlin.services.sagemaker.model.DebugHookConfig? = null
        /**
         * Configuration information for Amazon SageMaker Debugger rules for debugging output tensors.
         */
        public var debugRuleConfigurations: List<DebugRuleConfiguration>? = null
        /**
         * Evaluation status of Amazon SageMaker Debugger rules for debugging on a training job.
         */
        public var debugRuleEvaluationStatuses: List<DebugRuleEvaluationStatus>? = null
        /**
         * To encrypt all communications between ML compute instances in distributed training, choose `True`. Encryption provides greater security for distributed training, but training might take longer. How long it takes depends on the amount of communication between compute instances, especially if you use a deep learning algorithms in distributed training.
         */
        public var enableInterContainerTrafficEncryption: kotlin.Boolean? = null
        /**
         * A Boolean indicating whether managed spot training is enabled (`True`) or not (`False`).
         */
        public var enableManagedSpotTraining: kotlin.Boolean? = null
        /**
         * If you want to allow inbound or outbound network calls, except for calls between peers within a training cluster for distributed training, choose `True`. If you enable network isolation for training jobs that are configured to use a VPC, SageMaker downloads and uploads customer data and model artifacts through the specified VPC, but the training container does not have network access.
         */
        public var enableNetworkIsolation: kotlin.Boolean? = null
        /**
         * The environment variables to set in the Docker container.
         */
        public var environment: Map<String, String>? = null
        /**
         * Associates a SageMaker job as a trial component with an experiment and trial. Specified when you call the following APIs:
         * + [CreateProcessingJob](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateProcessingJob.html)
         * + [CreateTrainingJob](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrainingJob.html)
         * + [CreateTransformJob](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTransformJob.html)
         */
        public var experimentConfig: aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig? = null
        /**
         * If the training job failed, the reason it failed.
         */
        public var failureReason: kotlin.String? = null
        /**
         * A collection of `MetricData` objects that specify the names, values, and dates and times that the training algorithm emitted to Amazon CloudWatch.
         */
        public var finalMetricDataList: List<MetricData>? = null
        /**
         * Algorithm-specific parameters.
         */
        public var hyperParameters: Map<String, String>? = null
        /**
         * Contains information about the infrastructure health check configuration for the training job.
         */
        public var infraCheckConfig: aws.sdk.kotlin.services.sagemaker.model.InfraCheckConfig? = null
        /**
         * An array of `Channel` objects that describes each data input channel.
         */
        public var inputDataConfig: List<Channel>? = null
        /**
         * The Amazon Resource Name (ARN) of the SageMaker Ground Truth labeling job that created the transform or training job.
         */
        public var labelingJobArn: kotlin.String? = null
        /**
         * A timestamp that indicates when the status of the training job was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Information about the Amazon S3 location that is configured for storing model artifacts.
         */
        public var modelArtifacts: aws.sdk.kotlin.services.sagemaker.model.ModelArtifacts? = null
        /**
         * The S3 path where model artifacts that you configured when creating the job are stored. SageMaker creates subfolders for model artifacts.
         */
        public var outputDataConfig: aws.sdk.kotlin.services.sagemaker.model.OutputDataConfig? = null
        /**
         * Configuration information for Amazon SageMaker Debugger system monitoring, framework profiling, and storage paths.
         */
        public var profilerConfig: aws.sdk.kotlin.services.sagemaker.model.ProfilerConfig? = null
        /**
         * Configuration information for Amazon SageMaker Debugger rules for profiling system and framework metrics.
         */
        public var profilerRuleConfigurations: List<ProfilerRuleConfiguration>? = null
        /**
         * Evaluation status of Amazon SageMaker Debugger rules for profiling on a training job.
         */
        public var profilerRuleEvaluationStatuses: List<ProfilerRuleEvaluationStatus>? = null
        /**
         * Profiling status of a training job.
         */
        public var profilingStatus: aws.sdk.kotlin.services.sagemaker.model.ProfilingStatus? = null
        /**
         * Configuration for remote debugging. To learn more about the remote debugging functionality of SageMaker, see [Access a training container through Amazon Web Services Systems Manager (SSM) for remote debugging](https://docs.aws.amazon.com/sagemaker/latest/dg/train-remote-debugging.html).
         */
        public var remoteDebugConfig: aws.sdk.kotlin.services.sagemaker.model.RemoteDebugConfig? = null
        /**
         * Resources, including ML compute instances and ML storage volumes, that are configured for model training.
         */
        public var resourceConfig: aws.sdk.kotlin.services.sagemaker.model.ResourceConfig? = null
        /**
         * The number of times to retry the job when the job fails due to an `InternalServerError`.
         */
        public var retryStrategy: aws.sdk.kotlin.services.sagemaker.model.RetryStrategy? = null
        /**
         * The Amazon Web Services Identity and Access Management (IAM) role configured for the training job.
         */
        public var roleArn: kotlin.String? = null
        /**
         * Provides detailed information about the state of the training job. For detailed information on the secondary status of the training job, see `StatusMessage` under [SecondaryStatusTransition](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_SecondaryStatusTransition.html).
         *
         * SageMaker provides primary statuses and secondary statuses that apply to each of them:
         *
         * ## InProgress
         * + `Starting` - Starting the training job.
         * + `Downloading` - An optional stage for algorithms that support `File` training input mode. It indicates that data is being downloaded to the ML storage volumes.
         * + `Training` - Training is in progress.
         * + `Interrupted` - The job stopped because the managed spot training instances were interrupted.
         * + `Uploading` - Training is complete and the model artifacts are being uploaded to the S3 location.
         *
         * ## Completed
         * + `Completed` - The training job has completed.
         *
         * ## Failed
         * + `Failed` - The training job has failed. The reason for the failure is returned in the `FailureReason` field of `DescribeTrainingJobResponse`.
         *
         * ## Stopped
         * + `MaxRuntimeExceeded` - The job stopped because it exceeded the maximum allowed runtime.
         * + `MaxWaitTimeExceeded` - The job stopped because it exceeded the maximum allowed wait time.
         * + `Stopped` - The training job has stopped.
         *
         * ## Stopping
         * + `Stopping` - Stopping the training job.
         *
         * Valid values for `SecondaryStatus` are subject to change.
         *
         * We no longer support the following secondary statuses:
         * + `LaunchingMLInstances`
         * + `PreparingTraining`
         * + `DownloadingTrainingImage`
         */
        public var secondaryStatus: aws.sdk.kotlin.services.sagemaker.model.SecondaryStatus? = null
        /**
         * A history of all of the secondary statuses that the training job has transitioned through.
         */
        public var secondaryStatusTransitions: List<SecondaryStatusTransition>? = null
        /**
         * Specifies a limit to how long a model training job can run. It also specifies how long a managed Spot training job has to complete. When the job reaches the time limit, SageMaker ends the training job. Use this API to cap model training costs.
         *
         * To stop a job, SageMaker sends the algorithm the `SIGTERM` signal, which delays job termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the results of training are not lost.
         */
        public var stoppingCondition: aws.sdk.kotlin.services.sagemaker.model.StoppingCondition? = null
        /**
         * Configuration of storage locations for the Amazon SageMaker Debugger TensorBoard output data.
         */
        public var tensorBoardOutputConfig: aws.sdk.kotlin.services.sagemaker.model.TensorBoardOutputConfig? = null
        /**
         * Indicates the time when the training job ends on training instances. You are billed for the time interval between the value of `TrainingStartTime` and this time. For successful jobs and stopped jobs, this is the time after model artifacts are uploaded. For failed jobs, this is the time when SageMaker detects a job failure.
         */
        public var trainingEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the training job.
         */
        public var trainingJobArn: kotlin.String? = null
        /**
         * Name of the model training job.
         */
        public var trainingJobName: kotlin.String? = null
        /**
         * The status of the training job.
         *
         * SageMaker provides the following training job statuses:
         * + `InProgress` - The training is in progress.
         * + `Completed` - The training job has completed.
         * + `Failed` - The training job has failed. To see the reason for the failure, see the `FailureReason` field in the response to a `DescribeTrainingJobResponse` call.
         * + `Stopping` - The training job is stopping.
         * + `Stopped` - The training job has stopped.
         *
         * For more detailed information, see `SecondaryStatus`.
         */
        public var trainingJobStatus: aws.sdk.kotlin.services.sagemaker.model.TrainingJobStatus? = null
        /**
         * Indicates the time when the training job starts on training instances. You are billed for the time interval between this time and the value of `TrainingEndTime`. The start time in CloudWatch Logs might be later than this time. The difference is due to the time it takes to download the training data and to the size of the training container.
         */
        public var trainingStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The training time in seconds.
         */
        public var trainingTimeInSeconds: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) of the associated hyperparameter tuning job if the training job was launched by a hyperparameter tuning job.
         */
        public var tuningJobArn: kotlin.String? = null
        /**
         * A [VpcConfig](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VpcConfig.html) object that specifies the VPC that this training job has access to. For more information, see [Protect Training Jobs by Using an Amazon Virtual Private Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html).
         */
        public var vpcConfig: aws.sdk.kotlin.services.sagemaker.model.VpcConfig? = null
        /**
         * The status of the warm pool associated with the training job.
         */
        public var warmPoolStatus: aws.sdk.kotlin.services.sagemaker.model.WarmPoolStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.DescribeTrainingJobResponse) : this() {
            this.algorithmSpecification = x.algorithmSpecification
            this.autoMlJobArn = x.autoMlJobArn
            this.billableTimeInSeconds = x.billableTimeInSeconds
            this.checkpointConfig = x.checkpointConfig
            this.creationTime = x.creationTime
            this.debugHookConfig = x.debugHookConfig
            this.debugRuleConfigurations = x.debugRuleConfigurations
            this.debugRuleEvaluationStatuses = x.debugRuleEvaluationStatuses
            this.enableInterContainerTrafficEncryption = x.enableInterContainerTrafficEncryption
            this.enableManagedSpotTraining = x.enableManagedSpotTraining
            this.enableNetworkIsolation = x.enableNetworkIsolation
            this.environment = x.environment
            this.experimentConfig = x.experimentConfig
            this.failureReason = x.failureReason
            this.finalMetricDataList = x.finalMetricDataList
            this.hyperParameters = x.hyperParameters
            this.infraCheckConfig = x.infraCheckConfig
            this.inputDataConfig = x.inputDataConfig
            this.labelingJobArn = x.labelingJobArn
            this.lastModifiedTime = x.lastModifiedTime
            this.modelArtifacts = x.modelArtifacts
            this.outputDataConfig = x.outputDataConfig
            this.profilerConfig = x.profilerConfig
            this.profilerRuleConfigurations = x.profilerRuleConfigurations
            this.profilerRuleEvaluationStatuses = x.profilerRuleEvaluationStatuses
            this.profilingStatus = x.profilingStatus
            this.remoteDebugConfig = x.remoteDebugConfig
            this.resourceConfig = x.resourceConfig
            this.retryStrategy = x.retryStrategy
            this.roleArn = x.roleArn
            this.secondaryStatus = x.secondaryStatus
            this.secondaryStatusTransitions = x.secondaryStatusTransitions
            this.stoppingCondition = x.stoppingCondition
            this.tensorBoardOutputConfig = x.tensorBoardOutputConfig
            this.trainingEndTime = x.trainingEndTime
            this.trainingJobArn = x.trainingJobArn
            this.trainingJobName = x.trainingJobName
            this.trainingJobStatus = x.trainingJobStatus
            this.trainingStartTime = x.trainingStartTime
            this.trainingTimeInSeconds = x.trainingTimeInSeconds
            this.tuningJobArn = x.tuningJobArn
            this.vpcConfig = x.vpcConfig
            this.warmPoolStatus = x.warmPoolStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.DescribeTrainingJobResponse = DescribeTrainingJobResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.AlgorithmSpecification] inside the given [block]
         */
        public fun algorithmSpecification(block: aws.sdk.kotlin.services.sagemaker.model.AlgorithmSpecification.Builder.() -> kotlin.Unit) {
            this.algorithmSpecification = aws.sdk.kotlin.services.sagemaker.model.AlgorithmSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.CheckpointConfig] inside the given [block]
         */
        public fun checkpointConfig(block: aws.sdk.kotlin.services.sagemaker.model.CheckpointConfig.Builder.() -> kotlin.Unit) {
            this.checkpointConfig = aws.sdk.kotlin.services.sagemaker.model.CheckpointConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.DebugHookConfig] inside the given [block]
         */
        public fun debugHookConfig(block: aws.sdk.kotlin.services.sagemaker.model.DebugHookConfig.Builder.() -> kotlin.Unit) {
            this.debugHookConfig = aws.sdk.kotlin.services.sagemaker.model.DebugHookConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig] inside the given [block]
         */
        public fun experimentConfig(block: aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig.Builder.() -> kotlin.Unit) {
            this.experimentConfig = aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.InfraCheckConfig] inside the given [block]
         */
        public fun infraCheckConfig(block: aws.sdk.kotlin.services.sagemaker.model.InfraCheckConfig.Builder.() -> kotlin.Unit) {
            this.infraCheckConfig = aws.sdk.kotlin.services.sagemaker.model.InfraCheckConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ModelArtifacts] inside the given [block]
         */
        public fun modelArtifacts(block: aws.sdk.kotlin.services.sagemaker.model.ModelArtifacts.Builder.() -> kotlin.Unit) {
            this.modelArtifacts = aws.sdk.kotlin.services.sagemaker.model.ModelArtifacts.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.OutputDataConfig] inside the given [block]
         */
        public fun outputDataConfig(block: aws.sdk.kotlin.services.sagemaker.model.OutputDataConfig.Builder.() -> kotlin.Unit) {
            this.outputDataConfig = aws.sdk.kotlin.services.sagemaker.model.OutputDataConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ProfilerConfig] inside the given [block]
         */
        public fun profilerConfig(block: aws.sdk.kotlin.services.sagemaker.model.ProfilerConfig.Builder.() -> kotlin.Unit) {
            this.profilerConfig = aws.sdk.kotlin.services.sagemaker.model.ProfilerConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.RemoteDebugConfig] inside the given [block]
         */
        public fun remoteDebugConfig(block: aws.sdk.kotlin.services.sagemaker.model.RemoteDebugConfig.Builder.() -> kotlin.Unit) {
            this.remoteDebugConfig = aws.sdk.kotlin.services.sagemaker.model.RemoteDebugConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ResourceConfig] inside the given [block]
         */
        public fun resourceConfig(block: aws.sdk.kotlin.services.sagemaker.model.ResourceConfig.Builder.() -> kotlin.Unit) {
            this.resourceConfig = aws.sdk.kotlin.services.sagemaker.model.ResourceConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.RetryStrategy] inside the given [block]
         */
        public fun retryStrategy(block: aws.sdk.kotlin.services.sagemaker.model.RetryStrategy.Builder.() -> kotlin.Unit) {
            this.retryStrategy = aws.sdk.kotlin.services.sagemaker.model.RetryStrategy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.StoppingCondition] inside the given [block]
         */
        public fun stoppingCondition(block: aws.sdk.kotlin.services.sagemaker.model.StoppingCondition.Builder.() -> kotlin.Unit) {
            this.stoppingCondition = aws.sdk.kotlin.services.sagemaker.model.StoppingCondition.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.TensorBoardOutputConfig] inside the given [block]
         */
        public fun tensorBoardOutputConfig(block: aws.sdk.kotlin.services.sagemaker.model.TensorBoardOutputConfig.Builder.() -> kotlin.Unit) {
            this.tensorBoardOutputConfig = aws.sdk.kotlin.services.sagemaker.model.TensorBoardOutputConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.VpcConfig] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.sagemaker.model.VpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.sagemaker.model.VpcConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.WarmPoolStatus] inside the given [block]
         */
        public fun warmPoolStatus(block: aws.sdk.kotlin.services.sagemaker.model.WarmPoolStatus.Builder.() -> kotlin.Unit) {
            this.warmPoolStatus = aws.sdk.kotlin.services.sagemaker.model.WarmPoolStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
