// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeDomainResponse private constructor(builder: Builder) {
    /**
     * Specifies the VPC used for non-EFS traffic. The default value is `PublicInternetOnly`.
     * + `PublicInternetOnly` - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which allows direct internet access
     * + `VpcOnly` - All traffic is through the specified VPC and subnets
     */
    public val appNetworkAccessType: aws.sdk.kotlin.services.sagemaker.model.AppNetworkAccessType? = builder.appNetworkAccessType
    /**
     * The entity that creates and manages the required security groups for inter-app communication in `VPCOnly` mode. Required when `CreateDomain.AppNetworkAccessType` is `VPCOnly` and `DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn` is provided.
     */
    public val appSecurityGroupManagement: aws.sdk.kotlin.services.sagemaker.model.AppSecurityGroupManagement? = builder.appSecurityGroupManagement
    /**
     * The domain's authentication mode.
     */
    public val authMode: aws.sdk.kotlin.services.sagemaker.model.AuthMode? = builder.authMode
    /**
     * The creation time.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The default settings for shared spaces that users create in the domain.
     */
    public val defaultSpaceSettings: aws.sdk.kotlin.services.sagemaker.model.DefaultSpaceSettings? = builder.defaultSpaceSettings
    /**
     * Settings which are applied to UserProfiles in this domain if settings are not explicitly specified in a given UserProfile.
     */
    public val defaultUserSettings: aws.sdk.kotlin.services.sagemaker.model.UserSettings? = builder.defaultUserSettings
    /**
     * The domain's Amazon Resource Name (ARN).
     */
    public val domainArn: kotlin.String? = builder.domainArn
    /**
     * The domain ID.
     */
    public val domainId: kotlin.String? = builder.domainId
    /**
     * The domain name.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * A collection of `Domain` settings.
     */
    public val domainSettings: aws.sdk.kotlin.services.sagemaker.model.DomainSettings? = builder.domainSettings
    /**
     * The failure reason.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The ID of the Amazon Elastic File System managed by this Domain.
     */
    public val homeEfsFileSystemId: kotlin.String? = builder.homeEfsFileSystemId
    /**
     * Use `KmsKeyId`.
     */
    @Deprecated("This property is deprecated, use KmsKeyId instead.")
    public val homeEfsFileSystemKmsKeyId: kotlin.String? = builder.homeEfsFileSystemKmsKeyId
    /**
     * The Amazon Web Services KMS customer managed key used to encrypt the EFS volume attached to the domain.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The last modified time.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The ID of the security group that authorizes traffic between the `RSessionGateway` apps and the `RStudioServerPro` app.
     */
    public val securityGroupIdForDomainBoundary: kotlin.String? = builder.securityGroupIdForDomainBoundary
    /**
     * The ARN of the application managed by SageMaker in IAM Identity Center. This value is only returned for domains created after October 1, 2023.
     */
    public val singleSignOnApplicationArn: kotlin.String? = builder.singleSignOnApplicationArn
    /**
     * The IAM Identity Center managed application instance ID.
     */
    public val singleSignOnManagedApplicationInstanceId: kotlin.String? = builder.singleSignOnManagedApplicationInstanceId
    /**
     * The status.
     */
    public val status: aws.sdk.kotlin.services.sagemaker.model.DomainStatus? = builder.status
    /**
     * The VPC subnets that the domain uses for communication.
     */
    public val subnetIds: List<String>? = builder.subnetIds
    /**
     * Indicates whether custom tag propagation is supported for the domain.
     */
    public val tagPropagation: aws.sdk.kotlin.services.sagemaker.model.TagPropagation? = builder.tagPropagation
    /**
     * The domain's URL.
     */
    public val url: kotlin.String? = builder.url
    /**
     * The ID of the Amazon Virtual Private Cloud (VPC) that the domain uses for communication.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.DescribeDomainResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeDomainResponse(")
        append("appNetworkAccessType=$appNetworkAccessType,")
        append("appSecurityGroupManagement=$appSecurityGroupManagement,")
        append("authMode=$authMode,")
        append("creationTime=$creationTime,")
        append("defaultSpaceSettings=$defaultSpaceSettings,")
        append("defaultUserSettings=$defaultUserSettings,")
        append("domainArn=$domainArn,")
        append("domainId=$domainId,")
        append("domainName=$domainName,")
        append("domainSettings=$domainSettings,")
        append("failureReason=$failureReason,")
        append("homeEfsFileSystemId=$homeEfsFileSystemId,")
        append("homeEfsFileSystemKmsKeyId=$homeEfsFileSystemKmsKeyId,")
        append("kmsKeyId=$kmsKeyId,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("securityGroupIdForDomainBoundary=$securityGroupIdForDomainBoundary,")
        append("singleSignOnApplicationArn=$singleSignOnApplicationArn,")
        append("singleSignOnManagedApplicationInstanceId=$singleSignOnManagedApplicationInstanceId,")
        append("status=$status,")
        append("subnetIds=$subnetIds,")
        append("tagPropagation=$tagPropagation,")
        append("url=$url,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appNetworkAccessType?.hashCode() ?: 0
        result = 31 * result + (appSecurityGroupManagement?.hashCode() ?: 0)
        result = 31 * result + (authMode?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (defaultSpaceSettings?.hashCode() ?: 0)
        result = 31 * result + (defaultUserSettings?.hashCode() ?: 0)
        result = 31 * result + (domainArn?.hashCode() ?: 0)
        result = 31 * result + (domainId?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (domainSettings?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (homeEfsFileSystemId?.hashCode() ?: 0)
        result = 31 * result + (homeEfsFileSystemKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIdForDomainBoundary?.hashCode() ?: 0)
        result = 31 * result + (singleSignOnApplicationArn?.hashCode() ?: 0)
        result = 31 * result + (singleSignOnManagedApplicationInstanceId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (tagPropagation?.hashCode() ?: 0)
        result = 31 * result + (url?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeDomainResponse

        if (appNetworkAccessType != other.appNetworkAccessType) return false
        if (appSecurityGroupManagement != other.appSecurityGroupManagement) return false
        if (authMode != other.authMode) return false
        if (creationTime != other.creationTime) return false
        if (defaultSpaceSettings != other.defaultSpaceSettings) return false
        if (defaultUserSettings != other.defaultUserSettings) return false
        if (domainArn != other.domainArn) return false
        if (domainId != other.domainId) return false
        if (domainName != other.domainName) return false
        if (domainSettings != other.domainSettings) return false
        if (failureReason != other.failureReason) return false
        if (homeEfsFileSystemId != other.homeEfsFileSystemId) return false
        if (homeEfsFileSystemKmsKeyId != other.homeEfsFileSystemKmsKeyId) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (securityGroupIdForDomainBoundary != other.securityGroupIdForDomainBoundary) return false
        if (singleSignOnApplicationArn != other.singleSignOnApplicationArn) return false
        if (singleSignOnManagedApplicationInstanceId != other.singleSignOnManagedApplicationInstanceId) return false
        if (status != other.status) return false
        if (subnetIds != other.subnetIds) return false
        if (tagPropagation != other.tagPropagation) return false
        if (url != other.url) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.DescribeDomainResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the VPC used for non-EFS traffic. The default value is `PublicInternetOnly`.
         * + `PublicInternetOnly` - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which allows direct internet access
         * + `VpcOnly` - All traffic is through the specified VPC and subnets
         */
        public var appNetworkAccessType: aws.sdk.kotlin.services.sagemaker.model.AppNetworkAccessType? = null
        /**
         * The entity that creates and manages the required security groups for inter-app communication in `VPCOnly` mode. Required when `CreateDomain.AppNetworkAccessType` is `VPCOnly` and `DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn` is provided.
         */
        public var appSecurityGroupManagement: aws.sdk.kotlin.services.sagemaker.model.AppSecurityGroupManagement? = null
        /**
         * The domain's authentication mode.
         */
        public var authMode: aws.sdk.kotlin.services.sagemaker.model.AuthMode? = null
        /**
         * The creation time.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The default settings for shared spaces that users create in the domain.
         */
        public var defaultSpaceSettings: aws.sdk.kotlin.services.sagemaker.model.DefaultSpaceSettings? = null
        /**
         * Settings which are applied to UserProfiles in this domain if settings are not explicitly specified in a given UserProfile.
         */
        public var defaultUserSettings: aws.sdk.kotlin.services.sagemaker.model.UserSettings? = null
        /**
         * The domain's Amazon Resource Name (ARN).
         */
        public var domainArn: kotlin.String? = null
        /**
         * The domain ID.
         */
        public var domainId: kotlin.String? = null
        /**
         * The domain name.
         */
        public var domainName: kotlin.String? = null
        /**
         * A collection of `Domain` settings.
         */
        public var domainSettings: aws.sdk.kotlin.services.sagemaker.model.DomainSettings? = null
        /**
         * The failure reason.
         */
        public var failureReason: kotlin.String? = null
        /**
         * The ID of the Amazon Elastic File System managed by this Domain.
         */
        public var homeEfsFileSystemId: kotlin.String? = null
        /**
         * Use `KmsKeyId`.
         */
        @Deprecated("This property is deprecated, use KmsKeyId instead.")
        public var homeEfsFileSystemKmsKeyId: kotlin.String? = null
        /**
         * The Amazon Web Services KMS customer managed key used to encrypt the EFS volume attached to the domain.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The last modified time.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the security group that authorizes traffic between the `RSessionGateway` apps and the `RStudioServerPro` app.
         */
        public var securityGroupIdForDomainBoundary: kotlin.String? = null
        /**
         * The ARN of the application managed by SageMaker in IAM Identity Center. This value is only returned for domains created after October 1, 2023.
         */
        public var singleSignOnApplicationArn: kotlin.String? = null
        /**
         * The IAM Identity Center managed application instance ID.
         */
        public var singleSignOnManagedApplicationInstanceId: kotlin.String? = null
        /**
         * The status.
         */
        public var status: aws.sdk.kotlin.services.sagemaker.model.DomainStatus? = null
        /**
         * The VPC subnets that the domain uses for communication.
         */
        public var subnetIds: List<String>? = null
        /**
         * Indicates whether custom tag propagation is supported for the domain.
         */
        public var tagPropagation: aws.sdk.kotlin.services.sagemaker.model.TagPropagation? = null
        /**
         * The domain's URL.
         */
        public var url: kotlin.String? = null
        /**
         * The ID of the Amazon Virtual Private Cloud (VPC) that the domain uses for communication.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.DescribeDomainResponse) : this() {
            this.appNetworkAccessType = x.appNetworkAccessType
            this.appSecurityGroupManagement = x.appSecurityGroupManagement
            this.authMode = x.authMode
            this.creationTime = x.creationTime
            this.defaultSpaceSettings = x.defaultSpaceSettings
            this.defaultUserSettings = x.defaultUserSettings
            this.domainArn = x.domainArn
            this.domainId = x.domainId
            this.domainName = x.domainName
            this.domainSettings = x.domainSettings
            this.failureReason = x.failureReason
            this.homeEfsFileSystemId = x.homeEfsFileSystemId
            this.homeEfsFileSystemKmsKeyId = x.homeEfsFileSystemKmsKeyId
            this.kmsKeyId = x.kmsKeyId
            this.lastModifiedTime = x.lastModifiedTime
            this.securityGroupIdForDomainBoundary = x.securityGroupIdForDomainBoundary
            this.singleSignOnApplicationArn = x.singleSignOnApplicationArn
            this.singleSignOnManagedApplicationInstanceId = x.singleSignOnManagedApplicationInstanceId
            this.status = x.status
            this.subnetIds = x.subnetIds
            this.tagPropagation = x.tagPropagation
            this.url = x.url
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.DescribeDomainResponse = DescribeDomainResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.DefaultSpaceSettings] inside the given [block]
         */
        public fun defaultSpaceSettings(block: aws.sdk.kotlin.services.sagemaker.model.DefaultSpaceSettings.Builder.() -> kotlin.Unit) {
            this.defaultSpaceSettings = aws.sdk.kotlin.services.sagemaker.model.DefaultSpaceSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.UserSettings] inside the given [block]
         */
        public fun defaultUserSettings(block: aws.sdk.kotlin.services.sagemaker.model.UserSettings.Builder.() -> kotlin.Unit) {
            this.defaultUserSettings = aws.sdk.kotlin.services.sagemaker.model.UserSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.DomainSettings] inside the given [block]
         */
        public fun domainSettings(block: aws.sdk.kotlin.services.sagemaker.model.DomainSettings.Builder.() -> kotlin.Unit) {
            this.domainSettings = aws.sdk.kotlin.services.sagemaker.model.DomainSettings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
