// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The default settings for shared spaces that users create in the domain.
 *
 * SageMaker applies these settings only to shared spaces. It doesn't apply them to private spaces.
 */
public class DefaultSpaceSettings private constructor(builder: Builder) {
    /**
     * The settings for assigning a custom file system to a domain. Permitted users can access this file system in Amazon SageMaker Studio.
     */
    public val customFileSystemConfigs: List<CustomFileSystemConfig>? = builder.customFileSystemConfigs
    /**
     * Details about the POSIX identity that is used for file system operations.
     */
    public val customPosixUserConfig: aws.sdk.kotlin.services.sagemaker.model.CustomPosixUserConfig? = builder.customPosixUserConfig
    /**
     * The ARN of the execution role for the space.
     */
    public val executionRole: kotlin.String? = builder.executionRole
    /**
     * The settings for the JupyterLab application.
     */
    public val jupyterLabAppSettings: aws.sdk.kotlin.services.sagemaker.model.JupyterLabAppSettings? = builder.jupyterLabAppSettings
    /**
     * The JupyterServer app settings.
     */
    public val jupyterServerAppSettings: aws.sdk.kotlin.services.sagemaker.model.JupyterServerAppSettings? = builder.jupyterServerAppSettings
    /**
     * The KernelGateway app settings.
     */
    public val kernelGatewayAppSettings: aws.sdk.kotlin.services.sagemaker.model.KernelGatewayAppSettings? = builder.kernelGatewayAppSettings
    /**
     * The security group IDs for the Amazon VPC that the space uses for communication.
     */
    public val securityGroups: List<String>? = builder.securityGroups
    /**
     * The default storage settings for a space.
     */
    public val spaceStorageSettings: aws.sdk.kotlin.services.sagemaker.model.DefaultSpaceStorageSettings? = builder.spaceStorageSettings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.DefaultSpaceSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DefaultSpaceSettings(")
        append("customFileSystemConfigs=$customFileSystemConfigs,")
        append("customPosixUserConfig=$customPosixUserConfig,")
        append("executionRole=$executionRole,")
        append("jupyterLabAppSettings=$jupyterLabAppSettings,")
        append("jupyterServerAppSettings=$jupyterServerAppSettings,")
        append("kernelGatewayAppSettings=$kernelGatewayAppSettings,")
        append("securityGroups=$securityGroups,")
        append("spaceStorageSettings=$spaceStorageSettings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = customFileSystemConfigs?.hashCode() ?: 0
        result = 31 * result + (customPosixUserConfig?.hashCode() ?: 0)
        result = 31 * result + (executionRole?.hashCode() ?: 0)
        result = 31 * result + (jupyterLabAppSettings?.hashCode() ?: 0)
        result = 31 * result + (jupyterServerAppSettings?.hashCode() ?: 0)
        result = 31 * result + (kernelGatewayAppSettings?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (spaceStorageSettings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DefaultSpaceSettings

        if (customFileSystemConfigs != other.customFileSystemConfigs) return false
        if (customPosixUserConfig != other.customPosixUserConfig) return false
        if (executionRole != other.executionRole) return false
        if (jupyterLabAppSettings != other.jupyterLabAppSettings) return false
        if (jupyterServerAppSettings != other.jupyterServerAppSettings) return false
        if (kernelGatewayAppSettings != other.kernelGatewayAppSettings) return false
        if (securityGroups != other.securityGroups) return false
        if (spaceStorageSettings != other.spaceStorageSettings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.DefaultSpaceSettings = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The settings for assigning a custom file system to a domain. Permitted users can access this file system in Amazon SageMaker Studio.
         */
        public var customFileSystemConfigs: List<CustomFileSystemConfig>? = null
        /**
         * Details about the POSIX identity that is used for file system operations.
         */
        public var customPosixUserConfig: aws.sdk.kotlin.services.sagemaker.model.CustomPosixUserConfig? = null
        /**
         * The ARN of the execution role for the space.
         */
        public var executionRole: kotlin.String? = null
        /**
         * The settings for the JupyterLab application.
         */
        public var jupyterLabAppSettings: aws.sdk.kotlin.services.sagemaker.model.JupyterLabAppSettings? = null
        /**
         * The JupyterServer app settings.
         */
        public var jupyterServerAppSettings: aws.sdk.kotlin.services.sagemaker.model.JupyterServerAppSettings? = null
        /**
         * The KernelGateway app settings.
         */
        public var kernelGatewayAppSettings: aws.sdk.kotlin.services.sagemaker.model.KernelGatewayAppSettings? = null
        /**
         * The security group IDs for the Amazon VPC that the space uses for communication.
         */
        public var securityGroups: List<String>? = null
        /**
         * The default storage settings for a space.
         */
        public var spaceStorageSettings: aws.sdk.kotlin.services.sagemaker.model.DefaultSpaceStorageSettings? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.DefaultSpaceSettings) : this() {
            this.customFileSystemConfigs = x.customFileSystemConfigs
            this.customPosixUserConfig = x.customPosixUserConfig
            this.executionRole = x.executionRole
            this.jupyterLabAppSettings = x.jupyterLabAppSettings
            this.jupyterServerAppSettings = x.jupyterServerAppSettings
            this.kernelGatewayAppSettings = x.kernelGatewayAppSettings
            this.securityGroups = x.securityGroups
            this.spaceStorageSettings = x.spaceStorageSettings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.DefaultSpaceSettings = DefaultSpaceSettings(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.CustomPosixUserConfig] inside the given [block]
         */
        public fun customPosixUserConfig(block: aws.sdk.kotlin.services.sagemaker.model.CustomPosixUserConfig.Builder.() -> kotlin.Unit) {
            this.customPosixUserConfig = aws.sdk.kotlin.services.sagemaker.model.CustomPosixUserConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.JupyterLabAppSettings] inside the given [block]
         */
        public fun jupyterLabAppSettings(block: aws.sdk.kotlin.services.sagemaker.model.JupyterLabAppSettings.Builder.() -> kotlin.Unit) {
            this.jupyterLabAppSettings = aws.sdk.kotlin.services.sagemaker.model.JupyterLabAppSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.JupyterServerAppSettings] inside the given [block]
         */
        public fun jupyterServerAppSettings(block: aws.sdk.kotlin.services.sagemaker.model.JupyterServerAppSettings.Builder.() -> kotlin.Unit) {
            this.jupyterServerAppSettings = aws.sdk.kotlin.services.sagemaker.model.JupyterServerAppSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.KernelGatewayAppSettings] inside the given [block]
         */
        public fun kernelGatewayAppSettings(block: aws.sdk.kotlin.services.sagemaker.model.KernelGatewayAppSettings.Builder.() -> kotlin.Unit) {
            this.kernelGatewayAppSettings = aws.sdk.kotlin.services.sagemaker.model.KernelGatewayAppSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.DefaultSpaceStorageSettings] inside the given [block]
         */
        public fun spaceStorageSettings(block: aws.sdk.kotlin.services.sagemaker.model.DefaultSpaceStorageSettings.Builder.() -> kotlin.Unit) {
            this.spaceStorageSettings = aws.sdk.kotlin.services.sagemaker.model.DefaultSpaceStorageSettings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
