// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateMlflowTrackingServerRequest private constructor(builder: Builder) {
    /**
     * The S3 URI for a general purpose bucket to use as the MLflow Tracking Server artifact store.
     */
    public val artifactStoreUri: kotlin.String? = builder.artifactStoreUri
    /**
     * Whether to enable or disable automatic registration of new MLflow models to the SageMaker Model Registry. To enable automatic model registration, set this value to `True`. To disable automatic model registration, set this value to `False`. If not specified, `AutomaticModelRegistration` defaults to `False`.
     */
    public val automaticModelRegistration: kotlin.Boolean? = builder.automaticModelRegistration
    /**
     * The version of MLflow that the tracking server uses. To see which MLflow versions are available to use, see [How it works](https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow.html#mlflow-create-tracking-server-how-it-works).
     */
    public val mlflowVersion: kotlin.String? = builder.mlflowVersion
    /**
     * The Amazon Resource Name (ARN) for an IAM role in your account that the MLflow Tracking Server uses to access the artifact store in Amazon S3. The role should have `AmazonS3FullAccess` permissions. For more information on IAM permissions for tracking server creation, see [Set up IAM permissions for MLflow](https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-create-tracking-server-iam.html).
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * Tags consisting of key-value pairs used to manage metadata for the tracking server.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * A unique string identifying the tracking server name. This string is part of the tracking server ARN.
     */
    public val trackingServerName: kotlin.String? = builder.trackingServerName
    /**
     * The size of the tracking server you want to create. You can choose between `"Small"`, `"Medium"`, and `"Large"`. The default MLflow Tracking Server configuration size is `"Small"`. You can choose a size depending on the projected use of the tracking server such as the volume of data logged, number of users, and frequency of use.
     *
     * We recommend using a small tracking server for teams of up to 25 users, a medium tracking server for teams of up to 50 users, and a large tracking server for teams of up to 100 users.
     */
    public val trackingServerSize: aws.sdk.kotlin.services.sagemaker.model.TrackingServerSize? = builder.trackingServerSize
    /**
     * The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time that weekly maintenance updates are scheduled. For example: TUE:03:30.
     */
    public val weeklyMaintenanceWindowStart: kotlin.String? = builder.weeklyMaintenanceWindowStart

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.CreateMlflowTrackingServerRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateMlflowTrackingServerRequest(")
        append("artifactStoreUri=$artifactStoreUri,")
        append("automaticModelRegistration=$automaticModelRegistration,")
        append("mlflowVersion=$mlflowVersion,")
        append("roleArn=$roleArn,")
        append("tags=$tags,")
        append("trackingServerName=$trackingServerName,")
        append("trackingServerSize=$trackingServerSize,")
        append("weeklyMaintenanceWindowStart=$weeklyMaintenanceWindowStart")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = artifactStoreUri?.hashCode() ?: 0
        result = 31 * result + (automaticModelRegistration?.hashCode() ?: 0)
        result = 31 * result + (mlflowVersion?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (trackingServerName?.hashCode() ?: 0)
        result = 31 * result + (trackingServerSize?.hashCode() ?: 0)
        result = 31 * result + (weeklyMaintenanceWindowStart?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateMlflowTrackingServerRequest

        if (artifactStoreUri != other.artifactStoreUri) return false
        if (automaticModelRegistration != other.automaticModelRegistration) return false
        if (mlflowVersion != other.mlflowVersion) return false
        if (roleArn != other.roleArn) return false
        if (tags != other.tags) return false
        if (trackingServerName != other.trackingServerName) return false
        if (trackingServerSize != other.trackingServerSize) return false
        if (weeklyMaintenanceWindowStart != other.weeklyMaintenanceWindowStart) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.CreateMlflowTrackingServerRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The S3 URI for a general purpose bucket to use as the MLflow Tracking Server artifact store.
         */
        public var artifactStoreUri: kotlin.String? = null
        /**
         * Whether to enable or disable automatic registration of new MLflow models to the SageMaker Model Registry. To enable automatic model registration, set this value to `True`. To disable automatic model registration, set this value to `False`. If not specified, `AutomaticModelRegistration` defaults to `False`.
         */
        public var automaticModelRegistration: kotlin.Boolean? = null
        /**
         * The version of MLflow that the tracking server uses. To see which MLflow versions are available to use, see [How it works](https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow.html#mlflow-create-tracking-server-how-it-works).
         */
        public var mlflowVersion: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for an IAM role in your account that the MLflow Tracking Server uses to access the artifact store in Amazon S3. The role should have `AmazonS3FullAccess` permissions. For more information on IAM permissions for tracking server creation, see [Set up IAM permissions for MLflow](https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-create-tracking-server-iam.html).
         */
        public var roleArn: kotlin.String? = null
        /**
         * Tags consisting of key-value pairs used to manage metadata for the tracking server.
         */
        public var tags: List<Tag>? = null
        /**
         * A unique string identifying the tracking server name. This string is part of the tracking server ARN.
         */
        public var trackingServerName: kotlin.String? = null
        /**
         * The size of the tracking server you want to create. You can choose between `"Small"`, `"Medium"`, and `"Large"`. The default MLflow Tracking Server configuration size is `"Small"`. You can choose a size depending on the projected use of the tracking server such as the volume of data logged, number of users, and frequency of use.
         *
         * We recommend using a small tracking server for teams of up to 25 users, a medium tracking server for teams of up to 50 users, and a large tracking server for teams of up to 100 users.
         */
        public var trackingServerSize: aws.sdk.kotlin.services.sagemaker.model.TrackingServerSize? = null
        /**
         * The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time that weekly maintenance updates are scheduled. For example: TUE:03:30.
         */
        public var weeklyMaintenanceWindowStart: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.CreateMlflowTrackingServerRequest) : this() {
            this.artifactStoreUri = x.artifactStoreUri
            this.automaticModelRegistration = x.automaticModelRegistration
            this.mlflowVersion = x.mlflowVersion
            this.roleArn = x.roleArn
            this.tags = x.tags
            this.trackingServerName = x.trackingServerName
            this.trackingServerSize = x.trackingServerSize
            this.weeklyMaintenanceWindowStart = x.weeklyMaintenanceWindowStart
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.CreateMlflowTrackingServerRequest = CreateMlflowTrackingServerRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
