// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.DescribeOptimizationJobResponse
import aws.sdk.kotlin.services.sagemaker.model.OptimizationConfig
import aws.sdk.kotlin.services.sagemaker.model.OptimizationJobDeploymentInstanceType
import aws.sdk.kotlin.services.sagemaker.model.OptimizationJobModelSource
import aws.sdk.kotlin.services.sagemaker.model.OptimizationJobOutputConfig
import aws.sdk.kotlin.services.sagemaker.model.OptimizationJobStatus
import aws.sdk.kotlin.services.sagemaker.model.OptimizationOutput
import aws.sdk.kotlin.services.sagemaker.model.OptimizationVpcConfig
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.sdk.kotlin.services.sagemaker.model.StoppingCondition
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class DescribeOptimizationJobOperationDeserializer: HttpDeserializer.NonStreaming<DescribeOptimizationJobResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeOptimizationJobResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeOptimizationJobError(context, call, payload)
        }
        val builder = DescribeOptimizationJobResponse.Builder()

        if (payload != null) {
            deserializeDescribeOptimizationJobOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeOptimizationJobError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedCall, payload)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeOptimizationJobOperationBody(builder: DescribeOptimizationJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DEPLOYMENTINSTANCETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("DeploymentInstanceType"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FailureReason"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val MODELSOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ModelSource"))
    val OPTIMIZATIONCONFIGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("OptimizationConfigs"))
    val OPTIMIZATIONENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("OptimizationEndTime"))
    val OPTIMIZATIONENVIRONMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("OptimizationEnvironment"))
    val OPTIMIZATIONJOBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OptimizationJobArn"))
    val OPTIMIZATIONJOBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OptimizationJobName"))
    val OPTIMIZATIONJOBSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("OptimizationJobStatus"))
    val OPTIMIZATIONOUTPUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OptimizationOutput"))
    val OPTIMIZATIONSTARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("OptimizationStartTime"))
    val OUTPUTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OutputConfig"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoleArn"))
    val STOPPINGCONDITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("StoppingCondition"))
    val VPCCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("VpcConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(DEPLOYMENTINSTANCETYPE_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(MODELSOURCE_DESCRIPTOR)
        field(OPTIMIZATIONCONFIGS_DESCRIPTOR)
        field(OPTIMIZATIONENDTIME_DESCRIPTOR)
        field(OPTIMIZATIONENVIRONMENT_DESCRIPTOR)
        field(OPTIMIZATIONJOBARN_DESCRIPTOR)
        field(OPTIMIZATIONJOBNAME_DESCRIPTOR)
        field(OPTIMIZATIONJOBSTATUS_DESCRIPTOR)
        field(OPTIMIZATIONOUTPUT_DESCRIPTOR)
        field(OPTIMIZATIONSTARTTIME_DESCRIPTOR)
        field(OUTPUTCONFIG_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(STOPPINGCONDITION_DESCRIPTOR)
        field(VPCCONFIG_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DEPLOYMENTINSTANCETYPE_DESCRIPTOR.index -> builder.deploymentInstanceType = deserializeString().let { OptimizationJobDeploymentInstanceType.fromValue(it) }
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                MODELSOURCE_DESCRIPTOR.index -> builder.modelSource = deserializeOptimizationJobModelSourceDocument(deserializer)
                OPTIMIZATIONCONFIGS_DESCRIPTOR.index -> builder.optimizationConfigs =
                    deserializer.deserializeList(OPTIMIZATIONCONFIGS_DESCRIPTOR) {
                        val col0 = mutableListOf<OptimizationConfig>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeOptimizationConfigDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                OPTIMIZATIONENDTIME_DESCRIPTOR.index -> builder.optimizationEndTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                OPTIMIZATIONENVIRONMENT_DESCRIPTOR.index -> builder.optimizationEnvironment =
                    deserializer.deserializeMap(OPTIMIZATIONENVIRONMENT_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                OPTIMIZATIONJOBARN_DESCRIPTOR.index -> builder.optimizationJobArn = deserializeString()
                OPTIMIZATIONJOBNAME_DESCRIPTOR.index -> builder.optimizationJobName = deserializeString()
                OPTIMIZATIONJOBSTATUS_DESCRIPTOR.index -> builder.optimizationJobStatus = deserializeString().let { OptimizationJobStatus.fromValue(it) }
                OPTIMIZATIONOUTPUT_DESCRIPTOR.index -> builder.optimizationOutput = deserializeOptimizationOutputDocument(deserializer)
                OPTIMIZATIONSTARTTIME_DESCRIPTOR.index -> builder.optimizationStartTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                OUTPUTCONFIG_DESCRIPTOR.index -> builder.outputConfig = deserializeOptimizationJobOutputConfigDocument(deserializer)
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                STOPPINGCONDITION_DESCRIPTOR.index -> builder.stoppingCondition = deserializeStoppingConditionDocument(deserializer)
                VPCCONFIG_DESCRIPTOR.index -> builder.vpcConfig = deserializeOptimizationVpcConfigDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
