// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides summary information about a training job.
 */
public class TrainingJobSummary private constructor(builder: Builder) {
    /**
     * A timestamp that shows when the training job was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * Timestamp when the training job was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The secondary status of the training job.
     */
    public val secondaryStatus: aws.sdk.kotlin.services.sagemaker.model.SecondaryStatus? = builder.secondaryStatus
    /**
     * A timestamp that shows when the training job ended. This field is set only if the training job has one of the terminal statuses (`Completed`, `Failed`, or `Stopped`).
     */
    public val trainingEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.trainingEndTime
    /**
     * The Amazon Resource Name (ARN) of the training job.
     */
    public val trainingJobArn: kotlin.String? = builder.trainingJobArn
    /**
     * The name of the training job that you want a summary for.
     */
    public val trainingJobName: kotlin.String? = builder.trainingJobName
    /**
     * The status of the training job.
     */
    public val trainingJobStatus: aws.sdk.kotlin.services.sagemaker.model.TrainingJobStatus? = builder.trainingJobStatus
    /**
     * The status of the warm pool associated with the training job.
     */
    public val warmPoolStatus: aws.sdk.kotlin.services.sagemaker.model.WarmPoolStatus? = builder.warmPoolStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.TrainingJobSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TrainingJobSummary(")
        append("creationTime=$creationTime,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("secondaryStatus=$secondaryStatus,")
        append("trainingEndTime=$trainingEndTime,")
        append("trainingJobArn=$trainingJobArn,")
        append("trainingJobName=$trainingJobName,")
        append("trainingJobStatus=$trainingJobStatus,")
        append("warmPoolStatus=$warmPoolStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (secondaryStatus?.hashCode() ?: 0)
        result = 31 * result + (trainingEndTime?.hashCode() ?: 0)
        result = 31 * result + (trainingJobArn?.hashCode() ?: 0)
        result = 31 * result + (trainingJobName?.hashCode() ?: 0)
        result = 31 * result + (trainingJobStatus?.hashCode() ?: 0)
        result = 31 * result + (warmPoolStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TrainingJobSummary

        if (creationTime != other.creationTime) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (secondaryStatus != other.secondaryStatus) return false
        if (trainingEndTime != other.trainingEndTime) return false
        if (trainingJobArn != other.trainingJobArn) return false
        if (trainingJobName != other.trainingJobName) return false
        if (trainingJobStatus != other.trainingJobStatus) return false
        if (warmPoolStatus != other.warmPoolStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.TrainingJobSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A timestamp that shows when the training job was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Timestamp when the training job was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The secondary status of the training job.
         */
        public var secondaryStatus: aws.sdk.kotlin.services.sagemaker.model.SecondaryStatus? = null
        /**
         * A timestamp that shows when the training job ended. This field is set only if the training job has one of the terminal statuses (`Completed`, `Failed`, or `Stopped`).
         */
        public var trainingEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the training job.
         */
        public var trainingJobArn: kotlin.String? = null
        /**
         * The name of the training job that you want a summary for.
         */
        public var trainingJobName: kotlin.String? = null
        /**
         * The status of the training job.
         */
        public var trainingJobStatus: aws.sdk.kotlin.services.sagemaker.model.TrainingJobStatus? = null
        /**
         * The status of the warm pool associated with the training job.
         */
        public var warmPoolStatus: aws.sdk.kotlin.services.sagemaker.model.WarmPoolStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.TrainingJobSummary) : this() {
            this.creationTime = x.creationTime
            this.lastModifiedTime = x.lastModifiedTime
            this.secondaryStatus = x.secondaryStatus
            this.trainingEndTime = x.trainingEndTime
            this.trainingJobArn = x.trainingJobArn
            this.trainingJobName = x.trainingJobName
            this.trainingJobStatus = x.trainingJobStatus
            this.warmPoolStatus = x.warmPoolStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.TrainingJobSummary = TrainingJobSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.WarmPoolStatus] inside the given [block]
         */
        public fun warmPoolStatus(block: aws.sdk.kotlin.services.sagemaker.model.WarmPoolStatus.Builder.() -> kotlin.Unit) {
            this.warmPoolStatus = aws.sdk.kotlin.services.sagemaker.model.WarmPoolStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
