// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A resource catalog containing all of the resources of a specific resource type within a resource owner account. For an example on sharing the Amazon SageMaker Feature Store `DefaultFeatureGroupCatalog`, see [Share Amazon SageMaker Catalog resource type](https://docs.aws.amazon.com/sagemaker/latest/APIReference/feature-store-cross-account-discoverability-share-sagemaker-catalog.html) in the Amazon SageMaker Developer Guide.
 */
public class ResourceCatalog private constructor(builder: Builder) {
    /**
     * The time the `ResourceCatalog` was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * A free form description of the `ResourceCatalog`.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The Amazon Resource Name (ARN) of the `ResourceCatalog`.
     */
    public val resourceCatalogArn: kotlin.String? = builder.resourceCatalogArn
    /**
     * The name of the `ResourceCatalog`.
     */
    public val resourceCatalogName: kotlin.String? = builder.resourceCatalogName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ResourceCatalog = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceCatalog(")
        append("creationTime=$creationTime,")
        append("description=$description,")
        append("resourceCatalogArn=$resourceCatalogArn,")
        append("resourceCatalogName=$resourceCatalogName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (resourceCatalogArn?.hashCode() ?: 0)
        result = 31 * result + (resourceCatalogName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceCatalog

        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (resourceCatalogArn != other.resourceCatalogArn) return false
        if (resourceCatalogName != other.resourceCatalogName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ResourceCatalog = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The time the `ResourceCatalog` was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A free form description of the `ResourceCatalog`.
         */
        public var description: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the `ResourceCatalog`.
         */
        public var resourceCatalogArn: kotlin.String? = null
        /**
         * The name of the `ResourceCatalog`.
         */
        public var resourceCatalogName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ResourceCatalog) : this() {
            this.creationTime = x.creationTime
            this.description = x.description
            this.resourceCatalogArn = x.resourceCatalogArn
            this.resourceCatalogName = x.resourceCatalogName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ResourceCatalog = ResourceCatalog(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
