// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateOptimizationJobRequest private constructor(builder: Builder) {
    /**
     * The type of instance that hosts the optimized model that you create with the optimization job.
     */
    public val deploymentInstanceType: aws.sdk.kotlin.services.sagemaker.model.OptimizationJobDeploymentInstanceType? = builder.deploymentInstanceType
    /**
     * The location of the source model to optimize with an optimization job.
     */
    public val modelSource: aws.sdk.kotlin.services.sagemaker.model.OptimizationJobModelSource? = builder.modelSource
    /**
     * Settings for each of the optimization techniques that the job applies.
     */
    public val optimizationConfigs: List<OptimizationConfig>? = builder.optimizationConfigs
    /**
     * The environment variables to set in the model container.
     */
    public val optimizationEnvironment: Map<String, String>? = builder.optimizationEnvironment
    /**
     * A custom name for the new optimization job.
     */
    public val optimizationJobName: kotlin.String? = builder.optimizationJobName
    /**
     * Details for where to store the optimized model that you create with the optimization job.
     */
    public val outputConfig: aws.sdk.kotlin.services.sagemaker.model.OptimizationJobOutputConfig? = builder.outputConfig
    /**
     * The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf.
     *
     * During model optimization, Amazon SageMaker needs your permission to:
     * + Read input data from an S3 bucket
     * + Write model artifacts to an S3 bucket
     * + Write logs to Amazon CloudWatch Logs
     * + Publish metrics to Amazon CloudWatch
     *
     * You grant permissions for all of these tasks to an IAM role. To pass this role to Amazon SageMaker, the caller of this API must have the `iam:PassRole` permission. For more information, see [Amazon SageMaker Roles.](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html)
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * Specifies a limit to how long a job can run. When the job reaches the time limit, SageMaker ends the job. Use this API to cap costs.
     *
     * To stop a training job, SageMaker sends the algorithm the `SIGTERM` signal, which delays job termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the results of training are not lost.
     *
     * The training algorithms provided by SageMaker automatically save the intermediate results of a model training job when possible. This attempt to save artifacts is only a best effort case as model might not be in a state from which it can be saved. For example, if training has just started, the model might not be ready to save. When saved, this intermediate data is a valid model artifact. You can use it to create a model with `CreateModel`.
     *
     * The Neural Topic Model (NTM) currently does not support saving intermediate model artifacts. When training NTMs, make sure that the maximum runtime is sufficient for the training job to complete.
     */
    public val stoppingCondition: aws.sdk.kotlin.services.sagemaker.model.StoppingCondition? = builder.stoppingCondition
    /**
     * A list of key-value pairs associated with the optimization job. For more information, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference Guide*.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * A VPC in Amazon VPC that your optimized model has access to.
     */
    public val vpcConfig: aws.sdk.kotlin.services.sagemaker.model.OptimizationVpcConfig? = builder.vpcConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.CreateOptimizationJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateOptimizationJobRequest(")
        append("deploymentInstanceType=$deploymentInstanceType,")
        append("modelSource=$modelSource,")
        append("optimizationConfigs=$optimizationConfigs,")
        append("optimizationEnvironment=$optimizationEnvironment,")
        append("optimizationJobName=$optimizationJobName,")
        append("outputConfig=$outputConfig,")
        append("roleArn=$roleArn,")
        append("stoppingCondition=$stoppingCondition,")
        append("tags=$tags,")
        append("vpcConfig=$vpcConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deploymentInstanceType?.hashCode() ?: 0
        result = 31 * result + (modelSource?.hashCode() ?: 0)
        result = 31 * result + (optimizationConfigs?.hashCode() ?: 0)
        result = 31 * result + (optimizationEnvironment?.hashCode() ?: 0)
        result = 31 * result + (optimizationJobName?.hashCode() ?: 0)
        result = 31 * result + (outputConfig?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (stoppingCondition?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateOptimizationJobRequest

        if (deploymentInstanceType != other.deploymentInstanceType) return false
        if (modelSource != other.modelSource) return false
        if (optimizationConfigs != other.optimizationConfigs) return false
        if (optimizationEnvironment != other.optimizationEnvironment) return false
        if (optimizationJobName != other.optimizationJobName) return false
        if (outputConfig != other.outputConfig) return false
        if (roleArn != other.roleArn) return false
        if (stoppingCondition != other.stoppingCondition) return false
        if (tags != other.tags) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.CreateOptimizationJobRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The type of instance that hosts the optimized model that you create with the optimization job.
         */
        public var deploymentInstanceType: aws.sdk.kotlin.services.sagemaker.model.OptimizationJobDeploymentInstanceType? = null
        /**
         * The location of the source model to optimize with an optimization job.
         */
        public var modelSource: aws.sdk.kotlin.services.sagemaker.model.OptimizationJobModelSource? = null
        /**
         * Settings for each of the optimization techniques that the job applies.
         */
        public var optimizationConfigs: List<OptimizationConfig>? = null
        /**
         * The environment variables to set in the model container.
         */
        public var optimizationEnvironment: Map<String, String>? = null
        /**
         * A custom name for the new optimization job.
         */
        public var optimizationJobName: kotlin.String? = null
        /**
         * Details for where to store the optimized model that you create with the optimization job.
         */
        public var outputConfig: aws.sdk.kotlin.services.sagemaker.model.OptimizationJobOutputConfig? = null
        /**
         * The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf.
         *
         * During model optimization, Amazon SageMaker needs your permission to:
         * + Read input data from an S3 bucket
         * + Write model artifacts to an S3 bucket
         * + Write logs to Amazon CloudWatch Logs
         * + Publish metrics to Amazon CloudWatch
         *
         * You grant permissions for all of these tasks to an IAM role. To pass this role to Amazon SageMaker, the caller of this API must have the `iam:PassRole` permission. For more information, see [Amazon SageMaker Roles.](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html)
         */
        public var roleArn: kotlin.String? = null
        /**
         * Specifies a limit to how long a job can run. When the job reaches the time limit, SageMaker ends the job. Use this API to cap costs.
         *
         * To stop a training job, SageMaker sends the algorithm the `SIGTERM` signal, which delays job termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the results of training are not lost.
         *
         * The training algorithms provided by SageMaker automatically save the intermediate results of a model training job when possible. This attempt to save artifacts is only a best effort case as model might not be in a state from which it can be saved. For example, if training has just started, the model might not be ready to save. When saved, this intermediate data is a valid model artifact. You can use it to create a model with `CreateModel`.
         *
         * The Neural Topic Model (NTM) currently does not support saving intermediate model artifacts. When training NTMs, make sure that the maximum runtime is sufficient for the training job to complete.
         */
        public var stoppingCondition: aws.sdk.kotlin.services.sagemaker.model.StoppingCondition? = null
        /**
         * A list of key-value pairs associated with the optimization job. For more information, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference Guide*.
         */
        public var tags: List<Tag>? = null
        /**
         * A VPC in Amazon VPC that your optimized model has access to.
         */
        public var vpcConfig: aws.sdk.kotlin.services.sagemaker.model.OptimizationVpcConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.CreateOptimizationJobRequest) : this() {
            this.deploymentInstanceType = x.deploymentInstanceType
            this.modelSource = x.modelSource
            this.optimizationConfigs = x.optimizationConfigs
            this.optimizationEnvironment = x.optimizationEnvironment
            this.optimizationJobName = x.optimizationJobName
            this.outputConfig = x.outputConfig
            this.roleArn = x.roleArn
            this.stoppingCondition = x.stoppingCondition
            this.tags = x.tags
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.CreateOptimizationJobRequest = CreateOptimizationJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.OptimizationJobModelSource] inside the given [block]
         */
        public fun modelSource(block: aws.sdk.kotlin.services.sagemaker.model.OptimizationJobModelSource.Builder.() -> kotlin.Unit) {
            this.modelSource = aws.sdk.kotlin.services.sagemaker.model.OptimizationJobModelSource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.OptimizationJobOutputConfig] inside the given [block]
         */
        public fun outputConfig(block: aws.sdk.kotlin.services.sagemaker.model.OptimizationJobOutputConfig.Builder.() -> kotlin.Unit) {
            this.outputConfig = aws.sdk.kotlin.services.sagemaker.model.OptimizationJobOutputConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.StoppingCondition] inside the given [block]
         */
        public fun stoppingCondition(block: aws.sdk.kotlin.services.sagemaker.model.StoppingCondition.Builder.() -> kotlin.Unit) {
            this.stoppingCondition = aws.sdk.kotlin.services.sagemaker.model.StoppingCondition.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.OptimizationVpcConfig] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.sagemaker.model.OptimizationVpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.sagemaker.model.OptimizationVpcConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
