// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.DescribeStudioLifecycleConfigResponse
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.sdk.kotlin.services.sagemaker.model.StudioLifecycleConfigAppType
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeStudioLifecycleConfigOperationDeserializer: HttpDeserializer.NonStreaming<DescribeStudioLifecycleConfigResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeStudioLifecycleConfigResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeStudioLifecycleConfigError(context, call, payload)
        }
        val builder = DescribeStudioLifecycleConfigResponse.Builder()

        if (payload != null) {
            deserializeDescribeStudioLifecycleConfigOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeStudioLifecycleConfigError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedCall, payload)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeStudioLifecycleConfigOperationBody(builder: DescribeStudioLifecycleConfigResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val STUDIOLIFECYCLECONFIGAPPTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("StudioLifecycleConfigAppType"))
    val STUDIOLIFECYCLECONFIGARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StudioLifecycleConfigArn"))
    val STUDIOLIFECYCLECONFIGCONTENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StudioLifecycleConfigContent"))
    val STUDIOLIFECYCLECONFIGNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StudioLifecycleConfigName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(STUDIOLIFECYCLECONFIGAPPTYPE_DESCRIPTOR)
        field(STUDIOLIFECYCLECONFIGARN_DESCRIPTOR)
        field(STUDIOLIFECYCLECONFIGCONTENT_DESCRIPTOR)
        field(STUDIOLIFECYCLECONFIGNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                STUDIOLIFECYCLECONFIGAPPTYPE_DESCRIPTOR.index -> builder.studioLifecycleConfigAppType = deserializeString().let { StudioLifecycleConfigAppType.fromValue(it) }
                STUDIOLIFECYCLECONFIGARN_DESCRIPTOR.index -> builder.studioLifecycleConfigArn = deserializeString()
                STUDIOLIFECYCLECONFIGCONTENT_DESCRIPTOR.index -> builder.studioLifecycleConfigContent = deserializeString()
                STUDIOLIFECYCLECONFIGNAME_DESCRIPTOR.index -> builder.studioLifecycleConfigName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
