// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Active throughput configuration of the feature group. There are two modes: `ON_DEMAND` and `PROVISIONED`. With on-demand mode, you are charged for data reads and writes that your application performs on your feature group. You do not need to specify read and write throughput because Feature Store accommodates your workloads as they ramp up and down. You can switch a feature group to on-demand only once in a 24 hour period. With provisioned throughput mode, you specify the read and write capacity per second that you expect your application to require, and you are billed based on those limits. Exceeding provisioned throughput will result in your requests being throttled.
 *
 * Note: `PROVISIONED` throughput mode is supported only for feature groups that are offline-only, or use the `Standard`[](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OnlineStoreConfig.html#sagemaker-Type-OnlineStoreConfig-StorageType) tier online store.
 */
public class ThroughputConfigDescription private constructor(builder: Builder) {
    /**
     * For provisioned feature groups with online store enabled, this indicates the read throughput you are billed for and can consume without throttling.
     *
     * This field is not applicable for on-demand feature groups.
     */
    public val provisionedReadCapacityUnits: kotlin.Int? = builder.provisionedReadCapacityUnits
    /**
     * For provisioned feature groups, this indicates the write throughput you are billed for and can consume without throttling.
     *
     * This field is not applicable for on-demand feature groups.
     */
    public val provisionedWriteCapacityUnits: kotlin.Int? = builder.provisionedWriteCapacityUnits
    /**
     * The mode used for your feature group throughput: `ON_DEMAND` or `PROVISIONED`.
     */
    public val throughputMode: aws.sdk.kotlin.services.sagemaker.model.ThroughputMode? = builder.throughputMode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ThroughputConfigDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ThroughputConfigDescription(")
        append("provisionedReadCapacityUnits=$provisionedReadCapacityUnits,")
        append("provisionedWriteCapacityUnits=$provisionedWriteCapacityUnits,")
        append("throughputMode=$throughputMode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = provisionedReadCapacityUnits ?: 0
        result = 31 * result + (provisionedWriteCapacityUnits ?: 0)
        result = 31 * result + (throughputMode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ThroughputConfigDescription

        if (provisionedReadCapacityUnits != other.provisionedReadCapacityUnits) return false
        if (provisionedWriteCapacityUnits != other.provisionedWriteCapacityUnits) return false
        if (throughputMode != other.throughputMode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ThroughputConfigDescription = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * For provisioned feature groups with online store enabled, this indicates the read throughput you are billed for and can consume without throttling.
         *
         * This field is not applicable for on-demand feature groups.
         */
        public var provisionedReadCapacityUnits: kotlin.Int? = null
        /**
         * For provisioned feature groups, this indicates the write throughput you are billed for and can consume without throttling.
         *
         * This field is not applicable for on-demand feature groups.
         */
        public var provisionedWriteCapacityUnits: kotlin.Int? = null
        /**
         * The mode used for your feature group throughput: `ON_DEMAND` or `PROVISIONED`.
         */
        public var throughputMode: aws.sdk.kotlin.services.sagemaker.model.ThroughputMode? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ThroughputConfigDescription) : this() {
            this.provisionedReadCapacityUnits = x.provisionedReadCapacityUnits
            this.provisionedWriteCapacityUnits = x.provisionedWriteCapacityUnits
            this.throughputMode = x.throughputMode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ThroughputConfigDescription = ThroughputConfigDescription(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
