// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * An Amazon SageMaker Model Card.
 */
public class ModelCard private constructor(builder: Builder) {
    /**
     * The content of the model card. Content uses the [model card JSON schema](https://docs.aws.amazon.com/sagemaker/latest/dg/model-cards.html#model-cards-json-schema) and provided as a string.
     */
    public val content: kotlin.String? = builder.content
    /**
     * Information about the user who created or modified an experiment, trial, trial component, lineage group, project, or model card.
     */
    public val createdBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = builder.createdBy
    /**
     * The date and time that the model card was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * Information about the user who created or modified an experiment, trial, trial component, lineage group, project, or model card.
     */
    public val lastModifiedBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = builder.lastModifiedBy
    /**
     * The date and time that the model card was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The Amazon Resource Name (ARN) of the model card.
     */
    public val modelCardArn: kotlin.String? = builder.modelCardArn
    /**
     * The unique name of the model card.
     */
    public val modelCardName: kotlin.String? = builder.modelCardName
    /**
     * The approval status of the model card within your organization. Different organizations might have different criteria for model card review and approval.
     * + `Draft`: The model card is a work in progress.
     * + `PendingReview`: The model card is pending review.
     * + `Approved`: The model card is approved.
     * + `Archived`: The model card is archived. No more updates should be made to the model card, but it can still be exported.
     */
    public val modelCardStatus: aws.sdk.kotlin.services.sagemaker.model.ModelCardStatus? = builder.modelCardStatus
    /**
     * The version of the model card.
     */
    public val modelCardVersion: kotlin.Int? = builder.modelCardVersion
    /**
     * The unique name (ID) of the model.
     */
    public val modelId: kotlin.String? = builder.modelId
    /**
     * The model package group that contains the model package. Only relevant for model cards created for model packages in the Amazon SageMaker Model Registry.
     */
    public val modelPackageGroupName: kotlin.String? = builder.modelPackageGroupName
    /**
     * The risk rating of the model. Different organizations might have different criteria for model card risk ratings. For more information, see [Risk ratings](https://docs.aws.amazon.com/sagemaker/latest/dg/model-cards-risk-rating.html).
     */
    public val riskRating: kotlin.String? = builder.riskRating
    /**
     * The security configuration used to protect model card data.
     */
    public val securityConfig: aws.sdk.kotlin.services.sagemaker.model.ModelCardSecurityConfig? = builder.securityConfig
    /**
     * Key-value pairs used to manage metadata for the model card.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ModelCard = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModelCard(")
        append("content=*** Sensitive Data Redacted ***,")
        append("createdBy=$createdBy,")
        append("creationTime=$creationTime,")
        append("lastModifiedBy=$lastModifiedBy,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("modelCardArn=$modelCardArn,")
        append("modelCardName=$modelCardName,")
        append("modelCardStatus=$modelCardStatus,")
        append("modelCardVersion=$modelCardVersion,")
        append("modelId=$modelId,")
        append("modelPackageGroupName=$modelPackageGroupName,")
        append("riskRating=$riskRating,")
        append("securityConfig=$securityConfig,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = content?.hashCode() ?: 0
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedBy?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (modelCardArn?.hashCode() ?: 0)
        result = 31 * result + (modelCardName?.hashCode() ?: 0)
        result = 31 * result + (modelCardStatus?.hashCode() ?: 0)
        result = 31 * result + (modelCardVersion ?: 0)
        result = 31 * result + (modelId?.hashCode() ?: 0)
        result = 31 * result + (modelPackageGroupName?.hashCode() ?: 0)
        result = 31 * result + (riskRating?.hashCode() ?: 0)
        result = 31 * result + (securityConfig?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModelCard

        if (content != other.content) return false
        if (createdBy != other.createdBy) return false
        if (creationTime != other.creationTime) return false
        if (lastModifiedBy != other.lastModifiedBy) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (modelCardArn != other.modelCardArn) return false
        if (modelCardName != other.modelCardName) return false
        if (modelCardStatus != other.modelCardStatus) return false
        if (modelCardVersion != other.modelCardVersion) return false
        if (modelId != other.modelId) return false
        if (modelPackageGroupName != other.modelPackageGroupName) return false
        if (riskRating != other.riskRating) return false
        if (securityConfig != other.securityConfig) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ModelCard = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The content of the model card. Content uses the [model card JSON schema](https://docs.aws.amazon.com/sagemaker/latest/dg/model-cards.html#model-cards-json-schema) and provided as a string.
         */
        public var content: kotlin.String? = null
        /**
         * Information about the user who created or modified an experiment, trial, trial component, lineage group, project, or model card.
         */
        public var createdBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = null
        /**
         * The date and time that the model card was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Information about the user who created or modified an experiment, trial, trial component, lineage group, project, or model card.
         */
        public var lastModifiedBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = null
        /**
         * The date and time that the model card was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the model card.
         */
        public var modelCardArn: kotlin.String? = null
        /**
         * The unique name of the model card.
         */
        public var modelCardName: kotlin.String? = null
        /**
         * The approval status of the model card within your organization. Different organizations might have different criteria for model card review and approval.
         * + `Draft`: The model card is a work in progress.
         * + `PendingReview`: The model card is pending review.
         * + `Approved`: The model card is approved.
         * + `Archived`: The model card is archived. No more updates should be made to the model card, but it can still be exported.
         */
        public var modelCardStatus: aws.sdk.kotlin.services.sagemaker.model.ModelCardStatus? = null
        /**
         * The version of the model card.
         */
        public var modelCardVersion: kotlin.Int? = null
        /**
         * The unique name (ID) of the model.
         */
        public var modelId: kotlin.String? = null
        /**
         * The model package group that contains the model package. Only relevant for model cards created for model packages in the Amazon SageMaker Model Registry.
         */
        public var modelPackageGroupName: kotlin.String? = null
        /**
         * The risk rating of the model. Different organizations might have different criteria for model card risk ratings. For more information, see [Risk ratings](https://docs.aws.amazon.com/sagemaker/latest/dg/model-cards-risk-rating.html).
         */
        public var riskRating: kotlin.String? = null
        /**
         * The security configuration used to protect model card data.
         */
        public var securityConfig: aws.sdk.kotlin.services.sagemaker.model.ModelCardSecurityConfig? = null
        /**
         * Key-value pairs used to manage metadata for the model card.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ModelCard) : this() {
            this.content = x.content
            this.createdBy = x.createdBy
            this.creationTime = x.creationTime
            this.lastModifiedBy = x.lastModifiedBy
            this.lastModifiedTime = x.lastModifiedTime
            this.modelCardArn = x.modelCardArn
            this.modelCardName = x.modelCardName
            this.modelCardStatus = x.modelCardStatus
            this.modelCardVersion = x.modelCardVersion
            this.modelId = x.modelId
            this.modelPackageGroupName = x.modelPackageGroupName
            this.riskRating = x.riskRating
            this.securityConfig = x.securityConfig
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ModelCard = ModelCard(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.UserContext] inside the given [block]
         */
        public fun createdBy(block: aws.sdk.kotlin.services.sagemaker.model.UserContext.Builder.() -> kotlin.Unit) {
            this.createdBy = aws.sdk.kotlin.services.sagemaker.model.UserContext.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.UserContext] inside the given [block]
         */
        public fun lastModifiedBy(block: aws.sdk.kotlin.services.sagemaker.model.UserContext.Builder.() -> kotlin.Unit) {
            this.lastModifiedBy = aws.sdk.kotlin.services.sagemaker.model.UserContext.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ModelCardSecurityConfig] inside the given [block]
         */
        public fun securityConfig(block: aws.sdk.kotlin.services.sagemaker.model.ModelCardSecurityConfig.Builder.() -> kotlin.Unit) {
            this.securityConfig = aws.sdk.kotlin.services.sagemaker.model.ModelCardSecurityConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
