// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Docker container image configuration object for the model bias job.
 */
public class ModelBiasAppSpecification private constructor(builder: Builder) {
    /**
     * JSON formatted S3 file that defines bias parameters. For more information on this JSON configuration file, see [Configure bias parameters](https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-config-json-monitor-bias-parameters.html).
     */
    public val configUri: kotlin.String? = builder.configUri
    /**
     * Sets the environment variables in the Docker container.
     */
    public val environment: Map<String, String>? = builder.environment
    /**
     * The container image to be run by the model bias job.
     */
    public val imageUri: kotlin.String? = builder.imageUri

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ModelBiasAppSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModelBiasAppSpecification(")
        append("configUri=$configUri,")
        append("environment=$environment,")
        append("imageUri=$imageUri")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configUri?.hashCode() ?: 0
        result = 31 * result + (environment?.hashCode() ?: 0)
        result = 31 * result + (imageUri?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModelBiasAppSpecification

        if (configUri != other.configUri) return false
        if (environment != other.environment) return false
        if (imageUri != other.imageUri) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ModelBiasAppSpecification = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * JSON formatted S3 file that defines bias parameters. For more information on this JSON configuration file, see [Configure bias parameters](https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-config-json-monitor-bias-parameters.html).
         */
        public var configUri: kotlin.String? = null
        /**
         * Sets the environment variables in the Docker container.
         */
        public var environment: Map<String, String>? = null
        /**
         * The container image to be run by the model bias job.
         */
        public var imageUri: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ModelBiasAppSpecification) : this() {
            this.configUri = x.configUri
            this.environment = x.environment
            this.imageUri = x.imageUri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ModelBiasAppSpecification = ModelBiasAppSpecification(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
