// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Lists a summary of properties of an inference experiment.
 */
public class InferenceExperimentSummary private constructor(builder: Builder) {
    /**
     * The timestamp at which the inference experiment was completed.
     */
    public val completionTime: aws.smithy.kotlin.runtime.time.Instant? = builder.completionTime
    /**
     * The timestamp at which the inference experiment was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The description of the inference experiment.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The timestamp when you last modified the inference experiment.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The name of the inference experiment.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The ARN of the IAM role that Amazon SageMaker can assume to access model artifacts and container images, and manage Amazon SageMaker Inference endpoints for model deployment.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The duration for which the inference experiment ran or will run.
     *
     * The maximum duration that you can set for an inference experiment is 30 days.
     */
    public val schedule: aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentSchedule? = builder.schedule
    /**
     * The status of the inference experiment.
     */
    public val status: aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentStatus? = builder.status
    /**
     * The error message for the inference experiment status result.
     */
    public val statusReason: kotlin.String? = builder.statusReason
    /**
     * The type of the inference experiment.
     */
    public val type: aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InferenceExperimentSummary(")
        append("completionTime=$completionTime,")
        append("creationTime=$creationTime,")
        append("description=$description,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("schedule=$schedule,")
        append("status=$status,")
        append("statusReason=$statusReason,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = completionTime?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (schedule?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InferenceExperimentSummary

        if (completionTime != other.completionTime) return false
        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (schedule != other.schedule) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The timestamp at which the inference experiment was completed.
         */
        public var completionTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The timestamp at which the inference experiment was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the inference experiment.
         */
        public var description: kotlin.String? = null
        /**
         * The timestamp when you last modified the inference experiment.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the inference experiment.
         */
        public var name: kotlin.String? = null
        /**
         * The ARN of the IAM role that Amazon SageMaker can assume to access model artifacts and container images, and manage Amazon SageMaker Inference endpoints for model deployment.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The duration for which the inference experiment ran or will run.
         *
         * The maximum duration that you can set for an inference experiment is 30 days.
         */
        public var schedule: aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentSchedule? = null
        /**
         * The status of the inference experiment.
         */
        public var status: aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentStatus? = null
        /**
         * The error message for the inference experiment status result.
         */
        public var statusReason: kotlin.String? = null
        /**
         * The type of the inference experiment.
         */
        public var type: aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentSummary) : this() {
            this.completionTime = x.completionTime
            this.creationTime = x.creationTime
            this.description = x.description
            this.lastModifiedTime = x.lastModifiedTime
            this.name = x.name
            this.roleArn = x.roleArn
            this.schedule = x.schedule
            this.status = x.status
            this.statusReason = x.statusReason
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentSummary = InferenceExperimentSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentSchedule] inside the given [block]
         */
        public fun schedule(block: aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentSchedule.Builder.() -> kotlin.Unit) {
            this.schedule = aws.sdk.kotlin.services.sagemaker.model.InferenceExperimentSchedule.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
