// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Defines a container that provides the runtime environment for a model that you deploy with an inference component.
 */
public class InferenceComponentContainerSpecification private constructor(builder: Builder) {
    /**
     * The Amazon S3 path where the model artifacts, which result from model training, are stored. This path must point to a single gzip compressed tar archive (.tar.gz suffix).
     */
    public val artifactUrl: kotlin.String? = builder.artifactUrl
    /**
     * The environment variables to set in the Docker container. Each key and value in the Environment string-to-string map can have length of up to 1024. We support up to 16 entries in the map.
     */
    public val environment: Map<String, String>? = builder.environment
    /**
     * The Amazon Elastic Container Registry (Amazon ECR) path where the Docker image for the model is stored.
     */
    public val image: kotlin.String? = builder.image

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.InferenceComponentContainerSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InferenceComponentContainerSpecification(")
        append("artifactUrl=$artifactUrl,")
        append("environment=$environment,")
        append("image=$image")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = artifactUrl?.hashCode() ?: 0
        result = 31 * result + (environment?.hashCode() ?: 0)
        result = 31 * result + (image?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InferenceComponentContainerSpecification

        if (artifactUrl != other.artifactUrl) return false
        if (environment != other.environment) return false
        if (image != other.image) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.InferenceComponentContainerSpecification = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon S3 path where the model artifacts, which result from model training, are stored. This path must point to a single gzip compressed tar archive (.tar.gz suffix).
         */
        public var artifactUrl: kotlin.String? = null
        /**
         * The environment variables to set in the Docker container. Each key and value in the Environment string-to-string map can have length of up to 1024. We support up to 16 entries in the map.
         */
        public var environment: Map<String, String>? = null
        /**
         * The Amazon Elastic Container Registry (Amazon ECR) path where the Docker image for the model is stored.
         */
        public var image: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.InferenceComponentContainerSpecification) : this() {
            this.artifactUrl = x.artifactUrl
            this.environment = x.environment
            this.image = x.image
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.InferenceComponentContainerSpecification = InferenceComponentContainerSpecification(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
