// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Configures a hyperparameter tuning job.
 */
public class HyperParameterTuningJobConfig private constructor(builder: Builder) {
    /**
     * The [HyperParameterTuningJobObjective](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobObjective.html) specifies the objective metric used to evaluate the performance of training jobs launched by this tuning job.
     */
    public val hyperParameterTuningJobObjective: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobObjective? = builder.hyperParameterTuningJobObjective
    /**
     * The [ParameterRanges](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ParameterRanges.html) object that specifies the ranges of hyperparameters that this tuning job searches over to find the optimal configuration for the highest model performance against your chosen objective metric.
     */
    public val parameterRanges: aws.sdk.kotlin.services.sagemaker.model.ParameterRanges? = builder.parameterRanges
    /**
     * A value used to initialize a pseudo-random number generator. Setting a random seed and using the same seed later for the same tuning job will allow hyperparameter optimization to find more a consistent hyperparameter configuration between the two runs.
     */
    public val randomSeed: kotlin.Int? = builder.randomSeed
    /**
     * The [ResourceLimits](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ResourceLimits.html) object that specifies the maximum number of training and parallel training jobs that can be used for this hyperparameter tuning job.
     */
    public val resourceLimits: aws.sdk.kotlin.services.sagemaker.model.ResourceLimits? = builder.resourceLimits
    /**
     * Specifies how hyperparameter tuning chooses the combinations of hyperparameter values to use for the training job it launches. For information about search strategies, see [How Hyperparameter Tuning Works](https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html).
     */
    public val strategy: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobStrategyType? = builder.strategy
    /**
     * The configuration for the `Hyperband` optimization strategy. This parameter should be provided only if `Hyperband` is selected as the strategy for `HyperParameterTuningJobConfig`.
     */
    public val strategyConfig: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobStrategyConfig? = builder.strategyConfig
    /**
     * Specifies whether to use early stopping for training jobs launched by the hyperparameter tuning job. Because the `Hyperband` strategy has its own advanced internal early stopping mechanism, `TrainingJobEarlyStoppingType` must be `OFF` to use `Hyperband`. This parameter can take on one of the following values (the default value is `OFF`):
     *
     * ## OFF
     * Training jobs launched by the hyperparameter tuning job do not use early stopping.
     *
     * ## AUTO
     * SageMaker stops training jobs launched by the hyperparameter tuning job when they are unlikely to perform better than previously completed training jobs. For more information, see [Stop Training Jobs Early](https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-early-stopping.html).
     */
    public val trainingJobEarlyStoppingType: aws.sdk.kotlin.services.sagemaker.model.TrainingJobEarlyStoppingType? = builder.trainingJobEarlyStoppingType
    /**
     * The tuning job's completion criteria.
     */
    public val tuningJobCompletionCriteria: aws.sdk.kotlin.services.sagemaker.model.TuningJobCompletionCriteria? = builder.tuningJobCompletionCriteria

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HyperParameterTuningJobConfig(")
        append("hyperParameterTuningJobObjective=$hyperParameterTuningJobObjective,")
        append("parameterRanges=$parameterRanges,")
        append("randomSeed=$randomSeed,")
        append("resourceLimits=$resourceLimits,")
        append("strategy=$strategy,")
        append("strategyConfig=$strategyConfig,")
        append("trainingJobEarlyStoppingType=$trainingJobEarlyStoppingType,")
        append("tuningJobCompletionCriteria=$tuningJobCompletionCriteria")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = hyperParameterTuningJobObjective?.hashCode() ?: 0
        result = 31 * result + (parameterRanges?.hashCode() ?: 0)
        result = 31 * result + (randomSeed ?: 0)
        result = 31 * result + (resourceLimits?.hashCode() ?: 0)
        result = 31 * result + (strategy?.hashCode() ?: 0)
        result = 31 * result + (strategyConfig?.hashCode() ?: 0)
        result = 31 * result + (trainingJobEarlyStoppingType?.hashCode() ?: 0)
        result = 31 * result + (tuningJobCompletionCriteria?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HyperParameterTuningJobConfig

        if (hyperParameterTuningJobObjective != other.hyperParameterTuningJobObjective) return false
        if (parameterRanges != other.parameterRanges) return false
        if (randomSeed != other.randomSeed) return false
        if (resourceLimits != other.resourceLimits) return false
        if (strategy != other.strategy) return false
        if (strategyConfig != other.strategyConfig) return false
        if (trainingJobEarlyStoppingType != other.trainingJobEarlyStoppingType) return false
        if (tuningJobCompletionCriteria != other.tuningJobCompletionCriteria) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The [HyperParameterTuningJobObjective](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobObjective.html) specifies the objective metric used to evaluate the performance of training jobs launched by this tuning job.
         */
        public var hyperParameterTuningJobObjective: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobObjective? = null
        /**
         * The [ParameterRanges](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ParameterRanges.html) object that specifies the ranges of hyperparameters that this tuning job searches over to find the optimal configuration for the highest model performance against your chosen objective metric.
         */
        public var parameterRanges: aws.sdk.kotlin.services.sagemaker.model.ParameterRanges? = null
        /**
         * A value used to initialize a pseudo-random number generator. Setting a random seed and using the same seed later for the same tuning job will allow hyperparameter optimization to find more a consistent hyperparameter configuration between the two runs.
         */
        public var randomSeed: kotlin.Int? = null
        /**
         * The [ResourceLimits](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ResourceLimits.html) object that specifies the maximum number of training and parallel training jobs that can be used for this hyperparameter tuning job.
         */
        public var resourceLimits: aws.sdk.kotlin.services.sagemaker.model.ResourceLimits? = null
        /**
         * Specifies how hyperparameter tuning chooses the combinations of hyperparameter values to use for the training job it launches. For information about search strategies, see [How Hyperparameter Tuning Works](https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html).
         */
        public var strategy: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobStrategyType? = null
        /**
         * The configuration for the `Hyperband` optimization strategy. This parameter should be provided only if `Hyperband` is selected as the strategy for `HyperParameterTuningJobConfig`.
         */
        public var strategyConfig: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobStrategyConfig? = null
        /**
         * Specifies whether to use early stopping for training jobs launched by the hyperparameter tuning job. Because the `Hyperband` strategy has its own advanced internal early stopping mechanism, `TrainingJobEarlyStoppingType` must be `OFF` to use `Hyperband`. This parameter can take on one of the following values (the default value is `OFF`):
         *
         * ## OFF
         * Training jobs launched by the hyperparameter tuning job do not use early stopping.
         *
         * ## AUTO
         * SageMaker stops training jobs launched by the hyperparameter tuning job when they are unlikely to perform better than previously completed training jobs. For more information, see [Stop Training Jobs Early](https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-early-stopping.html).
         */
        public var trainingJobEarlyStoppingType: aws.sdk.kotlin.services.sagemaker.model.TrainingJobEarlyStoppingType? = null
        /**
         * The tuning job's completion criteria.
         */
        public var tuningJobCompletionCriteria: aws.sdk.kotlin.services.sagemaker.model.TuningJobCompletionCriteria? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConfig) : this() {
            this.hyperParameterTuningJobObjective = x.hyperParameterTuningJobObjective
            this.parameterRanges = x.parameterRanges
            this.randomSeed = x.randomSeed
            this.resourceLimits = x.resourceLimits
            this.strategy = x.strategy
            this.strategyConfig = x.strategyConfig
            this.trainingJobEarlyStoppingType = x.trainingJobEarlyStoppingType
            this.tuningJobCompletionCriteria = x.tuningJobCompletionCriteria
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConfig = HyperParameterTuningJobConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobObjective] inside the given [block]
         */
        public fun hyperParameterTuningJobObjective(block: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobObjective.Builder.() -> kotlin.Unit) {
            this.hyperParameterTuningJobObjective = aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobObjective.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ParameterRanges] inside the given [block]
         */
        public fun parameterRanges(block: aws.sdk.kotlin.services.sagemaker.model.ParameterRanges.Builder.() -> kotlin.Unit) {
            this.parameterRanges = aws.sdk.kotlin.services.sagemaker.model.ParameterRanges.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ResourceLimits] inside the given [block]
         */
        public fun resourceLimits(block: aws.sdk.kotlin.services.sagemaker.model.ResourceLimits.Builder.() -> kotlin.Unit) {
            this.resourceLimits = aws.sdk.kotlin.services.sagemaker.model.ResourceLimits.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobStrategyConfig] inside the given [block]
         */
        public fun strategyConfig(block: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobStrategyConfig.Builder.() -> kotlin.Unit) {
            this.strategyConfig = aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobStrategyConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.TuningJobCompletionCriteria] inside the given [block]
         */
        public fun tuningJobCompletionCriteria(block: aws.sdk.kotlin.services.sagemaker.model.TuningJobCompletionCriteria.Builder.() -> kotlin.Unit) {
            this.tuningJobCompletionCriteria = aws.sdk.kotlin.services.sagemaker.model.TuningJobCompletionCriteria.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
