// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The generative AI settings for the SageMaker Canvas application.
 *
 * Configure these settings for Canvas users starting chats with generative AI foundation models. For more information, see [ Use generative AI with foundation models](https://docs.aws.amazon.com/sagemaker/latest/dg/canvas-fm-chat.html).
 */
public class GenerativeAiSettings private constructor(builder: Builder) {
    /**
     * The ARN of an Amazon Web Services IAM role that allows fine-tuning of large language models (LLMs) in Amazon Bedrock. The IAM role should have Amazon S3 read and write permissions, as well as a trust relationship that establishes `bedrock.amazonaws.com` as a service principal.
     */
    public val amazonBedrockRoleArn: kotlin.String? = builder.amazonBedrockRoleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.GenerativeAiSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GenerativeAiSettings(")
        append("amazonBedrockRoleArn=$amazonBedrockRoleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = amazonBedrockRoleArn?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GenerativeAiSettings

        if (amazonBedrockRoleArn != other.amazonBedrockRoleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.GenerativeAiSettings = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of an Amazon Web Services IAM role that allows fine-tuning of large language models (LLMs) in Amazon Bedrock. The IAM role should have Amazon S3 read and write permissions, as well as a trust relationship that establishes `bedrock.amazonaws.com` as a service principal.
         */
        public var amazonBedrockRoleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.GenerativeAiSettings) : this() {
            this.amazonBedrockRoleArn = x.amazonBedrockRoleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.GenerativeAiSettings = GenerativeAiSettings(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
