// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains summary information about the flow definition.
 */
public class FlowDefinitionSummary private constructor(builder: Builder) {
    /**
     * The timestamp when SageMaker created the flow definition.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The reason why the flow definition creation failed. A failure reason is returned only when the flow definition status is `Failed`.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The Amazon Resource Name (ARN) of the flow definition.
     */
    public val flowDefinitionArn: kotlin.String? = builder.flowDefinitionArn
    /**
     * The name of the flow definition.
     */
    public val flowDefinitionName: kotlin.String? = builder.flowDefinitionName
    /**
     * The status of the flow definition. Valid values:
     */
    public val flowDefinitionStatus: aws.sdk.kotlin.services.sagemaker.model.FlowDefinitionStatus? = builder.flowDefinitionStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.FlowDefinitionSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FlowDefinitionSummary(")
        append("creationTime=$creationTime,")
        append("failureReason=$failureReason,")
        append("flowDefinitionArn=$flowDefinitionArn,")
        append("flowDefinitionName=$flowDefinitionName,")
        append("flowDefinitionStatus=$flowDefinitionStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (flowDefinitionArn?.hashCode() ?: 0)
        result = 31 * result + (flowDefinitionName?.hashCode() ?: 0)
        result = 31 * result + (flowDefinitionStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FlowDefinitionSummary

        if (creationTime != other.creationTime) return false
        if (failureReason != other.failureReason) return false
        if (flowDefinitionArn != other.flowDefinitionArn) return false
        if (flowDefinitionName != other.flowDefinitionName) return false
        if (flowDefinitionStatus != other.flowDefinitionStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.FlowDefinitionSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The timestamp when SageMaker created the flow definition.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The reason why the flow definition creation failed. A failure reason is returned only when the flow definition status is `Failed`.
         */
        public var failureReason: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the flow definition.
         */
        public var flowDefinitionArn: kotlin.String? = null
        /**
         * The name of the flow definition.
         */
        public var flowDefinitionName: kotlin.String? = null
        /**
         * The status of the flow definition. Valid values:
         */
        public var flowDefinitionStatus: aws.sdk.kotlin.services.sagemaker.model.FlowDefinitionStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.FlowDefinitionSummary) : this() {
            this.creationTime = x.creationTime
            this.failureReason = x.failureReason
            this.flowDefinitionArn = x.flowDefinitionArn
            this.flowDefinitionName = x.flowDefinitionName
            this.flowDefinitionStatus = x.flowDefinitionStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.FlowDefinitionSummary = FlowDefinitionSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
