// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Shows the latest objective metric emitted by a training job that was launched by a hyperparameter tuning job. You define the objective metric in the `HyperParameterTuningJobObjective` parameter of [HyperParameterTuningJobConfig](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobConfig.html).
 */
public class FinalHyperParameterTuningJobObjectiveMetric private constructor(builder: Builder) {
    /**
     * The name of the objective metric. For SageMaker built-in algorithms, metrics are defined per algorithm. See the [metrics for XGBoost](https://docs.aws.amazon.com/sagemaker/latest/dg/xgboost-tuning.html) as an example. You can also use a custom algorithm for training and define your own metrics. For more information, see [Define metrics and environment variables](https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-metrics-variables.html).
     */
    public val metricName: kotlin.String? = builder.metricName
    /**
     * Select if you want to minimize or maximize the objective metric during hyperparameter tuning.
     */
    public val type: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobObjectiveType? = builder.type
    /**
     * The value of the objective metric.
     */
    public val value: kotlin.Float? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.FinalHyperParameterTuningJobObjectiveMetric = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FinalHyperParameterTuningJobObjectiveMetric(")
        append("metricName=$metricName,")
        append("type=$type,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = metricName?.hashCode() ?: 0
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FinalHyperParameterTuningJobObjectiveMetric

        if (metricName != other.metricName) return false
        if (type != other.type) return false
        if (!(value?.equals(other.value) ?: (other.value == null))) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.FinalHyperParameterTuningJobObjectiveMetric = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the objective metric. For SageMaker built-in algorithms, metrics are defined per algorithm. See the [metrics for XGBoost](https://docs.aws.amazon.com/sagemaker/latest/dg/xgboost-tuning.html) as an example. You can also use a custom algorithm for training and define your own metrics. For more information, see [Define metrics and environment variables](https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-metrics-variables.html).
         */
        public var metricName: kotlin.String? = null
        /**
         * Select if you want to minimize or maximize the objective metric during hyperparameter tuning.
         */
        public var type: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobObjectiveType? = null
        /**
         * The value of the objective metric.
         */
        public var value: kotlin.Float? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.FinalHyperParameterTuningJobObjectiveMetric) : this() {
            this.metricName = x.metricName
            this.type = x.type
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.FinalHyperParameterTuningJobObjectiveMetric = FinalHyperParameterTuningJobObjectiveMetric(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
