// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration parameters that specify the IAM roles assumed by the execution role of SageMaker (assumable roles) and the cluster instances or job execution environments (execution roles or runtime roles) to manage and access resources required for running Amazon EMR clusters or Amazon EMR Serverless applications.
 */
public class EmrSettings private constructor(builder: Builder) {
    /**
     * An array of Amazon Resource Names (ARNs) of the IAM roles that the execution role of SageMaker can assume for performing operations or tasks related to Amazon EMR clusters or Amazon EMR Serverless applications. These roles define the permissions and access policies required when performing Amazon EMR-related operations, such as listing, connecting to, or terminating Amazon EMR clusters or Amazon EMR Serverless applications. They are typically used in cross-account access scenarios, where the Amazon EMR resources (clusters or serverless applications) are located in a different Amazon Web Services account than the SageMaker domain.
     */
    public val assumableRoleArns: List<String>? = builder.assumableRoleArns
    /**
     * An array of Amazon Resource Names (ARNs) of the IAM roles used by the Amazon EMR cluster instances or job execution environments to access other Amazon Web Services services and resources needed during the runtime of your Amazon EMR or Amazon EMR Serverless workloads, such as Amazon S3 for data access, Amazon CloudWatch for logging, or other Amazon Web Services services based on the particular workload requirements.
     */
    public val executionRoleArns: List<String>? = builder.executionRoleArns

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.EmrSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EmrSettings(")
        append("assumableRoleArns=$assumableRoleArns,")
        append("executionRoleArns=$executionRoleArns")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assumableRoleArns?.hashCode() ?: 0
        result = 31 * result + (executionRoleArns?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EmrSettings

        if (assumableRoleArns != other.assumableRoleArns) return false
        if (executionRoleArns != other.executionRoleArns) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.EmrSettings = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An array of Amazon Resource Names (ARNs) of the IAM roles that the execution role of SageMaker can assume for performing operations or tasks related to Amazon EMR clusters or Amazon EMR Serverless applications. These roles define the permissions and access policies required when performing Amazon EMR-related operations, such as listing, connecting to, or terminating Amazon EMR clusters or Amazon EMR Serverless applications. They are typically used in cross-account access scenarios, where the Amazon EMR resources (clusters or serverless applications) are located in a different Amazon Web Services account than the SageMaker domain.
         */
        public var assumableRoleArns: List<String>? = null
        /**
         * An array of Amazon Resource Names (ARNs) of the IAM roles used by the Amazon EMR cluster instances or job execution environments to access other Amazon Web Services services and resources needed during the runtime of your Amazon EMR or Amazon EMR Serverless workloads, such as Amazon S3 for data access, Amazon CloudWatch for logging, or other Amazon Web Services services based on the particular workload requirements.
         */
        public var executionRoleArns: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.EmrSettings) : this() {
            this.assumableRoleArns = x.assumableRoleArns
            this.executionRoleArns = x.executionRoleArns
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.EmrSettings = EmrSettings(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
