// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeOptimizationJobResponse private constructor(builder: Builder) {
    /**
     * The time when you created the optimization job.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The type of instance that hosts the optimized model that you create with the optimization job.
     */
    public val deploymentInstanceType: aws.sdk.kotlin.services.sagemaker.model.OptimizationJobDeploymentInstanceType? = builder.deploymentInstanceType
    /**
     * If the optimization job status is `FAILED`, the reason for the failure.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The time when the optimization job was last updated.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The location of the source model to optimize with an optimization job.
     */
    public val modelSource: aws.sdk.kotlin.services.sagemaker.model.OptimizationJobModelSource? = builder.modelSource
    /**
     * Settings for each of the optimization techniques that the job applies.
     */
    public val optimizationConfigs: List<OptimizationConfig>? = builder.optimizationConfigs
    /**
     * The time when the optimization job finished processing.
     */
    public val optimizationEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.optimizationEndTime
    /**
     * The environment variables to set in the model container.
     */
    public val optimizationEnvironment: Map<String, String>? = builder.optimizationEnvironment
    /**
     * The Amazon Resource Name (ARN) of the optimization job.
     */
    public val optimizationJobArn: kotlin.String? = builder.optimizationJobArn
    /**
     * The name that you assigned to the optimization job.
     */
    public val optimizationJobName: kotlin.String? = builder.optimizationJobName
    /**
     * The current status of the optimization job.
     */
    public val optimizationJobStatus: aws.sdk.kotlin.services.sagemaker.model.OptimizationJobStatus? = builder.optimizationJobStatus
    /**
     * Output values produced by an optimization job.
     */
    public val optimizationOutput: aws.sdk.kotlin.services.sagemaker.model.OptimizationOutput? = builder.optimizationOutput
    /**
     * The time when the optimization job started.
     */
    public val optimizationStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.optimizationStartTime
    /**
     * Details for where to store the optimized model that you create with the optimization job.
     */
    public val outputConfig: aws.sdk.kotlin.services.sagemaker.model.OptimizationJobOutputConfig? = builder.outputConfig
    /**
     * The ARN of the IAM role that you assigned to the optimization job.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * Specifies a limit to how long a job can run. When the job reaches the time limit, SageMaker ends the job. Use this API to cap costs.
     *
     * To stop a training job, SageMaker sends the algorithm the `SIGTERM` signal, which delays job termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the results of training are not lost.
     *
     * The training algorithms provided by SageMaker automatically save the intermediate results of a model training job when possible. This attempt to save artifacts is only a best effort case as model might not be in a state from which it can be saved. For example, if training has just started, the model might not be ready to save. When saved, this intermediate data is a valid model artifact. You can use it to create a model with `CreateModel`.
     *
     * The Neural Topic Model (NTM) currently does not support saving intermediate model artifacts. When training NTMs, make sure that the maximum runtime is sufficient for the training job to complete.
     */
    public val stoppingCondition: aws.sdk.kotlin.services.sagemaker.model.StoppingCondition? = builder.stoppingCondition
    /**
     * A VPC in Amazon VPC that your optimized model has access to.
     */
    public val vpcConfig: aws.sdk.kotlin.services.sagemaker.model.OptimizationVpcConfig? = builder.vpcConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.DescribeOptimizationJobResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeOptimizationJobResponse(")
        append("creationTime=$creationTime,")
        append("deploymentInstanceType=$deploymentInstanceType,")
        append("failureReason=$failureReason,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("modelSource=$modelSource,")
        append("optimizationConfigs=$optimizationConfigs,")
        append("optimizationEndTime=$optimizationEndTime,")
        append("optimizationEnvironment=$optimizationEnvironment,")
        append("optimizationJobArn=$optimizationJobArn,")
        append("optimizationJobName=$optimizationJobName,")
        append("optimizationJobStatus=$optimizationJobStatus,")
        append("optimizationOutput=$optimizationOutput,")
        append("optimizationStartTime=$optimizationStartTime,")
        append("outputConfig=$outputConfig,")
        append("roleArn=$roleArn,")
        append("stoppingCondition=$stoppingCondition,")
        append("vpcConfig=$vpcConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (deploymentInstanceType?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (modelSource?.hashCode() ?: 0)
        result = 31 * result + (optimizationConfigs?.hashCode() ?: 0)
        result = 31 * result + (optimizationEndTime?.hashCode() ?: 0)
        result = 31 * result + (optimizationEnvironment?.hashCode() ?: 0)
        result = 31 * result + (optimizationJobArn?.hashCode() ?: 0)
        result = 31 * result + (optimizationJobName?.hashCode() ?: 0)
        result = 31 * result + (optimizationJobStatus?.hashCode() ?: 0)
        result = 31 * result + (optimizationOutput?.hashCode() ?: 0)
        result = 31 * result + (optimizationStartTime?.hashCode() ?: 0)
        result = 31 * result + (outputConfig?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (stoppingCondition?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeOptimizationJobResponse

        if (creationTime != other.creationTime) return false
        if (deploymentInstanceType != other.deploymentInstanceType) return false
        if (failureReason != other.failureReason) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (modelSource != other.modelSource) return false
        if (optimizationConfigs != other.optimizationConfigs) return false
        if (optimizationEndTime != other.optimizationEndTime) return false
        if (optimizationEnvironment != other.optimizationEnvironment) return false
        if (optimizationJobArn != other.optimizationJobArn) return false
        if (optimizationJobName != other.optimizationJobName) return false
        if (optimizationJobStatus != other.optimizationJobStatus) return false
        if (optimizationOutput != other.optimizationOutput) return false
        if (optimizationStartTime != other.optimizationStartTime) return false
        if (outputConfig != other.outputConfig) return false
        if (roleArn != other.roleArn) return false
        if (stoppingCondition != other.stoppingCondition) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.DescribeOptimizationJobResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The time when you created the optimization job.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The type of instance that hosts the optimized model that you create with the optimization job.
         */
        public var deploymentInstanceType: aws.sdk.kotlin.services.sagemaker.model.OptimizationJobDeploymentInstanceType? = null
        /**
         * If the optimization job status is `FAILED`, the reason for the failure.
         */
        public var failureReason: kotlin.String? = null
        /**
         * The time when the optimization job was last updated.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The location of the source model to optimize with an optimization job.
         */
        public var modelSource: aws.sdk.kotlin.services.sagemaker.model.OptimizationJobModelSource? = null
        /**
         * Settings for each of the optimization techniques that the job applies.
         */
        public var optimizationConfigs: List<OptimizationConfig>? = null
        /**
         * The time when the optimization job finished processing.
         */
        public var optimizationEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The environment variables to set in the model container.
         */
        public var optimizationEnvironment: Map<String, String>? = null
        /**
         * The Amazon Resource Name (ARN) of the optimization job.
         */
        public var optimizationJobArn: kotlin.String? = null
        /**
         * The name that you assigned to the optimization job.
         */
        public var optimizationJobName: kotlin.String? = null
        /**
         * The current status of the optimization job.
         */
        public var optimizationJobStatus: aws.sdk.kotlin.services.sagemaker.model.OptimizationJobStatus? = null
        /**
         * Output values produced by an optimization job.
         */
        public var optimizationOutput: aws.sdk.kotlin.services.sagemaker.model.OptimizationOutput? = null
        /**
         * The time when the optimization job started.
         */
        public var optimizationStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Details for where to store the optimized model that you create with the optimization job.
         */
        public var outputConfig: aws.sdk.kotlin.services.sagemaker.model.OptimizationJobOutputConfig? = null
        /**
         * The ARN of the IAM role that you assigned to the optimization job.
         */
        public var roleArn: kotlin.String? = null
        /**
         * Specifies a limit to how long a job can run. When the job reaches the time limit, SageMaker ends the job. Use this API to cap costs.
         *
         * To stop a training job, SageMaker sends the algorithm the `SIGTERM` signal, which delays job termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the results of training are not lost.
         *
         * The training algorithms provided by SageMaker automatically save the intermediate results of a model training job when possible. This attempt to save artifacts is only a best effort case as model might not be in a state from which it can be saved. For example, if training has just started, the model might not be ready to save. When saved, this intermediate data is a valid model artifact. You can use it to create a model with `CreateModel`.
         *
         * The Neural Topic Model (NTM) currently does not support saving intermediate model artifacts. When training NTMs, make sure that the maximum runtime is sufficient for the training job to complete.
         */
        public var stoppingCondition: aws.sdk.kotlin.services.sagemaker.model.StoppingCondition? = null
        /**
         * A VPC in Amazon VPC that your optimized model has access to.
         */
        public var vpcConfig: aws.sdk.kotlin.services.sagemaker.model.OptimizationVpcConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.DescribeOptimizationJobResponse) : this() {
            this.creationTime = x.creationTime
            this.deploymentInstanceType = x.deploymentInstanceType
            this.failureReason = x.failureReason
            this.lastModifiedTime = x.lastModifiedTime
            this.modelSource = x.modelSource
            this.optimizationConfigs = x.optimizationConfigs
            this.optimizationEndTime = x.optimizationEndTime
            this.optimizationEnvironment = x.optimizationEnvironment
            this.optimizationJobArn = x.optimizationJobArn
            this.optimizationJobName = x.optimizationJobName
            this.optimizationJobStatus = x.optimizationJobStatus
            this.optimizationOutput = x.optimizationOutput
            this.optimizationStartTime = x.optimizationStartTime
            this.outputConfig = x.outputConfig
            this.roleArn = x.roleArn
            this.stoppingCondition = x.stoppingCondition
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.DescribeOptimizationJobResponse = DescribeOptimizationJobResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.OptimizationJobModelSource] inside the given [block]
         */
        public fun modelSource(block: aws.sdk.kotlin.services.sagemaker.model.OptimizationJobModelSource.Builder.() -> kotlin.Unit) {
            this.modelSource = aws.sdk.kotlin.services.sagemaker.model.OptimizationJobModelSource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.OptimizationOutput] inside the given [block]
         */
        public fun optimizationOutput(block: aws.sdk.kotlin.services.sagemaker.model.OptimizationOutput.Builder.() -> kotlin.Unit) {
            this.optimizationOutput = aws.sdk.kotlin.services.sagemaker.model.OptimizationOutput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.OptimizationJobOutputConfig] inside the given [block]
         */
        public fun outputConfig(block: aws.sdk.kotlin.services.sagemaker.model.OptimizationJobOutputConfig.Builder.() -> kotlin.Unit) {
            this.outputConfig = aws.sdk.kotlin.services.sagemaker.model.OptimizationJobOutputConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.StoppingCondition] inside the given [block]
         */
        public fun stoppingCondition(block: aws.sdk.kotlin.services.sagemaker.model.StoppingCondition.Builder.() -> kotlin.Unit) {
            this.stoppingCondition = aws.sdk.kotlin.services.sagemaker.model.StoppingCondition.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.OptimizationVpcConfig] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.sagemaker.model.OptimizationVpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.sagemaker.model.OptimizationVpcConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
