// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The lifecycle configuration for a SageMaker HyperPod cluster.
 */
public class ClusterLifeCycleConfig private constructor(builder: Builder) {
    /**
     * The file name of the entrypoint script of lifecycle scripts under `SourceS3Uri`. This entrypoint script runs during cluster creation.
     */
    public val onCreate: kotlin.String? = builder.onCreate
    /**
     * An Amazon S3 bucket path where your lifecycle scripts are stored.
     *
     * Make sure that the S3 bucket path starts with `s3://sagemaker-`. The [IAM role for SageMaker HyperPod](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-prerequisites.html#sagemaker-hyperpod-prerequisites-iam-role-for-hyperpod) has the managed `AmazonSageMakerClusterInstanceRolePolicy`[](https://docs.aws.amazon.com/sagemaker/latest/dg/security-iam-awsmanpol-cluster.html) attached, which allows access to S3 buckets with the specific prefix `sagemaker-`.
     */
    public val sourceS3Uri: kotlin.String? = builder.sourceS3Uri

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ClusterLifeCycleConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClusterLifeCycleConfig(")
        append("onCreate=$onCreate,")
        append("sourceS3Uri=$sourceS3Uri")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = onCreate?.hashCode() ?: 0
        result = 31 * result + (sourceS3Uri?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClusterLifeCycleConfig

        if (onCreate != other.onCreate) return false
        if (sourceS3Uri != other.sourceS3Uri) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ClusterLifeCycleConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The file name of the entrypoint script of lifecycle scripts under `SourceS3Uri`. This entrypoint script runs during cluster creation.
         */
        public var onCreate: kotlin.String? = null
        /**
         * An Amazon S3 bucket path where your lifecycle scripts are stored.
         *
         * Make sure that the S3 bucket path starts with `s3://sagemaker-`. The [IAM role for SageMaker HyperPod](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-prerequisites.html#sagemaker-hyperpod-prerequisites-iam-role-for-hyperpod) has the managed `AmazonSageMakerClusterInstanceRolePolicy`[](https://docs.aws.amazon.com/sagemaker/latest/dg/security-iam-awsmanpol-cluster.html) attached, which allows access to S3 buckets with the specific prefix `sagemaker-`.
         */
        public var sourceS3Uri: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ClusterLifeCycleConfig) : this() {
            this.onCreate = x.onCreate
            this.sourceS3Uri = x.sourceS3Uri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ClusterLifeCycleConfig = ClusterLifeCycleConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
