// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Configuration to control how SageMaker captures inference data for batch transform jobs.
 */
public class BatchDataCaptureConfig private constructor(builder: Builder) {
    /**
     * The Amazon S3 location being used to capture the data.
     */
    public val destinationS3Uri: kotlin.String? = builder.destinationS3Uri
    /**
     * Flag that indicates whether to append inference id to the output.
     */
    public val generateInferenceId: kotlin.Boolean? = builder.generateInferenceId
    /**
     * The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service key that SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the batch transform job.
     *
     * The KmsKeyId can be any of the following formats:
     * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Key ARN: `arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Alias name: `alias/ExampleAlias`
     * + Alias name ARN: `arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias`
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.BatchDataCaptureConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchDataCaptureConfig(")
        append("destinationS3Uri=$destinationS3Uri,")
        append("generateInferenceId=$generateInferenceId,")
        append("kmsKeyId=$kmsKeyId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationS3Uri?.hashCode() ?: 0
        result = 31 * result + (generateInferenceId?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchDataCaptureConfig

        if (destinationS3Uri != other.destinationS3Uri) return false
        if (generateInferenceId != other.generateInferenceId) return false
        if (kmsKeyId != other.kmsKeyId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.BatchDataCaptureConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon S3 location being used to capture the data.
         */
        public var destinationS3Uri: kotlin.String? = null
        /**
         * Flag that indicates whether to append inference id to the output.
         */
        public var generateInferenceId: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service key that SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the batch transform job.
         *
         * The KmsKeyId can be any of the following formats:
         * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Key ARN: `arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Alias name: `alias/ExampleAlias`
         * + Alias name ARN: `arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias`
         */
        public var kmsKeyId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.BatchDataCaptureConfig) : this() {
            this.destinationS3Uri = x.destinationS3Uri
            this.generateInferenceId = x.generateInferenceId
            this.kmsKeyId = x.kmsKeyId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.BatchDataCaptureConfig = BatchDataCaptureConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
