// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.AppStatus
import aws.sdk.kotlin.services.sagemaker.model.AppType
import aws.sdk.kotlin.services.sagemaker.model.DescribeAppResponse
import aws.sdk.kotlin.services.sagemaker.model.ResourceSpec
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeAppOperationDeserializer: HttpDeserializer.NonStreaming<DescribeAppResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeAppResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeAppError(context, call, payload)
        }
        val builder = DescribeAppResponse.Builder()

        if (payload != null) {
            deserializeDescribeAppOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeAppError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedCall, payload)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAppOperationBody(builder: DescribeAppResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AppArn"))
    val APPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AppName"))
    val APPTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("AppType"))
    val BUILTINLIFECYCLECONFIGARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BuiltInLifecycleConfigArn"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DOMAINID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DomainId"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FailureReason"))
    val LASTHEALTHCHECKTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastHealthCheckTimestamp"))
    val LASTUSERACTIVITYTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastUserActivityTimestamp"))
    val RESOURCESPEC_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ResourceSpec"))
    val SPACENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SpaceName"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val USERPROFILENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("UserProfileName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPARN_DESCRIPTOR)
        field(APPNAME_DESCRIPTOR)
        field(APPTYPE_DESCRIPTOR)
        field(BUILTINLIFECYCLECONFIGARN_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DOMAINID_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(LASTHEALTHCHECKTIMESTAMP_DESCRIPTOR)
        field(LASTUSERACTIVITYTIMESTAMP_DESCRIPTOR)
        field(RESOURCESPEC_DESCRIPTOR)
        field(SPACENAME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(USERPROFILENAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPARN_DESCRIPTOR.index -> builder.appArn = deserializeString()
                APPNAME_DESCRIPTOR.index -> builder.appName = deserializeString()
                APPTYPE_DESCRIPTOR.index -> builder.appType = deserializeString().let { AppType.fromValue(it) }
                BUILTINLIFECYCLECONFIGARN_DESCRIPTOR.index -> builder.builtInLifecycleConfigArn = deserializeString()
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DOMAINID_DESCRIPTOR.index -> builder.domainId = deserializeString()
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                LASTHEALTHCHECKTIMESTAMP_DESCRIPTOR.index -> builder.lastHealthCheckTimestamp = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                LASTUSERACTIVITYTIMESTAMP_DESCRIPTOR.index -> builder.lastUserActivityTimestamp = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                RESOURCESPEC_DESCRIPTOR.index -> builder.resourceSpec = deserializeResourceSpecDocument(deserializer)
                SPACENAME_DESCRIPTOR.index -> builder.spaceName = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { AppStatus.fromValue(it) }
                USERPROFILENAME_DESCRIPTOR.index -> builder.userProfileName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
