// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Defines the traffic routing strategy during an endpoint deployment to shift traffic from the old fleet to the new fleet.
 */
public class TrafficRoutingConfig private constructor(builder: Builder) {
    /**
     * Batch size for the first step to turn on traffic on the new endpoint fleet. `Value` must be less than or equal to 50% of the variant's total instance count.
     */
    public val canarySize: aws.sdk.kotlin.services.sagemaker.model.CapacitySize? = builder.canarySize
    /**
     * Batch size for each step to turn on traffic on the new endpoint fleet. `Value` must be 10-50% of the variant's total instance count.
     */
    public val linearStepSize: aws.sdk.kotlin.services.sagemaker.model.CapacitySize? = builder.linearStepSize
    /**
     * Traffic routing strategy type.
     * + `ALL_AT_ONCE`: Endpoint traffic shifts to the new fleet in a single step.
     * + `CANARY`: Endpoint traffic shifts to the new fleet in two steps. The first step is the canary, which is a small portion of the traffic. The second step is the remainder of the traffic.
     * + `LINEAR`: Endpoint traffic shifts to the new fleet in n steps of a configurable size.
     */
    public val type: aws.sdk.kotlin.services.sagemaker.model.TrafficRoutingConfigType? = builder.type
    /**
     * The waiting time (in seconds) between incremental steps to turn on traffic on the new endpoint fleet.
     */
    public val waitIntervalInSeconds: kotlin.Int? = builder.waitIntervalInSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.TrafficRoutingConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TrafficRoutingConfig(")
        append("canarySize=$canarySize,")
        append("linearStepSize=$linearStepSize,")
        append("type=$type,")
        append("waitIntervalInSeconds=$waitIntervalInSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = canarySize?.hashCode() ?: 0
        result = 31 * result + (linearStepSize?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (waitIntervalInSeconds ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TrafficRoutingConfig

        if (canarySize != other.canarySize) return false
        if (linearStepSize != other.linearStepSize) return false
        if (type != other.type) return false
        if (waitIntervalInSeconds != other.waitIntervalInSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.TrafficRoutingConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Batch size for the first step to turn on traffic on the new endpoint fleet. `Value` must be less than or equal to 50% of the variant's total instance count.
         */
        public var canarySize: aws.sdk.kotlin.services.sagemaker.model.CapacitySize? = null
        /**
         * Batch size for each step to turn on traffic on the new endpoint fleet. `Value` must be 10-50% of the variant's total instance count.
         */
        public var linearStepSize: aws.sdk.kotlin.services.sagemaker.model.CapacitySize? = null
        /**
         * Traffic routing strategy type.
         * + `ALL_AT_ONCE`: Endpoint traffic shifts to the new fleet in a single step.
         * + `CANARY`: Endpoint traffic shifts to the new fleet in two steps. The first step is the canary, which is a small portion of the traffic. The second step is the remainder of the traffic.
         * + `LINEAR`: Endpoint traffic shifts to the new fleet in n steps of a configurable size.
         */
        public var type: aws.sdk.kotlin.services.sagemaker.model.TrafficRoutingConfigType? = null
        /**
         * The waiting time (in seconds) between incremental steps to turn on traffic on the new endpoint fleet.
         */
        public var waitIntervalInSeconds: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.TrafficRoutingConfig) : this() {
            this.canarySize = x.canarySize
            this.linearStepSize = x.linearStepSize
            this.type = x.type
            this.waitIntervalInSeconds = x.waitIntervalInSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.TrafficRoutingConfig = TrafficRoutingConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.CapacitySize] inside the given [block]
         */
        public fun canarySize(block: aws.sdk.kotlin.services.sagemaker.model.CapacitySize.Builder.() -> kotlin.Unit) {
            this.canarySize = aws.sdk.kotlin.services.sagemaker.model.CapacitySize.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.CapacitySize] inside the given [block]
         */
        public fun linearStepSize(block: aws.sdk.kotlin.services.sagemaker.model.CapacitySize.Builder.() -> kotlin.Unit) {
            this.linearStepSize = aws.sdk.kotlin.services.sagemaker.model.CapacitySize.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
