// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains information about attribute-based access control (ABAC) for a training job. The session chaining configuration uses Amazon Security Token Service (STS) for your training job to request temporary, limited-privilege credentials to tenants. For more information, see [Attribute-based access control (ABAC) for multi-tenancy training](https://docs.aws.amazon.com/sagemaker/latest/dg/model-access-training-data.html#model-access-training-data-abac).
 */
public class SessionChainingConfig private constructor(builder: Builder) {
    /**
     * Set to `True` to allow SageMaker to extract session tags from a training job creation role and reuse these tags when assuming the training job execution role.
     */
    public val enableSessionTagChaining: kotlin.Boolean? = builder.enableSessionTagChaining

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.SessionChainingConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SessionChainingConfig(")
        append("enableSessionTagChaining=$enableSessionTagChaining")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enableSessionTagChaining?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SessionChainingConfig

        if (enableSessionTagChaining != other.enableSessionTagChaining) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.SessionChainingConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Set to `True` to allow SageMaker to extract session tags from a training job creation role and reuse these tags when assuming the training job execution role.
         */
        public var enableSessionTagChaining: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.SessionChainingConfig) : this() {
            this.enableSessionTagChaining = x.enableSessionTagChaining
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.SessionChainingConfig = SessionChainingConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
