// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Summarizes an optimization job by providing some of its key properties.
 */
public class OptimizationJobSummary private constructor(builder: Builder) {
    /**
     * The time when you created the optimization job.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The type of instance that hosts the optimized model that you create with the optimization job.
     */
    public val deploymentInstanceType: aws.sdk.kotlin.services.sagemaker.model.OptimizationJobDeploymentInstanceType? = builder.deploymentInstanceType
    /**
     * The time when the optimization job was last updated.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The time when the optimization job finished processing.
     */
    public val optimizationEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.optimizationEndTime
    /**
     * The Amazon Resource Name (ARN) of the optimization job.
     */
    public val optimizationJobArn: kotlin.String? = builder.optimizationJobArn
    /**
     * The name that you assigned to the optimization job.
     */
    public val optimizationJobName: kotlin.String? = builder.optimizationJobName
    /**
     * The current status of the optimization job.
     */
    public val optimizationJobStatus: aws.sdk.kotlin.services.sagemaker.model.OptimizationJobStatus? = builder.optimizationJobStatus
    /**
     * The time when the optimization job started.
     */
    public val optimizationStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.optimizationStartTime
    /**
     * The optimization techniques that are applied by the optimization job.
     */
    public val optimizationTypes: List<String>? = builder.optimizationTypes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.OptimizationJobSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OptimizationJobSummary(")
        append("creationTime=$creationTime,")
        append("deploymentInstanceType=$deploymentInstanceType,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("optimizationEndTime=$optimizationEndTime,")
        append("optimizationJobArn=$optimizationJobArn,")
        append("optimizationJobName=$optimizationJobName,")
        append("optimizationJobStatus=$optimizationJobStatus,")
        append("optimizationStartTime=$optimizationStartTime,")
        append("optimizationTypes=$optimizationTypes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (deploymentInstanceType?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (optimizationEndTime?.hashCode() ?: 0)
        result = 31 * result + (optimizationJobArn?.hashCode() ?: 0)
        result = 31 * result + (optimizationJobName?.hashCode() ?: 0)
        result = 31 * result + (optimizationJobStatus?.hashCode() ?: 0)
        result = 31 * result + (optimizationStartTime?.hashCode() ?: 0)
        result = 31 * result + (optimizationTypes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OptimizationJobSummary

        if (creationTime != other.creationTime) return false
        if (deploymentInstanceType != other.deploymentInstanceType) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (optimizationEndTime != other.optimizationEndTime) return false
        if (optimizationJobArn != other.optimizationJobArn) return false
        if (optimizationJobName != other.optimizationJobName) return false
        if (optimizationJobStatus != other.optimizationJobStatus) return false
        if (optimizationStartTime != other.optimizationStartTime) return false
        if (optimizationTypes != other.optimizationTypes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.OptimizationJobSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The time when you created the optimization job.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The type of instance that hosts the optimized model that you create with the optimization job.
         */
        public var deploymentInstanceType: aws.sdk.kotlin.services.sagemaker.model.OptimizationJobDeploymentInstanceType? = null
        /**
         * The time when the optimization job was last updated.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time when the optimization job finished processing.
         */
        public var optimizationEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the optimization job.
         */
        public var optimizationJobArn: kotlin.String? = null
        /**
         * The name that you assigned to the optimization job.
         */
        public var optimizationJobName: kotlin.String? = null
        /**
         * The current status of the optimization job.
         */
        public var optimizationJobStatus: aws.sdk.kotlin.services.sagemaker.model.OptimizationJobStatus? = null
        /**
         * The time when the optimization job started.
         */
        public var optimizationStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The optimization techniques that are applied by the optimization job.
         */
        public var optimizationTypes: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.OptimizationJobSummary) : this() {
            this.creationTime = x.creationTime
            this.deploymentInstanceType = x.deploymentInstanceType
            this.lastModifiedTime = x.lastModifiedTime
            this.optimizationEndTime = x.optimizationEndTime
            this.optimizationJobArn = x.optimizationJobArn
            this.optimizationJobName = x.optimizationJobName
            this.optimizationJobStatus = x.optimizationJobStatus
            this.optimizationStartTime = x.optimizationStartTime
            this.optimizationTypes = x.optimizationTypes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.OptimizationJobSummary = OptimizationJobSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
