// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Details about the resources to deploy with this inference component, including the model, container, and compute resources.
 */
public class InferenceComponentSpecification private constructor(builder: Builder) {
    /**
     * The compute resources allocated to run the model assigned to the inference component.
     */
    public val computeResourceRequirements: aws.sdk.kotlin.services.sagemaker.model.InferenceComponentComputeResourceRequirements? = builder.computeResourceRequirements
    /**
     * Defines a container that provides the runtime environment for a model that you deploy with an inference component.
     */
    public val container: aws.sdk.kotlin.services.sagemaker.model.InferenceComponentContainerSpecification? = builder.container
    /**
     * The name of an existing SageMaker model object in your account that you want to deploy with the inference component.
     */
    public val modelName: kotlin.String? = builder.modelName
    /**
     * Settings that take effect while the model container starts up.
     */
    public val startupParameters: aws.sdk.kotlin.services.sagemaker.model.InferenceComponentStartupParameters? = builder.startupParameters

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.InferenceComponentSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InferenceComponentSpecification(")
        append("computeResourceRequirements=$computeResourceRequirements,")
        append("container=$container,")
        append("modelName=$modelName,")
        append("startupParameters=$startupParameters")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = computeResourceRequirements?.hashCode() ?: 0
        result = 31 * result + (container?.hashCode() ?: 0)
        result = 31 * result + (modelName?.hashCode() ?: 0)
        result = 31 * result + (startupParameters?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InferenceComponentSpecification

        if (computeResourceRequirements != other.computeResourceRequirements) return false
        if (container != other.container) return false
        if (modelName != other.modelName) return false
        if (startupParameters != other.startupParameters) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.InferenceComponentSpecification = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The compute resources allocated to run the model assigned to the inference component.
         */
        public var computeResourceRequirements: aws.sdk.kotlin.services.sagemaker.model.InferenceComponentComputeResourceRequirements? = null
        /**
         * Defines a container that provides the runtime environment for a model that you deploy with an inference component.
         */
        public var container: aws.sdk.kotlin.services.sagemaker.model.InferenceComponentContainerSpecification? = null
        /**
         * The name of an existing SageMaker model object in your account that you want to deploy with the inference component.
         */
        public var modelName: kotlin.String? = null
        /**
         * Settings that take effect while the model container starts up.
         */
        public var startupParameters: aws.sdk.kotlin.services.sagemaker.model.InferenceComponentStartupParameters? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.InferenceComponentSpecification) : this() {
            this.computeResourceRequirements = x.computeResourceRequirements
            this.container = x.container
            this.modelName = x.modelName
            this.startupParameters = x.startupParameters
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.InferenceComponentSpecification = InferenceComponentSpecification(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.InferenceComponentComputeResourceRequirements] inside the given [block]
         */
        public fun computeResourceRequirements(block: aws.sdk.kotlin.services.sagemaker.model.InferenceComponentComputeResourceRequirements.Builder.() -> kotlin.Unit) {
            this.computeResourceRequirements = aws.sdk.kotlin.services.sagemaker.model.InferenceComponentComputeResourceRequirements.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.InferenceComponentContainerSpecification] inside the given [block]
         */
        public fun container(block: aws.sdk.kotlin.services.sagemaker.model.InferenceComponentContainerSpecification.Builder.() -> kotlin.Unit) {
            this.container = aws.sdk.kotlin.services.sagemaker.model.InferenceComponentContainerSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.InferenceComponentStartupParameters] inside the given [block]
         */
        public fun startupParameters(block: aws.sdk.kotlin.services.sagemaker.model.InferenceComponentStartupParameters.Builder.() -> kotlin.Unit) {
            this.startupParameters = aws.sdk.kotlin.services.sagemaker.model.InferenceComponentStartupParameters.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
