// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Settings related to idle shutdown of Studio applications.
 */
public class IdleSettings private constructor(builder: Builder) {
    /**
     * The time that SageMaker waits after the application becomes idle before shutting it down.
     */
    public val idleTimeoutInMinutes: kotlin.Int? = builder.idleTimeoutInMinutes
    /**
     * Indicates whether idle shutdown is activated for the application type.
     */
    public val lifecycleManagement: aws.sdk.kotlin.services.sagemaker.model.LifecycleManagement? = builder.lifecycleManagement
    /**
     * The maximum value in minutes that custom idle shutdown can be set to by the user.
     */
    public val maxIdleTimeoutInMinutes: kotlin.Int? = builder.maxIdleTimeoutInMinutes
    /**
     * The minimum value in minutes that custom idle shutdown can be set to by the user.
     */
    public val minIdleTimeoutInMinutes: kotlin.Int? = builder.minIdleTimeoutInMinutes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.IdleSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IdleSettings(")
        append("idleTimeoutInMinutes=$idleTimeoutInMinutes,")
        append("lifecycleManagement=$lifecycleManagement,")
        append("maxIdleTimeoutInMinutes=$maxIdleTimeoutInMinutes,")
        append("minIdleTimeoutInMinutes=$minIdleTimeoutInMinutes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = idleTimeoutInMinutes ?: 0
        result = 31 * result + (lifecycleManagement?.hashCode() ?: 0)
        result = 31 * result + (maxIdleTimeoutInMinutes ?: 0)
        result = 31 * result + (minIdleTimeoutInMinutes ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IdleSettings

        if (idleTimeoutInMinutes != other.idleTimeoutInMinutes) return false
        if (lifecycleManagement != other.lifecycleManagement) return false
        if (maxIdleTimeoutInMinutes != other.maxIdleTimeoutInMinutes) return false
        if (minIdleTimeoutInMinutes != other.minIdleTimeoutInMinutes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.IdleSettings = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The time that SageMaker waits after the application becomes idle before shutting it down.
         */
        public var idleTimeoutInMinutes: kotlin.Int? = null
        /**
         * Indicates whether idle shutdown is activated for the application type.
         */
        public var lifecycleManagement: aws.sdk.kotlin.services.sagemaker.model.LifecycleManagement? = null
        /**
         * The maximum value in minutes that custom idle shutdown can be set to by the user.
         */
        public var maxIdleTimeoutInMinutes: kotlin.Int? = null
        /**
         * The minimum value in minutes that custom idle shutdown can be set to by the user.
         */
        public var minIdleTimeoutInMinutes: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.IdleSettings) : this() {
            this.idleTimeoutInMinutes = x.idleTimeoutInMinutes
            this.lifecycleManagement = x.lifecycleManagement
            this.maxIdleTimeoutInMinutes = x.maxIdleTimeoutInMinutes
            this.minIdleTimeoutInMinutes = x.minIdleTimeoutInMinutes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.IdleSettings = IdleSettings(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
