// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information summarizing the deployment stage results.
 */
public class EdgeDeploymentStatus private constructor(builder: Builder) {
    /**
     * The number of edge devices that failed the deployment in current stage.
     */
    public val edgeDeploymentFailedInStage: kotlin.Int? = builder.edgeDeploymentFailedInStage
    /**
     * The number of edge devices yet to pick up the deployment in current stage, or in progress.
     */
    public val edgeDeploymentPendingInStage: kotlin.Int? = builder.edgeDeploymentPendingInStage
    /**
     * The time when the deployment API started.
     */
    public val edgeDeploymentStageStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.edgeDeploymentStageStartTime
    /**
     * A detailed message about deployment status in current stage.
     */
    public val edgeDeploymentStatusMessage: kotlin.String? = builder.edgeDeploymentStatusMessage
    /**
     * The number of edge devices with the successful deployment in the current stage.
     */
    public val edgeDeploymentSuccessInStage: kotlin.Int? = builder.edgeDeploymentSuccessInStage
    /**
     * The general status of the current stage.
     */
    public val stageStatus: aws.sdk.kotlin.services.sagemaker.model.StageStatus? = builder.stageStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.EdgeDeploymentStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EdgeDeploymentStatus(")
        append("edgeDeploymentFailedInStage=$edgeDeploymentFailedInStage,")
        append("edgeDeploymentPendingInStage=$edgeDeploymentPendingInStage,")
        append("edgeDeploymentStageStartTime=$edgeDeploymentStageStartTime,")
        append("edgeDeploymentStatusMessage=$edgeDeploymentStatusMessage,")
        append("edgeDeploymentSuccessInStage=$edgeDeploymentSuccessInStage,")
        append("stageStatus=$stageStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = edgeDeploymentFailedInStage ?: 0
        result = 31 * result + (edgeDeploymentPendingInStage ?: 0)
        result = 31 * result + (edgeDeploymentStageStartTime?.hashCode() ?: 0)
        result = 31 * result + (edgeDeploymentStatusMessage?.hashCode() ?: 0)
        result = 31 * result + (edgeDeploymentSuccessInStage ?: 0)
        result = 31 * result + (stageStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EdgeDeploymentStatus

        if (edgeDeploymentFailedInStage != other.edgeDeploymentFailedInStage) return false
        if (edgeDeploymentPendingInStage != other.edgeDeploymentPendingInStage) return false
        if (edgeDeploymentStageStartTime != other.edgeDeploymentStageStartTime) return false
        if (edgeDeploymentStatusMessage != other.edgeDeploymentStatusMessage) return false
        if (edgeDeploymentSuccessInStage != other.edgeDeploymentSuccessInStage) return false
        if (stageStatus != other.stageStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.EdgeDeploymentStatus = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of edge devices that failed the deployment in current stage.
         */
        public var edgeDeploymentFailedInStage: kotlin.Int? = null
        /**
         * The number of edge devices yet to pick up the deployment in current stage, or in progress.
         */
        public var edgeDeploymentPendingInStage: kotlin.Int? = null
        /**
         * The time when the deployment API started.
         */
        public var edgeDeploymentStageStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A detailed message about deployment status in current stage.
         */
        public var edgeDeploymentStatusMessage: kotlin.String? = null
        /**
         * The number of edge devices with the successful deployment in the current stage.
         */
        public var edgeDeploymentSuccessInStage: kotlin.Int? = null
        /**
         * The general status of the current stage.
         */
        public var stageStatus: aws.sdk.kotlin.services.sagemaker.model.StageStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.EdgeDeploymentStatus) : this() {
            this.edgeDeploymentFailedInStage = x.edgeDeploymentFailedInStage
            this.edgeDeploymentPendingInStage = x.edgeDeploymentPendingInStage
            this.edgeDeploymentStageStartTime = x.edgeDeploymentStageStartTime
            this.edgeDeploymentStatusMessage = x.edgeDeploymentStatusMessage
            this.edgeDeploymentSuccessInStage = x.edgeDeploymentSuccessInStage
            this.stageStatus = x.stageStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.EdgeDeploymentStatus = EdgeDeploymentStatus(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
