// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeTransformJobResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the AutoML transform job.
     */
    public val autoMlJobArn: kotlin.String? = builder.autoMlJobArn
    /**
     * Specifies the number of records to include in a mini-batch for an HTTP inference request. A *record*** is a single unit of input data that inference can be made on. For example, a single line in a CSV file is a record.
     *
     * To enable the batch strategy, you must set `SplitType` to `Line`, `RecordIO`, or `TFRecord`.
     */
    public val batchStrategy: aws.sdk.kotlin.services.sagemaker.model.BatchStrategy? = builder.batchStrategy
    /**
     * A timestamp that shows when the transform Job was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * Configuration to control how SageMaker captures inference data.
     */
    public val dataCaptureConfig: aws.sdk.kotlin.services.sagemaker.model.BatchDataCaptureConfig? = builder.dataCaptureConfig
    /**
     * The data structure used to specify the data to be used for inference in a batch transform job and to associate the data that is relevant to the prediction results in the output. The input filter provided allows you to exclude input data that is not needed for inference in a batch transform job. The output filter provided allows you to include input data relevant to interpreting the predictions in the output from the job. For more information, see [Associate Prediction Results with their Corresponding Input Records](https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html).
     */
    public val dataProcessing: aws.sdk.kotlin.services.sagemaker.model.DataProcessing? = builder.dataProcessing
    /**
     * The environment variables to set in the Docker container. We support up to 16 key and values entries in the map.
     */
    public val environment: Map<String, String>? = builder.environment
    /**
     * Associates a SageMaker job as a trial component with an experiment and trial. Specified when you call the following APIs:
     * + [CreateProcessingJob](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateProcessingJob.html)
     * + [CreateTrainingJob](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrainingJob.html)
     * + [CreateTransformJob](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTransformJob.html)
     */
    public val experimentConfig: aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig? = builder.experimentConfig
    /**
     * If the transform job failed, `FailureReason` describes why it failed. A transform job creates a log file, which includes error messages, and stores it as an Amazon S3 object. For more information, see [Log Amazon SageMaker Events with Amazon CloudWatch](https://docs.aws.amazon.com/sagemaker/latest/dg/logging-cloudwatch.html).
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The Amazon Resource Name (ARN) of the Amazon SageMaker Ground Truth labeling job that created the transform or training job.
     */
    public val labelingJobArn: kotlin.String? = builder.labelingJobArn
    /**
     * The maximum number of parallel requests on each instance node that can be launched in a transform job. The default value is 1.
     */
    public val maxConcurrentTransforms: kotlin.Int? = builder.maxConcurrentTransforms
    /**
     * The maximum payload size, in MB, used in the transform job.
     */
    public val maxPayloadInMb: kotlin.Int? = builder.maxPayloadInMb
    /**
     * The timeout and maximum number of retries for processing a transform job invocation.
     */
    public val modelClientConfig: aws.sdk.kotlin.services.sagemaker.model.ModelClientConfig? = builder.modelClientConfig
    /**
     * The name of the model used in the transform job.
     */
    public val modelName: kotlin.String? = builder.modelName
    /**
     * Indicates when the transform job has been completed, or has stopped or failed. You are billed for the time interval between this time and the value of `TransformStartTime`.
     */
    public val transformEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.transformEndTime
    /**
     * Describes the dataset to be transformed and the Amazon S3 location where it is stored.
     */
    public val transformInput: aws.sdk.kotlin.services.sagemaker.model.TransformInput? = builder.transformInput
    /**
     * The Amazon Resource Name (ARN) of the transform job.
     */
    public val transformJobArn: kotlin.String? = builder.transformJobArn
    /**
     * The name of the transform job.
     */
    public val transformJobName: kotlin.String? = builder.transformJobName
    /**
     * The status of the transform job. If the transform job failed, the reason is returned in the `FailureReason` field.
     */
    public val transformJobStatus: aws.sdk.kotlin.services.sagemaker.model.TransformJobStatus? = builder.transformJobStatus
    /**
     * Identifies the Amazon S3 location where you want Amazon SageMaker to save the results from the transform job.
     */
    public val transformOutput: aws.sdk.kotlin.services.sagemaker.model.TransformOutput? = builder.transformOutput
    /**
     * Describes the resources, including ML instance types and ML instance count, to use for the transform job.
     */
    public val transformResources: aws.sdk.kotlin.services.sagemaker.model.TransformResources? = builder.transformResources
    /**
     * Indicates when the transform job starts on ML instances. You are billed for the time interval between this time and the value of `TransformEndTime`.
     */
    public val transformStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.transformStartTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.DescribeTransformJobResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeTransformJobResponse(")
        append("autoMlJobArn=$autoMlJobArn,")
        append("batchStrategy=$batchStrategy,")
        append("creationTime=$creationTime,")
        append("dataCaptureConfig=$dataCaptureConfig,")
        append("dataProcessing=$dataProcessing,")
        append("environment=$environment,")
        append("experimentConfig=$experimentConfig,")
        append("failureReason=$failureReason,")
        append("labelingJobArn=$labelingJobArn,")
        append("maxConcurrentTransforms=$maxConcurrentTransforms,")
        append("maxPayloadInMb=$maxPayloadInMb,")
        append("modelClientConfig=$modelClientConfig,")
        append("modelName=$modelName,")
        append("transformEndTime=$transformEndTime,")
        append("transformInput=$transformInput,")
        append("transformJobArn=$transformJobArn,")
        append("transformJobName=$transformJobName,")
        append("transformJobStatus=$transformJobStatus,")
        append("transformOutput=$transformOutput,")
        append("transformResources=$transformResources,")
        append("transformStartTime=$transformStartTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoMlJobArn?.hashCode() ?: 0
        result = 31 * result + (batchStrategy?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (dataCaptureConfig?.hashCode() ?: 0)
        result = 31 * result + (dataProcessing?.hashCode() ?: 0)
        result = 31 * result + (environment?.hashCode() ?: 0)
        result = 31 * result + (experimentConfig?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (labelingJobArn?.hashCode() ?: 0)
        result = 31 * result + (maxConcurrentTransforms ?: 0)
        result = 31 * result + (maxPayloadInMb ?: 0)
        result = 31 * result + (modelClientConfig?.hashCode() ?: 0)
        result = 31 * result + (modelName?.hashCode() ?: 0)
        result = 31 * result + (transformEndTime?.hashCode() ?: 0)
        result = 31 * result + (transformInput?.hashCode() ?: 0)
        result = 31 * result + (transformJobArn?.hashCode() ?: 0)
        result = 31 * result + (transformJobName?.hashCode() ?: 0)
        result = 31 * result + (transformJobStatus?.hashCode() ?: 0)
        result = 31 * result + (transformOutput?.hashCode() ?: 0)
        result = 31 * result + (transformResources?.hashCode() ?: 0)
        result = 31 * result + (transformStartTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeTransformJobResponse

        if (autoMlJobArn != other.autoMlJobArn) return false
        if (batchStrategy != other.batchStrategy) return false
        if (creationTime != other.creationTime) return false
        if (dataCaptureConfig != other.dataCaptureConfig) return false
        if (dataProcessing != other.dataProcessing) return false
        if (environment != other.environment) return false
        if (experimentConfig != other.experimentConfig) return false
        if (failureReason != other.failureReason) return false
        if (labelingJobArn != other.labelingJobArn) return false
        if (maxConcurrentTransforms != other.maxConcurrentTransforms) return false
        if (maxPayloadInMb != other.maxPayloadInMb) return false
        if (modelClientConfig != other.modelClientConfig) return false
        if (modelName != other.modelName) return false
        if (transformEndTime != other.transformEndTime) return false
        if (transformInput != other.transformInput) return false
        if (transformJobArn != other.transformJobArn) return false
        if (transformJobName != other.transformJobName) return false
        if (transformJobStatus != other.transformJobStatus) return false
        if (transformOutput != other.transformOutput) return false
        if (transformResources != other.transformResources) return false
        if (transformStartTime != other.transformStartTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.DescribeTransformJobResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the AutoML transform job.
         */
        public var autoMlJobArn: kotlin.String? = null
        /**
         * Specifies the number of records to include in a mini-batch for an HTTP inference request. A *record*** is a single unit of input data that inference can be made on. For example, a single line in a CSV file is a record.
         *
         * To enable the batch strategy, you must set `SplitType` to `Line`, `RecordIO`, or `TFRecord`.
         */
        public var batchStrategy: aws.sdk.kotlin.services.sagemaker.model.BatchStrategy? = null
        /**
         * A timestamp that shows when the transform Job was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Configuration to control how SageMaker captures inference data.
         */
        public var dataCaptureConfig: aws.sdk.kotlin.services.sagemaker.model.BatchDataCaptureConfig? = null
        /**
         * The data structure used to specify the data to be used for inference in a batch transform job and to associate the data that is relevant to the prediction results in the output. The input filter provided allows you to exclude input data that is not needed for inference in a batch transform job. The output filter provided allows you to include input data relevant to interpreting the predictions in the output from the job. For more information, see [Associate Prediction Results with their Corresponding Input Records](https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html).
         */
        public var dataProcessing: aws.sdk.kotlin.services.sagemaker.model.DataProcessing? = null
        /**
         * The environment variables to set in the Docker container. We support up to 16 key and values entries in the map.
         */
        public var environment: Map<String, String>? = null
        /**
         * Associates a SageMaker job as a trial component with an experiment and trial. Specified when you call the following APIs:
         * + [CreateProcessingJob](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateProcessingJob.html)
         * + [CreateTrainingJob](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrainingJob.html)
         * + [CreateTransformJob](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTransformJob.html)
         */
        public var experimentConfig: aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig? = null
        /**
         * If the transform job failed, `FailureReason` describes why it failed. A transform job creates a log file, which includes error messages, and stores it as an Amazon S3 object. For more information, see [Log Amazon SageMaker Events with Amazon CloudWatch](https://docs.aws.amazon.com/sagemaker/latest/dg/logging-cloudwatch.html).
         */
        public var failureReason: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon SageMaker Ground Truth labeling job that created the transform or training job.
         */
        public var labelingJobArn: kotlin.String? = null
        /**
         * The maximum number of parallel requests on each instance node that can be launched in a transform job. The default value is 1.
         */
        public var maxConcurrentTransforms: kotlin.Int? = null
        /**
         * The maximum payload size, in MB, used in the transform job.
         */
        public var maxPayloadInMb: kotlin.Int? = null
        /**
         * The timeout and maximum number of retries for processing a transform job invocation.
         */
        public var modelClientConfig: aws.sdk.kotlin.services.sagemaker.model.ModelClientConfig? = null
        /**
         * The name of the model used in the transform job.
         */
        public var modelName: kotlin.String? = null
        /**
         * Indicates when the transform job has been completed, or has stopped or failed. You are billed for the time interval between this time and the value of `TransformStartTime`.
         */
        public var transformEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Describes the dataset to be transformed and the Amazon S3 location where it is stored.
         */
        public var transformInput: aws.sdk.kotlin.services.sagemaker.model.TransformInput? = null
        /**
         * The Amazon Resource Name (ARN) of the transform job.
         */
        public var transformJobArn: kotlin.String? = null
        /**
         * The name of the transform job.
         */
        public var transformJobName: kotlin.String? = null
        /**
         * The status of the transform job. If the transform job failed, the reason is returned in the `FailureReason` field.
         */
        public var transformJobStatus: aws.sdk.kotlin.services.sagemaker.model.TransformJobStatus? = null
        /**
         * Identifies the Amazon S3 location where you want Amazon SageMaker to save the results from the transform job.
         */
        public var transformOutput: aws.sdk.kotlin.services.sagemaker.model.TransformOutput? = null
        /**
         * Describes the resources, including ML instance types and ML instance count, to use for the transform job.
         */
        public var transformResources: aws.sdk.kotlin.services.sagemaker.model.TransformResources? = null
        /**
         * Indicates when the transform job starts on ML instances. You are billed for the time interval between this time and the value of `TransformEndTime`.
         */
        public var transformStartTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.DescribeTransformJobResponse) : this() {
            this.autoMlJobArn = x.autoMlJobArn
            this.batchStrategy = x.batchStrategy
            this.creationTime = x.creationTime
            this.dataCaptureConfig = x.dataCaptureConfig
            this.dataProcessing = x.dataProcessing
            this.environment = x.environment
            this.experimentConfig = x.experimentConfig
            this.failureReason = x.failureReason
            this.labelingJobArn = x.labelingJobArn
            this.maxConcurrentTransforms = x.maxConcurrentTransforms
            this.maxPayloadInMb = x.maxPayloadInMb
            this.modelClientConfig = x.modelClientConfig
            this.modelName = x.modelName
            this.transformEndTime = x.transformEndTime
            this.transformInput = x.transformInput
            this.transformJobArn = x.transformJobArn
            this.transformJobName = x.transformJobName
            this.transformJobStatus = x.transformJobStatus
            this.transformOutput = x.transformOutput
            this.transformResources = x.transformResources
            this.transformStartTime = x.transformStartTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.DescribeTransformJobResponse = DescribeTransformJobResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.BatchDataCaptureConfig] inside the given [block]
         */
        public fun dataCaptureConfig(block: aws.sdk.kotlin.services.sagemaker.model.BatchDataCaptureConfig.Builder.() -> kotlin.Unit) {
            this.dataCaptureConfig = aws.sdk.kotlin.services.sagemaker.model.BatchDataCaptureConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.DataProcessing] inside the given [block]
         */
        public fun dataProcessing(block: aws.sdk.kotlin.services.sagemaker.model.DataProcessing.Builder.() -> kotlin.Unit) {
            this.dataProcessing = aws.sdk.kotlin.services.sagemaker.model.DataProcessing.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig] inside the given [block]
         */
        public fun experimentConfig(block: aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig.Builder.() -> kotlin.Unit) {
            this.experimentConfig = aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ModelClientConfig] inside the given [block]
         */
        public fun modelClientConfig(block: aws.sdk.kotlin.services.sagemaker.model.ModelClientConfig.Builder.() -> kotlin.Unit) {
            this.modelClientConfig = aws.sdk.kotlin.services.sagemaker.model.ModelClientConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.TransformInput] inside the given [block]
         */
        public fun transformInput(block: aws.sdk.kotlin.services.sagemaker.model.TransformInput.Builder.() -> kotlin.Unit) {
            this.transformInput = aws.sdk.kotlin.services.sagemaker.model.TransformInput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.TransformOutput] inside the given [block]
         */
        public fun transformOutput(block: aws.sdk.kotlin.services.sagemaker.model.TransformOutput.Builder.() -> kotlin.Unit) {
            this.transformOutput = aws.sdk.kotlin.services.sagemaker.model.TransformOutput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.TransformResources] inside the given [block]
         */
        public fun transformResources(block: aws.sdk.kotlin.services.sagemaker.model.TransformResources.Builder.() -> kotlin.Unit) {
            this.transformResources = aws.sdk.kotlin.services.sagemaker.model.TransformResources.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
