// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateTransformJobRequest private constructor(builder: Builder) {
    /**
     * Specifies the number of records to include in a mini-batch for an HTTP inference request. A *record*** is a single unit of input data that inference can be made on. For example, a single line in a CSV file is a record.
     *
     * To enable the batch strategy, you must set the `SplitType` property to `Line`, `RecordIO`, or `TFRecord`.
     *
     * To use only one record when making an HTTP invocation request to a container, set `BatchStrategy` to `SingleRecord` and `SplitType` to `Line`.
     *
     * To fit as many records in a mini-batch as can fit within the `MaxPayloadInMB` limit, set `BatchStrategy` to `MultiRecord` and `SplitType` to `Line`.
     */
    public val batchStrategy: aws.sdk.kotlin.services.sagemaker.model.BatchStrategy? = builder.batchStrategy
    /**
     * Configuration to control how SageMaker captures inference data.
     */
    public val dataCaptureConfig: aws.sdk.kotlin.services.sagemaker.model.BatchDataCaptureConfig? = builder.dataCaptureConfig
    /**
     * The data structure used to specify the data to be used for inference in a batch transform job and to associate the data that is relevant to the prediction results in the output. The input filter provided allows you to exclude input data that is not needed for inference in a batch transform job. The output filter provided allows you to include input data relevant to interpreting the predictions in the output from the job. For more information, see [Associate Prediction Results with their Corresponding Input Records](https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html).
     */
    public val dataProcessing: aws.sdk.kotlin.services.sagemaker.model.DataProcessing? = builder.dataProcessing
    /**
     * The environment variables to set in the Docker container. Don't include any sensitive data in your environment variables. We support up to 16 key and values entries in the map.
     */
    public val environment: Map<String, String>? = builder.environment
    /**
     * Associates a SageMaker job as a trial component with an experiment and trial. Specified when you call the following APIs:
     * + [CreateProcessingJob](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateProcessingJob.html)
     * + [CreateTrainingJob](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrainingJob.html)
     * + [CreateTransformJob](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTransformJob.html)
     */
    public val experimentConfig: aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig? = builder.experimentConfig
    /**
     * The maximum number of parallel requests that can be sent to each instance in a transform job. If `MaxConcurrentTransforms` is set to `0` or left unset, Amazon SageMaker checks the optional execution-parameters to determine the settings for your chosen algorithm. If the execution-parameters endpoint is not enabled, the default value is `1`. For more information on execution-parameters, see [How Containers Serve Requests](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-batch-code.html#your-algorithms-batch-code-how-containe-serves-requests). For built-in algorithms, you don't need to set a value for `MaxConcurrentTransforms`.
     */
    public val maxConcurrentTransforms: kotlin.Int? = builder.maxConcurrentTransforms
    /**
     * The maximum allowed size of the payload, in MB. A *payload* is the data portion of a record (without metadata). The value in `MaxPayloadInMB` must be greater than, or equal to, the size of a single record. To estimate the size of a record in MB, divide the size of your dataset by the number of records. To ensure that the records fit within the maximum payload size, we recommend using a slightly larger value. The default value is `6` MB.
     *
     * The value of `MaxPayloadInMB` cannot be greater than 100 MB. If you specify the `MaxConcurrentTransforms` parameter, the value of `(MaxConcurrentTransforms * MaxPayloadInMB)` also cannot exceed 100 MB.
     *
     * For cases where the payload might be arbitrarily large and is transmitted using HTTP chunked encoding, set the value to `0`. This feature works only in supported algorithms. Currently, Amazon SageMaker built-in algorithms do not support HTTP chunked encoding.
     */
    public val maxPayloadInMb: kotlin.Int? = builder.maxPayloadInMb
    /**
     * Configures the timeout and maximum number of retries for processing a transform job invocation.
     */
    public val modelClientConfig: aws.sdk.kotlin.services.sagemaker.model.ModelClientConfig? = builder.modelClientConfig
    /**
     * The name of the model that you want to use for the transform job. `ModelName` must be the name of an existing Amazon SageMaker model within an Amazon Web Services Region in an Amazon Web Services account.
     */
    public val modelName: kotlin.String? = builder.modelName
    /**
     * (Optional) An array of key-value pairs. For more information, see [Using Cost Allocation Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what) in the *Amazon Web Services Billing and Cost Management User Guide*.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Describes the input source and the way the transform job consumes it.
     */
    public val transformInput: aws.sdk.kotlin.services.sagemaker.model.TransformInput? = builder.transformInput
    /**
     * The name of the transform job. The name must be unique within an Amazon Web Services Region in an Amazon Web Services account.
     */
    public val transformJobName: kotlin.String? = builder.transformJobName
    /**
     * Describes the results of the transform job.
     */
    public val transformOutput: aws.sdk.kotlin.services.sagemaker.model.TransformOutput? = builder.transformOutput
    /**
     * Describes the resources, including ML instance types and ML instance count, to use for the transform job.
     */
    public val transformResources: aws.sdk.kotlin.services.sagemaker.model.TransformResources? = builder.transformResources

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.CreateTransformJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateTransformJobRequest(")
        append("batchStrategy=$batchStrategy,")
        append("dataCaptureConfig=$dataCaptureConfig,")
        append("dataProcessing=$dataProcessing,")
        append("environment=$environment,")
        append("experimentConfig=$experimentConfig,")
        append("maxConcurrentTransforms=$maxConcurrentTransforms,")
        append("maxPayloadInMb=$maxPayloadInMb,")
        append("modelClientConfig=$modelClientConfig,")
        append("modelName=$modelName,")
        append("tags=$tags,")
        append("transformInput=$transformInput,")
        append("transformJobName=$transformJobName,")
        append("transformOutput=$transformOutput,")
        append("transformResources=$transformResources")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = batchStrategy?.hashCode() ?: 0
        result = 31 * result + (dataCaptureConfig?.hashCode() ?: 0)
        result = 31 * result + (dataProcessing?.hashCode() ?: 0)
        result = 31 * result + (environment?.hashCode() ?: 0)
        result = 31 * result + (experimentConfig?.hashCode() ?: 0)
        result = 31 * result + (maxConcurrentTransforms ?: 0)
        result = 31 * result + (maxPayloadInMb ?: 0)
        result = 31 * result + (modelClientConfig?.hashCode() ?: 0)
        result = 31 * result + (modelName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (transformInput?.hashCode() ?: 0)
        result = 31 * result + (transformJobName?.hashCode() ?: 0)
        result = 31 * result + (transformOutput?.hashCode() ?: 0)
        result = 31 * result + (transformResources?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateTransformJobRequest

        if (batchStrategy != other.batchStrategy) return false
        if (dataCaptureConfig != other.dataCaptureConfig) return false
        if (dataProcessing != other.dataProcessing) return false
        if (environment != other.environment) return false
        if (experimentConfig != other.experimentConfig) return false
        if (maxConcurrentTransforms != other.maxConcurrentTransforms) return false
        if (maxPayloadInMb != other.maxPayloadInMb) return false
        if (modelClientConfig != other.modelClientConfig) return false
        if (modelName != other.modelName) return false
        if (tags != other.tags) return false
        if (transformInput != other.transformInput) return false
        if (transformJobName != other.transformJobName) return false
        if (transformOutput != other.transformOutput) return false
        if (transformResources != other.transformResources) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.CreateTransformJobRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the number of records to include in a mini-batch for an HTTP inference request. A *record*** is a single unit of input data that inference can be made on. For example, a single line in a CSV file is a record.
         *
         * To enable the batch strategy, you must set the `SplitType` property to `Line`, `RecordIO`, or `TFRecord`.
         *
         * To use only one record when making an HTTP invocation request to a container, set `BatchStrategy` to `SingleRecord` and `SplitType` to `Line`.
         *
         * To fit as many records in a mini-batch as can fit within the `MaxPayloadInMB` limit, set `BatchStrategy` to `MultiRecord` and `SplitType` to `Line`.
         */
        public var batchStrategy: aws.sdk.kotlin.services.sagemaker.model.BatchStrategy? = null
        /**
         * Configuration to control how SageMaker captures inference data.
         */
        public var dataCaptureConfig: aws.sdk.kotlin.services.sagemaker.model.BatchDataCaptureConfig? = null
        /**
         * The data structure used to specify the data to be used for inference in a batch transform job and to associate the data that is relevant to the prediction results in the output. The input filter provided allows you to exclude input data that is not needed for inference in a batch transform job. The output filter provided allows you to include input data relevant to interpreting the predictions in the output from the job. For more information, see [Associate Prediction Results with their Corresponding Input Records](https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html).
         */
        public var dataProcessing: aws.sdk.kotlin.services.sagemaker.model.DataProcessing? = null
        /**
         * The environment variables to set in the Docker container. Don't include any sensitive data in your environment variables. We support up to 16 key and values entries in the map.
         */
        public var environment: Map<String, String>? = null
        /**
         * Associates a SageMaker job as a trial component with an experiment and trial. Specified when you call the following APIs:
         * + [CreateProcessingJob](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateProcessingJob.html)
         * + [CreateTrainingJob](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrainingJob.html)
         * + [CreateTransformJob](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTransformJob.html)
         */
        public var experimentConfig: aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig? = null
        /**
         * The maximum number of parallel requests that can be sent to each instance in a transform job. If `MaxConcurrentTransforms` is set to `0` or left unset, Amazon SageMaker checks the optional execution-parameters to determine the settings for your chosen algorithm. If the execution-parameters endpoint is not enabled, the default value is `1`. For more information on execution-parameters, see [How Containers Serve Requests](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-batch-code.html#your-algorithms-batch-code-how-containe-serves-requests). For built-in algorithms, you don't need to set a value for `MaxConcurrentTransforms`.
         */
        public var maxConcurrentTransforms: kotlin.Int? = null
        /**
         * The maximum allowed size of the payload, in MB. A *payload* is the data portion of a record (without metadata). The value in `MaxPayloadInMB` must be greater than, or equal to, the size of a single record. To estimate the size of a record in MB, divide the size of your dataset by the number of records. To ensure that the records fit within the maximum payload size, we recommend using a slightly larger value. The default value is `6` MB.
         *
         * The value of `MaxPayloadInMB` cannot be greater than 100 MB. If you specify the `MaxConcurrentTransforms` parameter, the value of `(MaxConcurrentTransforms * MaxPayloadInMB)` also cannot exceed 100 MB.
         *
         * For cases where the payload might be arbitrarily large and is transmitted using HTTP chunked encoding, set the value to `0`. This feature works only in supported algorithms. Currently, Amazon SageMaker built-in algorithms do not support HTTP chunked encoding.
         */
        public var maxPayloadInMb: kotlin.Int? = null
        /**
         * Configures the timeout and maximum number of retries for processing a transform job invocation.
         */
        public var modelClientConfig: aws.sdk.kotlin.services.sagemaker.model.ModelClientConfig? = null
        /**
         * The name of the model that you want to use for the transform job. `ModelName` must be the name of an existing Amazon SageMaker model within an Amazon Web Services Region in an Amazon Web Services account.
         */
        public var modelName: kotlin.String? = null
        /**
         * (Optional) An array of key-value pairs. For more information, see [Using Cost Allocation Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what) in the *Amazon Web Services Billing and Cost Management User Guide*.
         */
        public var tags: List<Tag>? = null
        /**
         * Describes the input source and the way the transform job consumes it.
         */
        public var transformInput: aws.sdk.kotlin.services.sagemaker.model.TransformInput? = null
        /**
         * The name of the transform job. The name must be unique within an Amazon Web Services Region in an Amazon Web Services account.
         */
        public var transformJobName: kotlin.String? = null
        /**
         * Describes the results of the transform job.
         */
        public var transformOutput: aws.sdk.kotlin.services.sagemaker.model.TransformOutput? = null
        /**
         * Describes the resources, including ML instance types and ML instance count, to use for the transform job.
         */
        public var transformResources: aws.sdk.kotlin.services.sagemaker.model.TransformResources? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.CreateTransformJobRequest) : this() {
            this.batchStrategy = x.batchStrategy
            this.dataCaptureConfig = x.dataCaptureConfig
            this.dataProcessing = x.dataProcessing
            this.environment = x.environment
            this.experimentConfig = x.experimentConfig
            this.maxConcurrentTransforms = x.maxConcurrentTransforms
            this.maxPayloadInMb = x.maxPayloadInMb
            this.modelClientConfig = x.modelClientConfig
            this.modelName = x.modelName
            this.tags = x.tags
            this.transformInput = x.transformInput
            this.transformJobName = x.transformJobName
            this.transformOutput = x.transformOutput
            this.transformResources = x.transformResources
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.CreateTransformJobRequest = CreateTransformJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.BatchDataCaptureConfig] inside the given [block]
         */
        public fun dataCaptureConfig(block: aws.sdk.kotlin.services.sagemaker.model.BatchDataCaptureConfig.Builder.() -> kotlin.Unit) {
            this.dataCaptureConfig = aws.sdk.kotlin.services.sagemaker.model.BatchDataCaptureConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.DataProcessing] inside the given [block]
         */
        public fun dataProcessing(block: aws.sdk.kotlin.services.sagemaker.model.DataProcessing.Builder.() -> kotlin.Unit) {
            this.dataProcessing = aws.sdk.kotlin.services.sagemaker.model.DataProcessing.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig] inside the given [block]
         */
        public fun experimentConfig(block: aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig.Builder.() -> kotlin.Unit) {
            this.experimentConfig = aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ModelClientConfig] inside the given [block]
         */
        public fun modelClientConfig(block: aws.sdk.kotlin.services.sagemaker.model.ModelClientConfig.Builder.() -> kotlin.Unit) {
            this.modelClientConfig = aws.sdk.kotlin.services.sagemaker.model.ModelClientConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.TransformInput] inside the given [block]
         */
        public fun transformInput(block: aws.sdk.kotlin.services.sagemaker.model.TransformInput.Builder.() -> kotlin.Unit) {
            this.transformInput = aws.sdk.kotlin.services.sagemaker.model.TransformInput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.TransformOutput] inside the given [block]
         */
        public fun transformOutput(block: aws.sdk.kotlin.services.sagemaker.model.TransformOutput.Builder.() -> kotlin.Unit) {
            this.transformOutput = aws.sdk.kotlin.services.sagemaker.model.TransformOutput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.TransformResources] inside the given [block]
         */
        public fun transformResources(block: aws.sdk.kotlin.services.sagemaker.model.TransformResources.Builder.() -> kotlin.Unit) {
            this.transformResources = aws.sdk.kotlin.services.sagemaker.model.TransformResources.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
