// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateClusterRequest private constructor(builder: Builder) {
    /**
     * The name for the new SageMaker HyperPod cluster.
     */
    public val clusterName: kotlin.String? = builder.clusterName
    /**
     * The instance groups to be created in the SageMaker HyperPod cluster.
     */
    public val instanceGroups: List<ClusterInstanceGroupSpecification>? = builder.instanceGroups
    /**
     * The node recovery mode for the SageMaker HyperPod cluster. When set to `Automatic`, SageMaker HyperPod will automatically reboot or replace faulty nodes when issues are detected. When set to `None`, cluster administrators will need to manually manage any faulty cluster instances.
     */
    public val nodeRecovery: aws.sdk.kotlin.services.sagemaker.model.ClusterNodeRecovery? = builder.nodeRecovery
    /**
     * The type of orchestrator to use for the SageMaker HyperPod cluster. Currently, the only supported value is `"eks"`, which is to use an Amazon Elastic Kubernetes Service (EKS) cluster as the orchestrator.
     */
    public val orchestrator: aws.sdk.kotlin.services.sagemaker.model.ClusterOrchestrator? = builder.orchestrator
    /**
     * Custom tags for managing the SageMaker HyperPod cluster as an Amazon Web Services resource. You can add tags to your cluster in the same way you add them in other Amazon Web Services services that support tagging. To learn more about tagging Amazon Web Services resources in general, see [Tagging Amazon Web Services Resources User Guide](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html).
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to. You can control access to and from your resources by configuring a VPC. For more information, see [Give SageMaker Access to Resources in your Amazon VPC](https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html).
     */
    public val vpcConfig: aws.sdk.kotlin.services.sagemaker.model.VpcConfig? = builder.vpcConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.CreateClusterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateClusterRequest(")
        append("clusterName=$clusterName,")
        append("instanceGroups=$instanceGroups,")
        append("nodeRecovery=$nodeRecovery,")
        append("orchestrator=$orchestrator,")
        append("tags=$tags,")
        append("vpcConfig=$vpcConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterName?.hashCode() ?: 0
        result = 31 * result + (instanceGroups?.hashCode() ?: 0)
        result = 31 * result + (nodeRecovery?.hashCode() ?: 0)
        result = 31 * result + (orchestrator?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateClusterRequest

        if (clusterName != other.clusterName) return false
        if (instanceGroups != other.instanceGroups) return false
        if (nodeRecovery != other.nodeRecovery) return false
        if (orchestrator != other.orchestrator) return false
        if (tags != other.tags) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.CreateClusterRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name for the new SageMaker HyperPod cluster.
         */
        public var clusterName: kotlin.String? = null
        /**
         * The instance groups to be created in the SageMaker HyperPod cluster.
         */
        public var instanceGroups: List<ClusterInstanceGroupSpecification>? = null
        /**
         * The node recovery mode for the SageMaker HyperPod cluster. When set to `Automatic`, SageMaker HyperPod will automatically reboot or replace faulty nodes when issues are detected. When set to `None`, cluster administrators will need to manually manage any faulty cluster instances.
         */
        public var nodeRecovery: aws.sdk.kotlin.services.sagemaker.model.ClusterNodeRecovery? = null
        /**
         * The type of orchestrator to use for the SageMaker HyperPod cluster. Currently, the only supported value is `"eks"`, which is to use an Amazon Elastic Kubernetes Service (EKS) cluster as the orchestrator.
         */
        public var orchestrator: aws.sdk.kotlin.services.sagemaker.model.ClusterOrchestrator? = null
        /**
         * Custom tags for managing the SageMaker HyperPod cluster as an Amazon Web Services resource. You can add tags to your cluster in the same way you add them in other Amazon Web Services services that support tagging. To learn more about tagging Amazon Web Services resources in general, see [Tagging Amazon Web Services Resources User Guide](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html).
         */
        public var tags: List<Tag>? = null
        /**
         * Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to. You can control access to and from your resources by configuring a VPC. For more information, see [Give SageMaker Access to Resources in your Amazon VPC](https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html).
         */
        public var vpcConfig: aws.sdk.kotlin.services.sagemaker.model.VpcConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.CreateClusterRequest) : this() {
            this.clusterName = x.clusterName
            this.instanceGroups = x.instanceGroups
            this.nodeRecovery = x.nodeRecovery
            this.orchestrator = x.orchestrator
            this.tags = x.tags
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.CreateClusterRequest = CreateClusterRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ClusterOrchestrator] inside the given [block]
         */
        public fun orchestrator(block: aws.sdk.kotlin.services.sagemaker.model.ClusterOrchestrator.Builder.() -> kotlin.Unit) {
            this.orchestrator = aws.sdk.kotlin.services.sagemaker.model.ClusterOrchestrator.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.VpcConfig] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.sagemaker.model.VpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.sagemaker.model.VpcConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
